
 /*************************************************************************/
 /*************************************************************************

 NA-17  :  A C++ Program to determine whether the given function is a Cubic
	   Spline or not.

  *************************************************************************/
 /*************************************************************************/
 /*************************************************************************

	  By :
		Muhammad Tahir Shahzad  [ MTS ]
		B.C.S Honours  [ 2000-04 ]
		Government College University Lahore
		Pakistan

      E-mail :  mtshome@wol.net.pk

    Web-Site :  www.mts-home.cjb.net  [ www.wol.net.pk/mtshome ]
		www.mtshome.cjb.net   [ www.geocities.com/mtahirshahzad ]

  *************************************************************************/

 /*************************************************************************/
 /*************************************************************************/
 //---------------------------  Header Files  ----------------------------//
 /*************************************************************************/
 /*************************************************************************/

 # include <iostream.h>
 # include   <stdlib.h>
 # include   <string.h>
 # include    <stdio.h>
 # include    <conio.h>
 # include     <math.h>

 /*************************************************************************/
 /*************************************************************************/
 //------------------------  Global Variables  ---------------------------//
 /*************************************************************************/
 /*************************************************************************/

 const int max_size=13;

 int n=0;
 int top=-1;
 int error_flag=0;

 long double xn[max_size]={0};
 long double fx[max_size]={0};

 char Sx[max_size][100]={NULL};
 char Dsx[max_size][100]={NULL};
 char D2sx[max_size][100]={NULL};

 char Stack[30][30]={NULL};
 char Postfix_expression[max_size][30][30]={NULL};

 /*************************************************************************/
 /*************************************************************************/
 //------------------------  Funcion Prototypes  -------------------------//
 /*************************************************************************/
 /*************************************************************************/

 void push(const char *);
 void convert_ie_to_pe(const char *,const int);

 const char* pop( );
 const long double evaluate_postfix_expression(const long double,const int);

 void show_screen( );
 void clear_screen( );
 void get_input( );
 void get_polynomials( );
 void get_first_derivatives( );
 void get_second_derivatives( );
 void check_condition_1( );
 void check_condition_2( );
 void check_condition_3( );
 void check_condition_4( );
 void check_condition_5( );
 void check_natural_boundry_conditions( );
 void check_clamped_boundry_conditions( );
 void show_result( );

 /*************************************************************************/
 /*************************************************************************/
 //------------------------------  main( )  ------------------------------//
 /*************************************************************************/
 /*************************************************************************/

 int main( )
    {
       clrscr( );
       textmode(C4350);

       show_screen( );
       get_input( );
       get_polynomials( );
       get_first_derivatives( );
       get_second_derivatives( );

       check_condition_1( );

       if(!error_flag)
	  check_condition_2( );

       if(!error_flag)
	  check_condition_3( );

       if(!error_flag)
	  check_condition_4( );

       if(!error_flag)
	  check_condition_5( );

       show_result( );

       getch( );

       return 0;
     }

 /*************************************************************************/
 /*************************************************************************/
 //------------------------  Funcion Definitions  ------------------------//
 /*************************************************************************/
 /*************************************************************************/

 /*************************************************************************/
 //--------------------------  show_screen( )  ---------------------------//
 /*************************************************************************/

 void show_screen( )
    {
       cprintf("\n********************************************************************************");
       cprintf("***************************-                          -*************************");
       cprintf("*--------------------------- ");

       textbackground(1);
       cprintf(" Cubic Spline Functions ");
       textbackground(8);

       cprintf(" -------------------------*");
       cprintf("***************************-                          -*************************");
       cprintf("*-****************************************************************************-*");

       for(int count=0;count<42;count++)
	  cprintf("*-*                                                                          *-*");

       gotoxy(1,46);
       cprintf("*-****************************************************************************-*");
       cprintf("*------------------------------------------------------------------------------*");
       cprintf("********************************************************************************");

       gotoxy(1,2);
    }

 /*************************************************************************/
 //-------------------------  clear_screen( )  ---------------------------//
 /*************************************************************************/

 void clear_screen( )
    {
       for(int count=0;count<37;count++)
	  {
	     gotoxy(5,8+count);
	     cout<<"                                                                        ";
	  }

       gotoxy(1,2);
    }

 /*************************************************************************/
 //--------------------------  push(const char*)  ------------------------//
 /*************************************************************************/

 void push(const char* Operand)
    {
       if(top==(max_size-1))
	  {
	     cout<<"Error : Stack is full."<<endl;
	     cout<<"\n        Press any key to exit.";

	     getch( );
	     exit(0);
	  }

       else
	  {
	     top++;
	     strcpy(Stack[top],Operand);
	  }
    }

 /*************************************************************************/
 //------------------------------  pop( )  -------------------------------//
 /*************************************************************************/

 const char* pop( )
    {
       char Operand[40]={NULL};

       if(top==-1)
	  {
	     cout<<"Error : Stack is empty."<<endl;
	     cout<<"\n        Press any key to exit.";

	     getch( );
	     exit(0);
	  }

       else
	  {
	     strcpy(Operand,Stack[top]);
	     strset(Stack[top],NULL);
	     top--;
	  }

       return Operand;
    }

 /*************************************************************************/
 //--------------  convert_ie_to_pe(const char*,const int)  --------------//
 /*************************************************************************/

 void convert_ie_to_pe(const char* Expression,const int index)
    {
       char Infix_expression[100]={NULL};
       char Symbol_scanned[30]={NULL};

       push("(");
       strcpy(Infix_expression,Expression);
       strcat(Infix_expression,"+0)");

       int flag=0;
       int count_1=0;
       int count_2=0;
       int equation_length=strlen(Infix_expression);

       if(Infix_expression[0]=='(')
	  flag=1;

       do
	  {
	     strset(Symbol_scanned,NULL);

	     if(flag==0)
		{
		   int count_3=0;

		   do
		      {
			 Symbol_scanned[count_3]=Infix_expression[count_1];

			 count_1++;
			 count_3++;
		      }
		   while(count_1<=equation_length &&
			   Infix_expression[count_1]!='(' &&
			      Infix_expression[count_1]!='+' &&
				 Infix_expression[count_1]!='-' &&
				    Infix_expression[count_1]!='*' &&
				       Infix_expression[count_1]!='/' &&
					  Infix_expression[count_1]!='^' &&
					     Infix_expression[count_1]!=')');


		   flag=1;
		}

	     else if(flag==1)
		{
		   Symbol_scanned[0]=Infix_expression[count_1];

		   count_1++;

		   if(Infix_expression[count_1]!='(' &&
			 Infix_expression[count_1]!='^' &&
			    Infix_expression[count_1]!='*' &&
			       Infix_expression[count_1]!='/' &&
				  Infix_expression[count_1]!='+' &&
				     Infix_expression[count_1]!='-' &&
					Infix_expression[count_1]!=')')
		      flag=0;

		   if(Infix_expression[count_1-1]=='(' &&
			   (Infix_expression[count_1]=='-' ||
				 Infix_expression[count_1]=='+'))
		      flag=0;
		}

	     if(strcmp(Symbol_scanned,"(")==0)
		push("(");

	     else if(strcmp(Symbol_scanned,")")==0)
		{
		   while(strcmp(Stack[top],"(")!=0)
		      {
			 strcpy(Postfix_expression[index][count_2],pop( ));

			 count_2++;
		      }

		   pop( );
		}

	     else if(strcmp(Symbol_scanned,"^")==0 ||
			   strcmp(Symbol_scanned,"+")==0 ||
				 strcmp(Symbol_scanned,"-")==0 ||
				       strcmp(Symbol_scanned,"*")==0 ||
					     strcmp(Symbol_scanned,"/")==0)
		{
		   if(strcmp(Symbol_scanned,"^")==0)
		      {  }

		   else if(strcmp(Symbol_scanned,"*")==0 ||
					      strcmp(Symbol_scanned,"/")==0)
		      {
			 while(strcmp(Stack[top],"^")==0 ||
				     strcmp(Stack[top],"*")==0 ||
					   strcmp(Stack[top],"/")==0)
			    {
			       strcpy(Postfix_expression[index][count_2],pop( ));

			       count_2++;
			    }
		      }

		   else if(strcmp(Symbol_scanned,"+")==0 ||
				    strcmp(Symbol_scanned,"-")==0)
		      {
			 while(strcmp(Stack[top],"(")!=0)
			    {
			       strcpy(Postfix_expression[index][count_2],pop( ));

			       count_2++;
			    }
		      }

		   push(Symbol_scanned);
		}

	     else
		{
		   strcat(Postfix_expression[index][count_2],Symbol_scanned);

		   count_2++;
		}
	  }
       while(strcmp(Stack[top],NULL)!=0);

       strcat(Postfix_expression[index][count_2],"=");
       count_2++;
    }

 /*************************************************************************/
 //-----  evaluate_postfix_expression(const long double,const int)  ------//
 /*************************************************************************/

 const long double evaluate_postfix_expression(
					const long double x,const int index)
    {
       long double function_value=0;

       int count_1=-1;

       char Symbol_scanned[30]={NULL};

       do
	  {
	     count_1++;

	     strcpy(Symbol_scanned,Postfix_expression[index][count_1]);

	     if(strcmp(Symbol_scanned,"^")==0 ||
		      strcmp(Symbol_scanned,"*")==0 ||
			    strcmp(Symbol_scanned,"/")==0 ||
				  strcmp(Symbol_scanned,"+")==0 ||
					strcmp(Symbol_scanned,"-")==0)

		{
		   char Result[30]={NULL};
		   char Operand[2][30]={NULL};

		   strcpy(Operand[0],pop( ));
		   strcpy(Operand[1],pop( ));

		   long double operand[2]={0};
		   long double result=0;

		   char *endptr;

		   for(int count_2=0;count_2<2;count_2++)
		      {
			 int flag=0;

			 if(Operand[count_2][0]=='-')
			    {
			       int length=strlen(Operand[count_2]);

			       for(int count_3=0;count_3<(length-1);count_3++)
				  Operand[count_2][count_3]=Operand[count_2][(count_3+1)];

			       Operand[count_2][count_3]=NULL;

			       flag=1;
			    }

			 if(strcmp(Operand[count_2],"x")==0)
			    operand[count_2]=x;

			 else if(strcmp(Operand[count_2],"e")==0)
			    operand[count_2]=2.718282;

			 else if(strcmp(Operand[count_2],"sinx")==0)
			    operand[count_2]=sinl(x);

			 else if(strcmp(Operand[count_2],"cosx")==0)
			    operand[count_2]=cosl(x);

			 else if(strcmp(Operand[count_2],"tanx")==0)
			    operand[count_2]=tanl(x);

			 else if(strcmp(Operand[count_2],"lnx")==0)
			    operand[count_2]=logl(x);

			 else if(strcmp(Operand[count_2],"logx")==0)
			    operand[count_2]=log10l(x);

			 else
			    operand[count_2]=strtod(Operand[count_2],&endptr);

			 if(flag)
			    operand[count_2]*=-1;
		      }

		   switch(Symbol_scanned[0])
		      {
			 case '^' : result=powl(operand[1],operand[0]);
				    break;

			 case '*' : result=operand[1]*operand[0];
				    break;

			 case '/' : result=operand[1]/operand[0];
				    break;

			 case '+' : result=operand[1]+operand[0];
				    break;

			 case '-' : result=operand[1]-operand[0];
				    break;
		      }

		   gcvt(result,25,Result);

		   push(Result);
		}

	     else if(strcmp(Symbol_scanned,"=")!=0)
		push(Symbol_scanned);
	  }
       while(strcmp(Symbol_scanned,"=")!=0);

       char Function_value[30]={NULL};
       char *endptr;

       strcpy(Function_value,pop( ));
       function_value=strtod(Function_value,&endptr);

       return function_value;
    }

 /*************************************************************************/
 //-----------------------------  get_input( )  --------------------------//
 /*************************************************************************/

 void get_input( )
    {
       do
	  {
	     clear_screen( );

	     gotoxy(6,9);
	     cout<<"Number of Distinct Data Points :";

	     gotoxy(6,10);
	     cout<<"";

	     gotoxy(27,13);
	     cout<<"[ min. n = 3  |  max. n = 12 ]";

	     gotoxy(6,12);
	     cout<<"Enter the max. number of distinct data points = n = ";

	     cin>>n;

	     if(n<3 || n>12)
		{
		   gotoxy(12,25);
		   cout<<"Error : Wrong Input. Press <Esc> to exit or any other key";

		   gotoxy(12,26);
		   cout<<"        to try again.";

		   n=int(getche( ));

		   if(n==27)
		      exit(0);
		}
	  }
       while(n<3 || n>12);

       clear_screen( );

       gotoxy(6,9);
       cout<<"Data Points & Values of Function :";

       gotoxy(6,10);
       cout<<"";

       gotoxy(25,12);
       cout<<"Ŀ";

       gotoxy(25,13);
       cout<<"       x            f(x)      ";

       gotoxy(25,14);
       cout<<"Ĵ";

       gotoxy(25,15);
       cout<<"                              ";

       for(int count_1=0;count_1<n;count_1++)
	  {
	     gotoxy(25,(wherey( )+1));
	     cout<<"                              ";

	     gotoxy(25,(wherey( )+1));
	     cout<<"                              ";
	  }

       gotoxy(25,(wherey( )+1));
       cout<<"";

       gotoxy(25,15);

       for(int count_2=0;count_2<n;count_2++)
	  {
	     gotoxy(25,(wherey( )+1));

	     gotoxy(27,wherey( ));
	     cin>>xn[count_2];

	     gotoxy(43,(wherey( )-1));
	     cin>>fx[count_2];
	  }

       gotoxy(25,43);
       cout<<"Press any key to continue...";

       getch( );
    }

 /*************************************************************************/
 //------------------------  get_polynomials( )  -------------------------//
 /*************************************************************************/

 void get_polynomials( )
    {
       clear_screen( );

       gotoxy(6,9);
       cout<<"Cubic Polynomials :";

       gotoxy(6,10);
       cout<<"";

       gotoxy(6,12);
       cout<<"Note : Write the Polynomials with proper Braces e.g; 2x+3 as (2*x)+3.";

       gotoxy(10,15);

       for(int count=0;count<(n-1);count++)
	  {
	     gotoxy(10,(wherey( )+1));
	     cout<<"S"<<count<<"(x) =  ";

	     gotoxy(wherex( ),wherey( ));
	     cin>>Sx[count];

	     convert_ie_to_pe(Sx[count],count);
	  }

       gotoxy(25,44);
       cout<<"Press any key to continue...";

       getch( );
    }

 /*************************************************************************/
 //----------------------  get_first_derivatives( )  ---------------------//
 /*************************************************************************/

 void get_first_derivatives( )
    {
       clear_screen( );

       gotoxy(6,9);
       cout<<"First Derivatives :";

       gotoxy(6,10);
       cout<<"";

       gotoxy(6,12);
       cout<<"Note : Write the function with proper Braces e.g; 2x+3 as (2*x)+3.";

       gotoxy(10,15);

       for(int count=0;count<(n-1);count++)
	  {
	     gotoxy(10,(wherey( )+1));
	     cout<<"S'"<<count<<"(x) =  ";

	     gotoxy(wherex( ),wherey( ));
	     cin>>Dsx[count];
	  }

       gotoxy(25,44);
       cout<<"Press any key to continue...";

       getch( );
    }

 /*************************************************************************/
 //---------------------  get_second_derivatives( )  ---------------------//
 /*************************************************************************/

 void get_second_derivatives( )
    {
       clear_screen( );

       gotoxy(6,9);
       cout<<"Second Derivatives :";

       gotoxy(6,10);
       cout<<"";

       gotoxy(6,12);
       cout<<"Note : Write the function with proper Braces e.g; 2x+3 as (2*x)+3.";

       gotoxy(10,15);

       for(int count=0;count<(n-1);count++)
	  {
	     gotoxy(10,(wherey( )+1));
	     cout<<"S\""<<count<<"(x) =  ";

	     gotoxy(wherex( ),wherey( ));
	     cin>>D2sx[count];
	  }

       gotoxy(25,44);
       cout<<"Press any key to continue...";

       getch( );
    }

 /*************************************************************************/
 //------------------------  check_condition_1( )  -----------------------//
 /*************************************************************************/

 void check_condition_1( )
    {
       clear_screen( );

       gotoxy(6,9);
       cout<<"Condition-I :";

       gotoxy(6,10);
       cout<<"";

       gotoxy(12,12);
       cout<<"S is a Cubic Polynomial, denoted by Si, on the interval [xi,xi+1]";

       gotoxy(6,14);
       cout<<"for each i=0,1,2,...,n-1.";

       gotoxy(10,15);

       for(int count=0;count<(n-1);count++)
	  {
	     gotoxy(10,(wherey( )+2));
	     cout<<"S"<<count<<"(x) =  "<<Sx[count]<<"     , "<<xn[count]<<"x"<<xn[(count+1)];
	  }

       gotoxy(10,(wherey( )+3));
       cout<<"*** Condition-I proved.";

       gotoxy(25,44);
       cout<<"Press any key to continue...";

       getch( );
    }

 /*************************************************************************/
 //------------------------  check_condition_2( )  -----------------------//
 /*************************************************************************/

 void check_condition_2( )
    {
       clear_screen( );

       gotoxy(6,9);
       cout<<"Condition-II :";

       gotoxy(6,10);
       cout<<"";

       gotoxy(10,12);
       cout<<"S(xi) = f(xi)       , for each i=0,1,2,...,n";

       long double sx=0;

       gotoxy(10,14);

       for(int count=0;count<n;count++)
	  {
	     sx=0;

	     if(count==(n-1))
		sx=evaluate_postfix_expression(xn[count],(count-1));

	     else
		sx=evaluate_postfix_expression(xn[count],count);

	     gotoxy(10,(wherey( )+2));
	     cout<<"S("<<xn[count]<<") =  "<<sx;

	     gotoxy(35,wherey( ));
	     cout<<"f("<<xn[count]<<") =  "<<fx[count];

	     gotoxy(60,wherey( ));

	     if(sx==fx[count])
		cout<<",  Ok";

	     else
		{
		   cout<<",  Failed";

		   error_flag=1;

		   break;
		}
	  }

       gotoxy(10,(wherey( )+3));

       if(!error_flag)
	  cout<<"*** Condition-II proved.";

       else
	  cout<<"*** Condition-II failed.";

       gotoxy(25,44);
       cout<<"Press any key to continue...";

       getch( );
    }

 /*************************************************************************/
 //------------------------  check_condition_3( )  -----------------------//
 /*************************************************************************/

 void check_condition_3( )
    {
       clear_screen( );

       gotoxy(6,9);
       cout<<"Condition-III :";

       gotoxy(6,10);
       cout<<"";

       gotoxy(10,12);
       cout<<"Si(xi+1) = Si+1(xi+1)       , each for i=0,1,2,...,n-2";

       long double six=0;
       long double sip1x=0;

       gotoxy(10,14);

       for(int count=0;count<(n-2);count++)
	  {
	     six=0;
	     sip1x=0;

	     six=evaluate_postfix_expression(xn[(count+1)],count);
	     sip1x=evaluate_postfix_expression(xn[(count+1)],(count+1));

	     gotoxy(10,(wherey( )+2));
	     cout<<"S"<<count<<"("<<xn[(count+1)]<<") =  "<<six;

	     gotoxy(35,wherey( ));
	     cout<<"S"<<(count+1)<<"("<<xn[(count+1)]<<") =  "<<sip1x;

	     gotoxy(60,wherey( ));

	     if(six==sip1x)
		cout<<",  Ok";

	     else
		{
		   cout<<",  Failed";

		   error_flag=1;

		   break;
		}
	  }

       gotoxy(10,(wherey( )+3));

       if(!error_flag)
	  cout<<"*** Condition-III proved.";

       else
	  cout<<"*** Condition-III failed.";

       gotoxy(25,44);
       cout<<"Press any key to continue...";

       getch( );
    }

 /*************************************************************************/
 //------------------------  check_condition_4( )  -----------------------//
 /*************************************************************************/

 void check_condition_4( )
    {
       for(int count_1=0;count_1<n;count_1++)
	  {
	     for(int count_2=0;count_2<30;count_2++)
		strset(Postfix_expression[count_1][count_2],NULL);

	     convert_ie_to_pe(Dsx[count_1],count_1);
	  }

       clear_screen( );

       gotoxy(6,9);
       cout<<"Condition-IV :";

       gotoxy(6,10);
       cout<<"";

       gotoxy(10,12);
       cout<<"S'i(xi+1) = S'i+1(xi+1)       , for each i=0,1,2,...,n-2";

       long double six=0;
       long double sip1x=0;

       gotoxy(10,14);

       for(int count_3=0;count_3<(n-2);count_3++)
	  {
	     six=0;
	     sip1x=0;

	     six=evaluate_postfix_expression(xn[(count_3+1)],count_3);
	     sip1x=evaluate_postfix_expression(xn[(count_3+1)],(count_3+1));

	     gotoxy(10,(wherey( )+2));
	     cout<<"S'"<<count_3<<"("<<xn[(count_3+1)]<<") =  "<<six;

	     gotoxy(35,wherey( ));
	     cout<<"S'"<<(count_3+1)<<"("<<xn[(count_3+1)]<<") =  "<<sip1x;

	     gotoxy(60,wherey( ));

	     if(six==sip1x)
		cout<<",  Ok";

	     else
		{
		   cout<<",  Failed";

		   error_flag=1;

		   break;
		}
	  }

       gotoxy(10,(wherey( )+3));

       if(!error_flag)
	  cout<<"*** Condition-IV proved.";

       else
	  cout<<"*** Condition-IV failed.";

       gotoxy(25,44);
       cout<<"Press any key to continue...";

       getch( );
    }

 /*************************************************************************/
 //------------------------  check_condition_5( )  -----------------------//
 /*************************************************************************/

 void check_condition_5( )
    {
       for(int count_1=0;count_1<n;count_1++)
	  {
	     for(int count_2=0;count_2<30;count_2++)
		strset(Postfix_expression[count_1][count_2],NULL);

	     convert_ie_to_pe(D2sx[count_1],count_1);
	  }

       clear_screen( );

       gotoxy(6,9);
       cout<<"Condition-V :";

       gotoxy(6,10);
       cout<<"";

       gotoxy(10,12);
       cout<<"S\"i(xi+1) = S\"i+1(xi+1)       , for each i=0,1,2,...,n-2";

       long double six=0;
       long double sip1x=0;

       gotoxy(10,14);

       for(int count_3=0;count_3<(n-2);count_3++)
	  {
	     six=0;
	     sip1x=0;

	     six=evaluate_postfix_expression(xn[(count_3+1)],count_3);
	     sip1x=evaluate_postfix_expression(xn[(count_3+1)],(count_3+1));

	     gotoxy(10,(wherey( )+2));
	     cout<<"S\""<<count_3<<"("<<xn[(count_3+1)]<<") =  "<<six;

	     gotoxy(35,wherey( ));
	     cout<<"S\""<<(count_3+1)<<"("<<xn[(count_3+1)]<<") =  "<<sip1x;

	     gotoxy(60,wherey( ));

	     if(six==sip1x)
		cout<<",  Ok";

	     else
		{
		   cout<<",  Failed";

		   error_flag=1;

		   break;
		}
	  }

       gotoxy(10,(wherey( )+3));

       if(!error_flag)
	  cout<<"*** Condition-V proved.";

       else
	  cout<<"*** Condition-V failed.";

       gotoxy(25,44);
       cout<<"Press any key to continue...";

       getch( );
    }

 /*************************************************************************/
 //---------------  check_natural_boundry_conditions( )  -----------------//
 /*************************************************************************/

 void check_natural_boundry_conditions( )
    {
       for(int count_1=0;count_1<n;count_1++)
	  {
	     for(int count_2=0;count_2<30;count_2++)
		strset(Postfix_expression[count_1][count_2],NULL);

	     convert_ie_to_pe(D2sx[count_1],count_1);
	  }

       clear_screen( );

       gotoxy(6,9);
       cout<<"Natural Boundry Conditions :";

       gotoxy(6,10);
       cout<<"";

       gotoxy(10,12);
       cout<<"S\"(x0) = S\"(xn) = 0";

       long double d2sx0=0;
       long double d2sxn=0;

       d2sx0=evaluate_postfix_expression(xn[0],0);
       d2sxn=evaluate_postfix_expression(xn[(n-1)],(n-2));

       gotoxy(10,16);
       cout<<"S\"("<<xn[0]<<") =  "<<d2sx0;

       gotoxy(10,18);
       cout<<"S\"("<<xn[(n-1)]<<") =  "<<d2sxn;

       gotoxy(10,22);

       if(d2sx0==0 && d2sxn==0)
	  {
	     cout<<"S\"("<<xn[0]<<") = S\"("<<xn[(n-1)]<<") = 0          ,  Ok";

	     error_flag=4;
	  }

       else
	  {
	     cout<<"S\"("<<xn[0]<<") != S\"("<<xn[(n-1)]<<") != 0          ,  Failed";

	     error_flag=2;
	  }

       gotoxy(10,25);

       if(error_flag==4)
	  cout<<"*** Natural or Free Boundry Conditions proved.";

       else
	  cout<<"*** Natural or Free Boundry Conditions Failed.";

       gotoxy(25,44);
       cout<<"Press any key to continue...";

       getch( );
    }

 /*************************************************************************/
 //---------------  check_clamped_boundry_conditions( )  -----------------//
 /*************************************************************************/

 void check_clamped_boundry_conditions( )
    {
       for(int count_1=0;count_1<n;count_1++)
	  {
	     for(int count_2=0;count_2<30;count_2++)
		strset(Postfix_expression[count_1][count_2],NULL);

	     convert_ie_to_pe(Dsx[count_1],count_1);
	  }

       clear_screen( );

       gotoxy(6,9);
       cout<<"Clamped Boundry Conditions :";

       gotoxy(6,10);
       cout<<"";

       gotoxy(10,12);
       cout<<"S'(x0) = f'(x0)          &&         S'(xn) = f'(xn)";

       long double dfx0=0;
       long double dfxn=0;
       long double dsx0=0;
       long double dsxn=0;

       gotoxy(6,16);
       cout<<"Enter the value of f'(x0) = ";

       cin>>dfx0;

       gotoxy(6,18);
       cout<<"Enter the value of f'(xn) = ";

       cin>>dfxn;

       dsx0=evaluate_postfix_expression(xn[0],0);
       dsxn=evaluate_postfix_expression(xn[(n-1)],(n-2));

       gotoxy(10,22);
       cout<<"S'("<<xn[0]<<") =  "<<dsx0;

       gotoxy(10,24);
       cout<<"S'("<<xn[(n-1)]<<") =  "<<dsxn;

       gotoxy(10,28);

       if(dsx0==dfx0)
	  {
	     cout<<"S'("<<xn[0]<<") = f'("<<xn[0]<<")         , Ok";

	     error_flag=5;
	  }

       else
	  {
	     cout<<"S'("<<xn[0]<<") != f'("<<xn[0]<<")         , Failed";

	     error_flag=3;
	  }

       gotoxy(10,30);

       if(dsxn==dfxn)
	  {
	     cout<<"S'("<<xn[(n-1)]<<") = f'("<<xn[(n-1)]<<")         , Ok";

	     error_flag=5;
	  }

       else if(dsxn!=dfxn)
	  {
	     cout<<"S'("<<xn[(n-1)]<<") != f'("<<xn[(n-1)]<<")         , Failed ";

	     error_flag=3;
	  }

       gotoxy(10,33);

       if(error_flag==5)
	  cout<<"*** Clamped Boundry Conditions proved.";

       else
	  cout<<"*** Clamped Boundry Conditions Failed.";

       gotoxy(25,44);
       cout<<"Press any key to continue...";

       getch( );
    }

 /*************************************************************************/
 //---------------------------  show_result( )  --------------------------//
 /*************************************************************************/

 void show_result( )
    {
       clear_screen( );

       gotoxy(6,9);
       cout<<"Result :";

       gotoxy(6,10);
       cout<<"";

       gotoxy(10,12);

       if(error_flag==1)
	  cout<<"The given function is not a Cubic Spline.";

       else
	  {
	     if(error_flag==0)
		cout<<"The given function is a Cubic Spline.";

	     else if(error_flag==2)
		cout<<"The given function is a Cubic Spline but not Natural Spline.";

	     else if(error_flag==3)
		cout<<"The given function is a Cubic Spline but not Clamped Spline.";

	     else if(error_flag==4)
		cout<<"The given function is a Natural Cubic Spline.";

	     else if(error_flag==5)
		cout<<"The given function is a Clamped Cubic Spline.";

	     gotoxy(6,19);
	     cout<<"Nature of Spline Function :";

	     gotoxy(6,20);
	     cout<<"";

	     gotoxy(8,23);
	     cout<<"Press :";

	     gotoxy(10,25);
	     cout<<"- <N> to Test for Natural Cubic Spline";

	     gotoxy(10,27);
	     cout<<"- <C> to Test for Clamped Cubic Spline";

	     gotoxy(10,29);
	     cout<<"- <Esc> to Exit";

	     gotoxy(6,32);
	     cout<<"Enter your choice :  ";

	     char Choice=getch( );


	     if(Choice=='N' || Choice=='n')
		{
		   check_natural_boundry_conditions( );
		   show_result( );
		}

	     else if(Choice=='C' || Choice=='c')
		{
		   check_clamped_boundry_conditions( );
		   show_result( );
		}

	     else
		{
		   cout<<"Esc";

		   exit(0);
		}
	  }

       gotoxy(1,2);
    }

 /*************************************************************************/
 /*************************************************************************/
 //-----------------------------  THE END  -------------------------------//
 /*************************************************************************/
 /*************************************************************************/