
 /*************************************************************************/
 /*************************************************************************

 NA-18  :  A C++ Program to construct Clamped Cubic Spline Interpolant from
	   the given data.

  *************************************************************************/
 /*************************************************************************/

  /*************************************************************************

	  By :
		Muhammad Tahir Shahzad  [ MTS ]
		B.C.S Honours  [ 2000-04 ]
		Government College University Lahore
		Pakistan

      E-mail :  mtshome@wol.net.pk

    Web-Site :  www.mts-home.cjb.net  [ www.wol.net.pk/mtshome ]
		www.mtshome.cjb.net   [ www.geocities.com/mtahirshahzad ]

  *************************************************************************/

 /*************************************************************************/
 /*************************************************************************/
 //---------------------------  Header Files  ----------------------------//
 /*************************************************************************/
 /*************************************************************************/

 # include <iostream.h>
 # include   <stdlib.h>
 # include   <string.h>
 # include    <stdio.h>
 # include    <conio.h>
 # include     <math.h>

 /*************************************************************************/
 /*************************************************************************/
 //------------------------  Global Variables  ---------------------------//
 /*************************************************************************/
 /*************************************************************************/

 const int max_size=13;

 int n=0;

 long double dfx0=0;
 long double dfxn=0;

 long double an[max_size]={0};
 long double bn[max_size]={0};
 long double cn[max_size]={0};
 long double dn[max_size]={0};

 long double fx[max_size]={0};
 long double xn[max_size]={0};

 /*************************************************************************/
 /*************************************************************************/
 //------------------------  Funcion Prototypes  -------------------------//
 /*************************************************************************/
 /*************************************************************************/

 void show_screen( );
 void clear_screen( );
 void get_input( );
 void generate_clamped_cubic_spline( );
 void show_clamped_cubic_spline( );

 /*************************************************************************/
 /*************************************************************************/
 //------------------------------  main( )  ------------------------------//
 /*************************************************************************/
 /*************************************************************************/

 int main( )
    {
       clrscr( );
       textmode(C4350);

       show_screen( );
       get_input( );
       generate_clamped_cubic_spline( );
       show_clamped_cubic_spline( );

       getch( );
       return 0;
     }

 /*************************************************************************/
 /*************************************************************************/
 //------------------------  Funcion Definitions  ------------------------//
 /*************************************************************************/
 /*************************************************************************/

 /*************************************************************************/
 //--------------------------  show_screen( )  ---------------------------//
 /*************************************************************************/

 void show_screen( )
    {
       cprintf("\n********************************************************************************");
       cprintf("**************-                                                    -************");
       cprintf("*-------------- ");

       textbackground(1);
       cprintf(" Construction of Clamped Cubic Spline Interpolant ");
       textbackground(8);

       cprintf(" ------------*");
       cprintf("*-************-                                                    -**********-*");
       cprintf("*-****************************************************************************-*");

       for(int count=0;count<42;count++)
	  cprintf("*-*                                                                          *-*");

       gotoxy(1,46);
       cprintf("*-****************************************************************************-*");
       cprintf("*------------------------------------------------------------------------------*");
       cprintf("********************************************************************************");

       gotoxy(1,2);
    }

 /*************************************************************************/
 //-------------------------  clear_screen( )  ---------------------------//
 /*************************************************************************/

 void clear_screen( )
    {
       for(int count=0;count<37;count++)
	  {
	     gotoxy(5,8+count);
	     cout<<"                                                                        ";
	  }

       gotoxy(1,2);
    }

 /*************************************************************************/
 //-----------------------------  get_input( )  --------------------------//
 /*************************************************************************/

 void get_input( )
    {
       do
	  {
	     clear_screen( );

	     gotoxy(6,9);
	     cout<<"Number of Distinct Data Points :";

	     gotoxy(6,10);
	     cout<<"";

	     gotoxy(27,13);
	     cout<<"[ min. n = 3  |  max. n = 12 ]";

	     gotoxy(6,12);
	     cout<<"Enter the max. number of distinct data points = n = ";

	     cin>>n;

	     if(n<3 || n>12)
		{
		   gotoxy(12,25);
		   cout<<"Error : Wrong Input. Press <Esc> to exit or any other key";

		   gotoxy(12,26);
		   cout<<"        to try again.";

		   n=int(getche( ));

		   if(n==27)
		      exit(0);
		}
	  }
       while(n<3 || n>12);

       clear_screen( );

       gotoxy(6,9);
       cout<<"Data Points & Values of Function :";

       gotoxy(6,10);
       cout<<"";

       gotoxy(16,12);
       cout<<"Ŀ";

       gotoxy(16,13);
       cout<<"       x            f(x)           f'(x)     ";

       gotoxy(16,14);
       cout<<"Ĵ";

       gotoxy(16,15);
       cout<<"                                             ";

       for(int count_1=0;count_1<n;count_1++)
	  {
	     gotoxy(16,(wherey( )+1));
	     cout<<"                                             ";

	     gotoxy(16,(wherey( )+1));
	     cout<<"                                             ";
	  }

       gotoxy(16,(wherey( )+1));
       cout<<"";

       gotoxy(16,15);

       for(int count_2=0;count_2<n;count_2++)
	  {
	     gotoxy(16,(wherey( )+1));

	     gotoxy(18,wherey( ));
	     cin>>xn[count_2];

	     gotoxy(34,(wherey( )-1));
	     cin>>fx[count_2];

	     if(count_2==0)
		{
		   gotoxy(50,(wherey( )-1));
		   cin>>dfx0;
		}

	     else if(count_2==(n-1))
		{
		   gotoxy(50,(wherey( )-1));
		   cin>>dfxn;
		}

	     else
		{
		   gotoxy(50,(wherey( )-1));
		   cout<<"-\n";
		}
	  }

       gotoxy(25,43);
       cout<<"Press any key to continue...";

       getch( );
    }

 /*************************************************************************/
 //-----------------  generate_clamped_cubic_spline( )  ------------------//
 /*************************************************************************/

 void generate_clamped_cubic_spline( )
    {
       // set ai=f(xi)     for i=0,1,2,3,...,n
       for(int count_1=0;count_1<n;count_1++)
	  an[count_1]=fx[count_1];

       long double temp_1[max_size]={0};      // hi
       long double temp_2[max_size]={0};      // ai
       long double temp_3[max_size]={0};      // li
       long double temp_4[max_size]={0};      // ui
       long double temp_5[max_size]={0};      // zi

       // set hi=x(i+1)-xi     for i=0,1,2,3,...,n-1
       for(int count_2=0;count_2<(n-1);count_2++)
	  temp_1[count_2]=(xn[count_2+1]-xn[count_2]);

       // set ai0=3(a1-a0)/hi0-3dfx0
       // set ain=3dfxn-3{an-an(n-1)}/hi(n-1)
       temp_2[0]=(((3*(an[1]-an[0]))/temp_1[0])-(3*dfx0));
       temp_2[(n-1)]=((3*dfxn)-((3*(an[(n-1)]-an[(n-2)]))/temp_1[(n-2)]));

       // set ai=(3/hi)*[a(i+1)-ai]-[3/h(i-1)]*[ai-a(i-1)]     for i=1,1,2,3,...,n-1
       for(int count_3=1;count_3<(n-1);count_3++)
	  temp_2[count_3]=(((3/temp_1[count_3])*(an[(count_3+1)]-an[count_3]))-((3/(temp_1[(count_3-1)])*(an[count_3]-an[(count_3-1)]))));

       // set li0=2hi0
       //     ui0=0.5
       //     zi0=ai0/li0
       temp_3[0]=(2*temp_1[0]);
       temp_4[0]=0.5;
       temp_5[0]=(temp_2[0]/temp_1[0]);

       // for i=1,1,2,3,...,n-1 ,set
       //    li=[2*{x(i+1)-x(i-1)}]-[h(i-1)*u(i-1)]
       //    ui=hi/li
       //    zi=[ai-{h(i-1)*z(i-1)}]/li
       for(int count_4=1;count_4<(n-1);count_4++)
	  {
	     temp_3[count_4]=((2*(xn[(count_4+1)]-xn[(count_4-1)]))-(temp_1[(count_4-1)]*temp_4[(count_4-1)]));
	     temp_4[count_4]=(temp_1[count_4]/temp_3[count_4]);
	     temp_5[count_4]=((temp_2[count_4]-(temp_1[(count_4-1)]*temp_5[(count_4-1)]))/temp_3[count_4]);
	  }

       // set lin=h(n-1){2-ui(n-1)}
       //     zin={ain-hi(n-1)zi(n-1)}/lin
       //     cn=zin
       temp_3[(n-1)]=(temp_1[(n-2)]*(2-temp_4[(n-2)]));
       temp_5[(n-1)]=((temp_2[(n-1)]-(temp_1[(n-2)]*temp_5[(n-2)]))/temp_3[(n-1)]);
       cn[(n-1)]=temp_5[(n-1)];

       // for i=n-1,n-2,...,0   , set
       //     ci=zi-[ui*c(i+1)]
       //     bi=[a(i+1)-ai]/[hi-{hi*{c(i+1)+{2*ci}}/3]
       //     di=[c(i+1)-ci]/[3*hi]
       for(int count_5=(n-2);count_5>=0;count_5--)
	  {
	     cn[count_5]=(temp_5[count_5]-(temp_4[count_5]*cn[(count_5+1)]));
	     bn[count_5]=(((an[(count_5+1)]-an[count_5])/temp_1[count_5])-((temp_1[count_5]*(cn[(count_5+1)]+(2*cn[count_5])))/3));
	     dn[count_5]=((cn[(count_5+1)]-cn[count_5])/(3*temp_1[count_5]));
	  }
    }

 /*************************************************************************/
 //--------------------  show_clamped_cubic_spline( )  -------------------//
 /*************************************************************************/

 void show_clamped_cubic_spline( )
    {
       clear_screen( );

       gotoxy(6,9);
       cout<<"Clamped Cubic Spline :";

       gotoxy(6,10);
       cout<<"";

       gotoxy(10,12);
       cout<<"The required Cubic Polynomials are :";

       for(int count=0;count<(n-1);count++)
	  {
	     gotoxy(10,(15+(count*2)));
	     cout<<"S"<<count<<"(x) =  ";

	     long double aix=0;
	     long double bix=0;
	     long double cix=0;
	     long double dix=0;

	     aix=(an[count]-(bn[count]*xn[count])+(cn[count]*powl(xn[count],2))-(dn[count]*powl(xn[count],3)));
	     bix=(bn[count]-(2*cn[count]*xn[count])+(3*dn[count]*powl(xn[count],3)));
	     cix=(cn[count]-(3*dn[count]*xn[count]));
	     dix=dn[count];

	     cout<<aix;

	     if(bix>=0)
		cout<<" + ";

	     else
		cout<<" - ";

	     cout<<fabsl(bix)<<"x";

	     if(cix>=0)
		cout<<" + ";

	     else
		cout<<" - ";

	     cout<<fabsl(cix)<<"x2";

	     if(dix>=0)
		cout<<" + ";

	     else
		cout<<" - ";

	     cout<<fabsl(dix)<<"x3";
	  }

       gotoxy(1,2);
    }

 /*************************************************************************/
 /*************************************************************************/
 //-----------------------------  THE END  -------------------------------//
 /*************************************************************************/
 /*************************************************************************/