
 /*************************************************************************/
 /*************************************************************************

 NA-20  :  A C++ Program to estimate the value of First Derivative of the
	   function at the given points from the given data using Backward
	   Difference Formula and Forward Difference Formula of Order One.

  *************************************************************************/
 /*************************************************************************/
 /*************************************************************************

	  By :
		Muhammad Tahir Shahzad  [ MTS ]
		B.C.S Honours  [ 2000-04 ]
		Government College University Lahore
		Pakistan

      E-mail :  mtshome@wol.net.pk

    Web-Site :  www.mts-home.cjb.net  [ www.wol.net.pk/mtshome ]
		www.mtshome.cjb.net   [ www.geocities.com/mtahirshahzad ]

  *************************************************************************/

 /*************************************************************************/
 /*************************************************************************/
 //---------------------------  Header Files  ----------------------------//
 /*************************************************************************/
 /*************************************************************************/

 # include <iostream.h>
 # include   <stdlib.h>
 # include   <string.h>
 # include    <stdio.h>
 # include    <conio.h>
 # include    <ctype.h>
 # include     <math.h>

 /*************************************************************************/
 /*************************************************************************/
 //------------------------  Global Variables  ---------------------------//
 /*************************************************************************/
 /*************************************************************************/

 const int max_size=13;

 int n=0;
 int top=-1;
 int choice=0;

 long double h=0;
 long double x0=0;

 long double xn[max_size]={0};
 long double fx[max_size]={0};

 char Fx[100]={NULL};
 char Dfx[100]={NULL};
 char Stack[30][30]={NULL};
 char Postfix_expression[2][30][30]={NULL};

 /*************************************************************************/
 /*************************************************************************/
 //------------------------  Funcion Prototypes  -------------------------//
 /*************************************************************************/
 /*************************************************************************/

 void push(const char *);
 void convert_ie_to_pe(const char *,const int);

 const char* pop( );
 const long double evaluate_postfix_expression(const long double,const int);

 void show_screen( );
 void clear_screen( );
 void get_input( );
 void estimate_dfx( );

 const int get_index(const long double);

 /*************************************************************************/
 /*************************************************************************/
 //------------------------------  main( )  ------------------------------//
 /*************************************************************************/
 /*************************************************************************/

 int main( )
    {
       clrscr( );
       textmode(C4350);

       show_screen( );
       get_input( );
       estimate_dfx( );

       return 0;
     }

 /*************************************************************************/
 /*************************************************************************/
 //------------------------  Funcion Definitions  ------------------------//
 /*************************************************************************/
 /*************************************************************************/

 /*************************************************************************/
 //--------------------------  show_screen( )  ---------------------------//
 /*************************************************************************/

 void show_screen( )
    {
       cprintf("\n********************************************************************************");
       cprintf("*************************-                             -************************");
       cprintf("*------------------------- ");

       textbackground(1);
       cprintf(" Numerical Differentiation ");
       textbackground(8);

       cprintf(" ------------------------*");
       cprintf("*-***********************-                             -**********************-*");
       cprintf("*-****************************************************************************-*");

       for(int count=0;count<42;count++)
	  cprintf("*-*                                                                          *-*");

       gotoxy(1,46);
       cprintf("*-****************************************************************************-*");
       cprintf("*------------------------------------------------------------------------------*");
       cprintf("********************************************************************************");

       gotoxy(1,2);
    }

 /*************************************************************************/
 //-------------------------  clear_screen( )  ---------------------------//
 /*************************************************************************/

 void clear_screen( )
    {
       for(int count=0;count<37;count++)
	  {
	     gotoxy(5,8+count);
	     cout<<"                                                                        ";
	  }

       gotoxy(1,2);
    }

 /*************************************************************************/
 //--------------------------  push(const char*)  ------------------------//
 /*************************************************************************/

 void push(const char* Operand)
    {
       if(top==(max_size-1))
	  {
	     cout<<"Error : Stack is full."<<endl;
	     cout<<"\n        Press any key to exit.";

	     getch( );
	     exit(0);
	  }

       else
	  {
	     top++;
	     strcpy(Stack[top],Operand);
	  }
    }

 /*************************************************************************/
 //------------------------------  pop( )  -------------------------------//
 /*************************************************************************/

 const char* pop( )
    {
       char Operand[40]={NULL};

       if(top==-1)
	  {
	     cout<<"Error : Stack is empty."<<endl;
	     cout<<"\n        Press any key to exit.";

	     getch( );
	     exit(0);
	  }

       else
	  {
	     strcpy(Operand,Stack[top]);
	     strset(Stack[top],NULL);
	     top--;
	  }

       return Operand;
    }

 /*************************************************************************/
 //----------------  convert_ie_to_pe(const char*,const int)  ------------//
 /*************************************************************************/

 void convert_ie_to_pe(const char* Expression,const int index)
    {
       char Infix_expression[100]={NULL};
       char Symbol_scanned[30]={NULL};

       push("(");
       strcpy(Infix_expression,Expression);
       strcat(Infix_expression,"+0)");

       int flag=0;
       int count_1=0;
       int count_2=0;
       int equation_length=strlen(Infix_expression);

       if(Infix_expression[0]=='(')
	  flag=1;

       do
	  {
	     strset(Symbol_scanned,NULL);

	     if(flag==0)
		{
		   int count_3=0;

		   do
		      {
			 Symbol_scanned[count_3]=Infix_expression[count_1];

			 count_1++;
			 count_3++;
		      }
		   while(count_1<=equation_length &&
			   Infix_expression[count_1]!='(' &&
			      Infix_expression[count_1]!='+' &&
				 Infix_expression[count_1]!='-' &&
				    Infix_expression[count_1]!='*' &&
				       Infix_expression[count_1]!='/' &&
					  Infix_expression[count_1]!='^' &&
					     Infix_expression[count_1]!=')');


		   flag=1;
		}

	     else if(flag==1)
		{
		   Symbol_scanned[0]=Infix_expression[count_1];

		   count_1++;

		   if(Infix_expression[count_1]!='(' &&
			 Infix_expression[count_1]!='^' &&
			    Infix_expression[count_1]!='*' &&
			       Infix_expression[count_1]!='/' &&
				  Infix_expression[count_1]!='+' &&
				     Infix_expression[count_1]!='-' &&
					Infix_expression[count_1]!=')')
		      flag=0;

		   if(Infix_expression[count_1-1]=='(' &&
			   (Infix_expression[count_1]=='-' ||
				 Infix_expression[count_1]=='+'))
		      flag=0;
		}

	     if(strcmp(Symbol_scanned,"(")==0)
		push("(");

	     else if(strcmp(Symbol_scanned,")")==0)
		{
		   while(strcmp(Stack[top],"(")!=0)
		      {
			 strcpy(Postfix_expression[index][count_2],pop( ));

			 count_2++;
		      }

		   pop( );
		}

	     else if(strcmp(Symbol_scanned,"^")==0 ||
			   strcmp(Symbol_scanned,"+")==0 ||
				 strcmp(Symbol_scanned,"-")==0 ||
				       strcmp(Symbol_scanned,"*")==0 ||
					     strcmp(Symbol_scanned,"/")==0)
		{
		   if(strcmp(Symbol_scanned,"^")==0)
		      {  }

		   else if(strcmp(Symbol_scanned,"*")==0 ||
					      strcmp(Symbol_scanned,"/")==0)
		      {
			 while(strcmp(Stack[top],"^")==0 ||
				     strcmp(Stack[top],"*")==0 ||
					   strcmp(Stack[top],"/")==0)
			    {
			       strcpy(Postfix_expression[index][count_2],pop( ));

			       count_2++;
			    }
		      }

		   else if(strcmp(Symbol_scanned,"+")==0 ||
				    strcmp(Symbol_scanned,"-")==0)
		      {
			 while(strcmp(Stack[top],"(")!=0)
			    {
			       strcpy(Postfix_expression[index][count_2],pop( ));

			       count_2++;
			    }
		      }

		   push(Symbol_scanned);
		}

	     else
		{
		   strcat(Postfix_expression[index][count_2],Symbol_scanned);

		   count_2++;
		}
	  }
       while(strcmp(Stack[top],NULL)!=0);

       strcat(Postfix_expression[index][count_2],"=");
       count_2++;
    }

 /*************************************************************************/
 //-----  evaluate_postfix_expression(const long double,const int)  ------//
 /*************************************************************************/

 const long double evaluate_postfix_expression(
					const long double x,const int index)
    {
       long double function_value=0;

       int count_1=-1;

       char Symbol_scanned[30]={NULL};

       do
	  {
	     count_1++;

	     strcpy(Symbol_scanned,Postfix_expression[index][count_1]);

	     if(strcmp(Symbol_scanned,"^")==0 ||
		      strcmp(Symbol_scanned,"*")==0 ||
			    strcmp(Symbol_scanned,"/")==0 ||
				  strcmp(Symbol_scanned,"+")==0 ||
					strcmp(Symbol_scanned,"-")==0)

		{
		   char Result[30]={NULL};
		   char Operand[2][30]={NULL};

		   strcpy(Operand[0],pop( ));
		   strcpy(Operand[1],pop( ));

		   long double operand[2]={0};
		   long double result=0;

		   char *endptr;

		   for(int count_2=0;count_2<2;count_2++)
		      {
			 int flag=0;

			 if(Operand[count_2][0]=='-')
			    {
			       int length=strlen(Operand[count_2]);

			       for(int count_3=0;count_3<(length-1);count_3++)
				  Operand[count_2][count_3]=Operand[count_2][(count_3+1)];

			       Operand[count_2][count_3]=NULL;

			       flag=1;
			    }

			 if(strcmp(Operand[count_2],"x")==0)
			    operand[count_2]=x;

			 else if(strcmp(Operand[count_2],"e")==0)
			    operand[count_2]=2.718282;

			 else if(strcmp(Operand[count_2],"sinx")==0)
			    operand[count_2]=sinl(x);

			 else if(strcmp(Operand[count_2],"cosx")==0)
			    operand[count_2]=cosl(x);

			 else if(strcmp(Operand[count_2],"tanx")==0)
			    operand[count_2]=tanl(x);

			 else if(strcmp(Operand[count_2],"lnx")==0)
			    operand[count_2]=logl(x);

			 else if(strcmp(Operand[count_2],"logx")==0)
			    operand[count_2]=log10l(x);

			 else
			    operand[count_2]=strtod(Operand[count_2],&endptr);

			 if(flag)
			    operand[count_2]*=-1;
		      }

		   switch(Symbol_scanned[0])
		      {
			 case '^' : result=powl(operand[1],operand[0]);
				    break;

			 case '*' : result=operand[1]*operand[0];
				    break;

			 case '/' : result=operand[1]/operand[0];
				    break;

			 case '+' : result=operand[1]+operand[0];
				    break;

			 case '-' : result=operand[1]-operand[0];
				    break;
		      }

		   gcvt(result,25,Result);

		   push(Result);
		}

	     else if(strcmp(Symbol_scanned,"=")!=0)
		push(Symbol_scanned);
	  }
       while(strcmp(Symbol_scanned,"=")!=0);

       char Function_value[30]={NULL};
       char *endptr;

       strcpy(Function_value,pop( ));
       function_value=strtod(Function_value,&endptr);

       return function_value;
    }

 /*************************************************************************/
 //-----------------------------  get_input( )  --------------------------//
 /*************************************************************************/

 void get_input( )
    {
       do
	  {
	     clear_screen( );

	     gotoxy(6,9);
	     cout<<"Number of Distinct Data Points :";

	     gotoxy(6,10);
	     cout<<"";

	     gotoxy(27,13);
	     cout<<"[ min. n = 2  |  max. n = 12 ]";

	     gotoxy(6,12);
	     cout<<"Enter the max. number of distinct data points = n = ";

	     cin>>n;

	     if(n<2 || n>12)
		{
		   gotoxy(12,25);
		   cout<<"Error : Wrong Input. Press <Esc> to exit or any other key";

		   gotoxy(12,26);
		   cout<<"        to try again.";

		   n=int(getche( ));

		   if(n==27)
		      exit(0);
		}
	  }
       while(n<2 || n>12);

       gotoxy(6,16);
       cout<<"Enter the value of x0 = ";

       cin>>x0;

       gotoxy(6,18);
       cout<<"Enter the value of h = ";

       cin>>h;

       gotoxy(6,24);
       cout<<"Input Mode :";

       gotoxy(6,25);
       cout<<"";

       gotoxy(8,28);
       cout<<"Press : ";

       gotoxy(10,30);
       cout<<"- 'Y' or <Enter> to enter function";

       gotoxy(10,32);
       cout<<"- 'N' or <Any other key> to enter values of the function";

       gotoxy(8,35);
       cout<<"Enter your choice : ";

       char Choice=NULL;

       Choice=getch( );

       if(Choice=='y' || Choice=='Y' || int(Choice)==13)
	  {
	     choice=1;

	     gotoxy(28,35);
	     cout<<"Y";
	  }

       else
	  {
	     gotoxy(28,35);
	     cout<<"N";
	  }

       gotoxy(25,43);
       cout<<"Press any key to continue...";

       getch( );

       if(choice)
	  {
	     clear_screen( );

	     gotoxy(6,11);
	     cout<<"Non-Linear Function :";

	     gotoxy(6,12);
	     cout<<"";

	     gotoxy(6,37);
	     cout<<"Note : Write the function with proper Braces ( ) e.g; 2x+3 as (2*x)+3";

	     gotoxy(6,40);
	     cout<<"Available Operators  :  ^ (raised to power) , * , / , + , -";

	     gotoxy(6,42);
	     cout<<"Available Operands   :  x , e , sinx , cosx , tanx , lnx , logx ,";

	     gotoxy(6,44);
	     cout<<"                        n = any number";

	     gotoxy(6,14);
	     cout<<"Enter the Function : f(x) = ";

	     cin>>Fx;

	     gotoxy(6,17);
	     cout<<"Enter the Differential Function : f'(x) = ";

	     cin>>Dfx;

	     convert_ie_to_pe(Fx,0);
	     convert_ie_to_pe(Dfx,1);
	  }

       clear_screen( );

       gotoxy(6,9);
       cout<<"Data Points & Values of Function :";

       gotoxy(6,10);
       cout<<"";

       gotoxy(25,12);
       cout<<"Ŀ";

       gotoxy(25,13);
       cout<<"       x            f(x)      ";

       gotoxy(25,14);
       cout<<"Ĵ";

       gotoxy(25,15);
       cout<<"                              ";

       for(int count_1=0;count_1<n;count_1++)
	  {
	     gotoxy(25,(wherey( )+1));
	     cout<<"                              ";

	     gotoxy(25,(wherey( )+1));
	     cout<<"                              ";
	  }

       gotoxy(25,(wherey( )+1));
       cout<<"";

       xn[0]=x0;

       for(int count_2=0;count_2<(n-1);count_2++)
	  xn[(count_2+1)]=(xn[count_2]+h);

       gotoxy(25,16);

       for(int count_3=0;count_3<n;count_3++)
	  {
	     gotoxy(27,wherey( ));
	     cout<<xn[count_3];

	     if(choice)
		{
		   fx[count_3]=evaluate_postfix_expression(xn[count_3],0);

		   gotoxy(43,wherey( ));
		   cout<<fx[count_3];
		}

	     else
		{
		   gotoxy(43,wherey( ));
		   cin>>fx[count_3];
		}

	     if(choice)
		gotoxy(25,(wherey( )+2));

	     else
		gotoxy(25,(wherey( )+1));
	  }

       gotoxy(25,43);
       cout<<"Press any key to continue...";

       getch( );
    }

 /*************************************************************************/
 //-------------------  get_index(const long double)  --------------------//
 /*************************************************************************/

 const int get_index(const long double x)
    {
       for(int count=0;count<n;count++)
	  {
	     if(xn[count]==x)
		break;
	  }

       return count;
    }

 /*************************************************************************/
 //----------------------------  estimate_dfx( )  ------------------------//
 /*************************************************************************/

 void estimate_dfx( )
    {
       clear_screen( );

       gotoxy(6,9);
       cout<<"Difference Formulas of Order 1 :";

       gotoxy(6,10);
       cout<<"";

       gotoxy(8,12);
       cout<<"Backward Difference Formula :  f'(x)  [f(x)-f(x-h)]/h";

       gotoxy(8,14);
       cout<<"Forward Difference Formula  :  f'(x)  [f(x+h)-f(x)]/h";

       gotoxy(6,18);
       cout<<"Estimation of First Derivative - f'(x) :";

       gotoxy(6,19);
       cout<<"";

       char Choice=NULL;

       long double x=0;
       long double dfx=0;
       long double actual_dfx=0;

       do
	  {
	     Choice=NULL;

	     gotoxy(8,21);
	     cout<<"Press :";

	     gotoxy(10,23);
	     cout<<"<B> to estimate f'(x) using Backward Difference Formula";

	     gotoxy(10,25);
	     cout<<"<F> to estimate f'(x) using Forward Difference Formula";

	     gotoxy(10,27);
	     cout<<"<E> to exit";

	     do
		{
		   gotoxy(8,30);
		   cout<<"Enter your choice : ";

		   Choice=getche( );
		   Choice=toupper(Choice);

		   if(Choice=='B' || Choice=='F' || Choice=='E')
		      break;

		   else
		      {
			 gotoxy(18,35);
			 cout<<"Wrong Choice. Please select a valid Choice.";

			 gotoxy(25,37);
			 cout<<"Press any Key to continue...";

			 getch( );

			 gotoxy(18,35);
			 cout<<"                                           ";

			 gotoxy(25,37);
			 cout<<"                                           ";

			 gotoxy(8,30);
			 cout<<"                                          ";
		      }
		}
	     while(1);

	     if(Choice=='E')
		exit(0);

	     gotoxy(8,21);
	     cout<<"                                                       ";

	     gotoxy(10,23);
	     cout<<"                                                       ";

	     gotoxy(10,25);
	     cout<<"                                                       ";

	     gotoxy(10,27);
	     cout<<"                                                       ";

	     gotoxy(8,30);
	     cout<<"                                                       ";

	     Input_x_again:

	     x=0;
	     dfx=0;
	     actual_dfx=0;

	     gotoxy(10,21);
	     cout<<"Enter the value of x = ";

	     cin>>x;

	     if(x>=xn[0] && x<=xn[(n-2)] && Choice=='B')
		{
		   int index=0;

		   index=get_index(x);

		   long double fxph=::fx[(index+1)];
		   long double fx=::fx[index];

		   dfx=((fxph-fx)/h);
		}

	     else if(x>=xn[1] && x<=xn[(n-1)] && Choice=='F')
		{
		   int index=0;

		   index=get_index(x);

		   long double fx=::fx[index];
		   long double fxmh=::fx[(index-1)];

		   dfx=((fx-fxmh)/h);
		}

	     else
		{
		   gotoxy(8,25);
		   cout<<"Error: Please enter the valid value of x for the selected formula.";

		   gotoxy(15,27);
		   cout<<"Press any Key to enter the value of x again...";

		   getch( );

		   gotoxy(8,25);
		   cout<<"                                                                  ";

		   gotoxy(15,27);
		   cout<<"                                                 ";

		   gotoxy(10,21);
		   cout<<"                                                 ";

		   goto Input_x_again;
		}

	     gotoxy(10,25);
	     cout<<"The estimated value of f'("<<x<<")    "<<dfx;

	     if(choice)
		{
		   actual_dfx=evaluate_postfix_expression(x,1);

		   gotoxy(10,27);
		   cout<<"The Actual value of f'("<<x<<")  =  "<<actual_dfx;

		   gotoxy(10,31);
		   cout<<"Absolute Error = E(abs) =  "<<fabs((actual_dfx-dfx));
		}

	     gotoxy(25,42);
	     cout<<"Press any other key to continue...";

	     getch( );

	     gotoxy(10,21);
	     cout<<"                                                    ";

	     gotoxy(10,25);
	     cout<<"                                                    ";

	     gotoxy(10,27);
	     cout<<"                                                    ";

	     gotoxy(10,31);
	     cout<<"                                                    ";

	     gotoxy(25,42);
	     cout<<"                                                    ";
	  }
       while(1);
    }

 /*************************************************************************/
 /*************************************************************************/
 //-----------------------------  THE END  -------------------------------//
 /*************************************************************************/
 /*************************************************************************/