
 /*************************************************************************/
 /*************************************************************************

 NA-31  :  A C++ Program to estimate the Integral value of the function at
	   the given points from the given data using Romberg Method.

  *************************************************************************/
 /*************************************************************************/
 /*************************************************************************

	  By :
		Muhammad Tahir Shahzad  [ MTS ]
		B.C.S Honours  [ 2000-04 ]
		Government College University Lahore
		Pakistan

      E-mail :  mtshome@wol.net.pk

    Web-Site :  www.mts-home.cjb.net  [ www.wol.net.pk/mtshome ]
		www.mtshome.cjb.net   [ www.geocities.com/mtahirshahzad ]

  *************************************************************************/

 /*************************************************************************/
 /*************************************************************************/
 //---------------------------  Header Files  ----------------------------//
 /*************************************************************************/
 /*************************************************************************/

 # include <iostream.h>
 # include   <stdlib.h>
 # include   <string.h>
 # include    <stdio.h>
 # include    <conio.h>
 # include     <math.h>

 /*************************************************************************/
 /*************************************************************************/
 //------------------------  Global Variables  ---------------------------//
 /*************************************************************************/
 /*************************************************************************/

 const int max_size=8;

 int n=0;
 int top=-1;

 long double h=0;
 long double a=0;
 long double b=0;

 long double ri[max_size][max_size]={0};
 long double xn[max_size]={0};
 long double fx[max_size]={0};

 char Fx[100]={NULL};
 char Stack[30][30]={NULL};
 char Postfix_expression[30][30]={NULL};

 /*************************************************************************/
 /*************************************************************************/
 //------------------------  Funcion Prototypes  -------------------------//
 /*************************************************************************/
 /*************************************************************************/

 void push(const char *);
 void convert_ie_to_pe(const char *);

 const char* pop( );
 const long double evaluate_postfix_expression(const long double);

 void show_screen( );
 void clear_screen( );
 void get_input( );
 void apply_trapezoidal_rule( );
 void apply_romberg_method( );
 void show_result( );

 /*************************************************************************/
 /*************************************************************************/
 //------------------------------  main( )  ------------------------------//
 /*************************************************************************/
 /*************************************************************************/

 int main( )
    {
       clrscr( );
       textmode(C4350);

       show_screen( );
       get_input( );
       apply_trapezoidal_rule( );
       apply_romberg_method( );
       show_result( );

       getch( );
       return 0;
     }

 /*************************************************************************/
 /*************************************************************************/
 //------------------------  Funcion Definitions  ------------------------//
 /*************************************************************************/
 /*************************************************************************/

 /*************************************************************************/
 //--------------------------  show_screen( )  ---------------------------//
 /*************************************************************************/

 void show_screen( )
    {
       cprintf("\n********************************************************************************");
       cprintf("****************************-                       -***************************");
       cprintf("*---------------------------- ");

       textbackground(1);
       cprintf(" Romberg Integration ");
       textbackground(8);

       cprintf(" ---------------------------*");
       cprintf("*-**************************-                       -*************************-*");
       cprintf("*-****************************************************************************-*");

       for(int count=0;count<42;count++)
	  cprintf("*-*                                                                          *-*");

       gotoxy(1,46);
       cprintf("*-****************************************************************************-*");
       cprintf("*------------------------------------------------------------------------------*");
       cprintf("********************************************************************************");

       gotoxy(1,2);
    }

 /*************************************************************************/
 //-------------------------  clear_screen( )  ---------------------------//
 /*************************************************************************/

 void clear_screen( )
    {
       for(int count=0;count<37;count++)
	  {
	     gotoxy(5,8+count);
	     cout<<"                                                                        ";
	  }

       gotoxy(1,2);
    }

 /*************************************************************************/
 //--------------------------  push(const char*)  ------------------------//
 /*************************************************************************/

 void push(const char* Operand)
    {
       if(top==(max_size-1))
	  {
	     cout<<"Error : Stack is full."<<endl;
	     cout<<"\n        Press any key to exit.";

	     getch( );
	     exit(0);
	  }

       else
	  {
	     top++;
	     strcpy(Stack[top],Operand);
	  }
    }

 /*************************************************************************/
 //------------------------------  pop( )  -------------------------------//
 /*************************************************************************/

 const char* pop( )
    {
       char Operand[40]={NULL};

       if(top==-1)
	  {
	     cout<<"Error : Stack is empty."<<endl;
	     cout<<"\n        Press any key to exit.";

	     getch( );
	     exit(0);
	  }

       else
	  {
	     strcpy(Operand,Stack[top]);
	     strset(Stack[top],NULL);
	     top--;
	  }

       return Operand;
    }

 /*************************************************************************/
 //--------------------  convert_ie_to_pe(const char*)  ------------------//
 /*************************************************************************/

 void convert_ie_to_pe(const char* Expression)
    {
       char Infix_expression[100]={NULL};
       char Symbol_scanned[30]={NULL};

       push("(");
       strcpy(Infix_expression,Expression);
       strcat(Infix_expression,"+0)");

       int flag=0;
       int count_1=0;
       int count_2=0;
       int equation_length=strlen(Infix_expression);

       if(Infix_expression[0]=='(')
	  flag=1;

       do
	  {
	     strset(Symbol_scanned,NULL);

	     if(flag==0)
		{
		   int count_3=0;

		   do
		      {
			 Symbol_scanned[count_3]=Infix_expression[count_1];

			 count_1++;
			 count_3++;
		      }
		   while(count_1<=equation_length &&
			   Infix_expression[count_1]!='(' &&
			      Infix_expression[count_1]!='+' &&
				 Infix_expression[count_1]!='-' &&
				    Infix_expression[count_1]!='*' &&
				       Infix_expression[count_1]!='/' &&
					  Infix_expression[count_1]!='^' &&
					     Infix_expression[count_1]!=')');


		   flag=1;
		}

	     else if(flag==1)
		{
		   Symbol_scanned[0]=Infix_expression[count_1];

		   count_1++;

		   if(Infix_expression[count_1]!='(' &&
			 Infix_expression[count_1]!='^' &&
			    Infix_expression[count_1]!='*' &&
			       Infix_expression[count_1]!='/' &&
				  Infix_expression[count_1]!='+' &&
				     Infix_expression[count_1]!='-' &&
					Infix_expression[count_1]!=')')
		      flag=0;

		   if(Infix_expression[count_1-1]=='(' &&
			   (Infix_expression[count_1]=='-' ||
				 Infix_expression[count_1]=='+'))
		      flag=0;
		}

	     if(strcmp(Symbol_scanned,"(")==0)
		push("(");

	     else if(strcmp(Symbol_scanned,")")==0)
		{
		   while(strcmp(Stack[top],"(")!=0)
		      {
			 strcpy(Postfix_expression[count_2],pop( ));

			 count_2++;
		      }

		   pop( );
		}

	     else if(strcmp(Symbol_scanned,"^")==0 ||
			   strcmp(Symbol_scanned,"+")==0 ||
				 strcmp(Symbol_scanned,"-")==0 ||
				       strcmp(Symbol_scanned,"*")==0 ||
					     strcmp(Symbol_scanned,"/")==0)
		{
		   if(strcmp(Symbol_scanned,"^")==0)
		      {  }

		   else if(strcmp(Symbol_scanned,"*")==0 ||
					      strcmp(Symbol_scanned,"/")==0)
		      {
			 while(strcmp(Stack[top],"^")==0 ||
				     strcmp(Stack[top],"*")==0 ||
					   strcmp(Stack[top],"/")==0)
			    {
			       strcpy(Postfix_expression[count_2],pop( ));

			       count_2++;
			    }
		      }

		   else if(strcmp(Symbol_scanned,"+")==0 ||
				    strcmp(Symbol_scanned,"-")==0)
		      {
			 while(strcmp(Stack[top],"(")!=0)
			    {
			       strcpy(Postfix_expression[count_2],pop( ));

			       count_2++;
			    }
		      }

		   push(Symbol_scanned);
		}

	     else
		{
		   strcat(Postfix_expression[count_2],Symbol_scanned);

		   count_2++;
		}
	  }
       while(strcmp(Stack[top],NULL)!=0);

       strcat(Postfix_expression[count_2],"=");
       count_2++;
    }

 /*************************************************************************/
 //----------  evaluate_postfix_expression(const long double)  -----------//
 /*************************************************************************/

 const long double evaluate_postfix_expression(const long double x)
    {
       long double function_value=0;

       int count_1=-1;

       char Symbol_scanned[30]={NULL};

       do
	  {
	     count_1++;

	     strcpy(Symbol_scanned,Postfix_expression[count_1]);

	     if(strcmp(Symbol_scanned,"^")==0 ||
		      strcmp(Symbol_scanned,"*")==0 ||
			    strcmp(Symbol_scanned,"/")==0 ||
				  strcmp(Symbol_scanned,"+")==0 ||
					strcmp(Symbol_scanned,"-")==0)

		{
		   char Result[30]={NULL};
		   char Operand[2][30]={NULL};

		   strcpy(Operand[0],pop( ));
		   strcpy(Operand[1],pop( ));

		   long double operand[2]={0};
		   long double result=0;

		   char *endptr;

		   for(int count_2=0;count_2<2;count_2++)
		      {
			 int flag=0;

			 if(Operand[count_2][0]=='-')
			    {
			       int length=strlen(Operand[count_2]);

			       for(int count_3=0;count_3<(length-1);count_3++)
				  Operand[count_2][count_3]=Operand[count_2][(count_3+1)];

			       Operand[count_2][count_3]=NULL;

			       flag=1;
			    }

			 if(strcmp(Operand[count_2],"x")==0)
			    operand[count_2]=x;

			 else if(strcmp(Operand[count_2],"e")==0)
			    operand[count_2]=2.718282;

			 else if(strcmp(Operand[count_2],"sinx")==0)
			    operand[count_2]=sinl(x);

			 else if(strcmp(Operand[count_2],"cosx")==0)
			    operand[count_2]=cosl(x);

			 else if(strcmp(Operand[count_2],"tanx")==0)
			    operand[count_2]=tanl(x);

			 else if(strcmp(Operand[count_2],"lnx")==0)
			    operand[count_2]=logl(x);

			 else if(strcmp(Operand[count_2],"logx")==0)
			    operand[count_2]=log10l(x);

			 else
			    operand[count_2]=strtod(Operand[count_2],&endptr);

			 if(flag)
			    operand[count_2]*=-1;
		      }

		   switch(Symbol_scanned[0])
		      {
			 case '^' : result=powl(operand[1],operand[0]);
				    break;

			 case '*' : result=operand[1]*operand[0];
				    break;

			 case '/' : result=operand[1]/operand[0];
				    break;

			 case '+' : result=operand[1]+operand[0];
				    break;

			 case '-' : result=operand[1]-operand[0];
				    break;
		      }

		   gcvt(result,25,Result);

		   push(Result);
		}

	     else if(strcmp(Symbol_scanned,"=")!=0)
		push(Symbol_scanned);
	  }
       while(strcmp(Symbol_scanned,"=")!=0);

       char Function_value[30]={NULL};
       char *endptr;

       strcpy(Function_value,pop( ));
       function_value=strtod(Function_value,&endptr);

       return function_value;
    }

 /*************************************************************************/
 //-----------------------------  get_input( )  --------------------------//
 /*************************************************************************/

 void get_input( )
    {
       do
	  {
	     clear_screen( );

	     gotoxy(6,9);
	     cout<<"Input :";

	     gotoxy(6,10);
	     cout<<"";

	     gotoxy(37,13);
	     cout<<"[ n = 2,4,8 ]";

	     gotoxy(6,12);
	     cout<<"Enter the max. number of sub-intervals = n = ";

	     cin>>n;

	     if(n!=2 && n!=4 && n!=8)
		{
		   gotoxy(12,25);
		   cout<<"Error : Wrong Input. Press <Esc> to exit or any other key";

		   gotoxy(12,26);
		   cout<<"        to try again.";

		   n=int(getche( ));

		   if(n==27)
		      exit(0);
		}
	  }
       while(n!=2 && n!=4 && n!=8);

       gotoxy(6,16);
       cout<<"Enter the value of Lower limit = a = ";

       cin>>a;

       gotoxy(6,18);
       cout<<"Enter the value of Upper Limit = b = ";

       cin>>b;

       gotoxy(25,43);
       cout<<"Press any key to continue...";

       getch( );

       clear_screen( );

       gotoxy(6,10);
       cout<<"Non-Linear Function :";

       gotoxy(6,11);
       cout<<"";

       gotoxy(6,37);
       cout<<"Note : Write the function with proper Braces ( ) e.g; 2x+3 as (2*x)+3";

       gotoxy(6,40);
       cout<<"Available Operators  :  ^ (raised to power) , * , / , + , -";

       gotoxy(6,42);
       cout<<"Available Operands   :  x , e , sinx , cosx , tanx , lnx , logx ,";

       gotoxy(6,44);
       cout<<"                        n = any number";

       gotoxy(6,14);
       cout<<"Enter the Function : f(x) = ";

       cin>>Fx;

       convert_ie_to_pe(Fx);
    }

 /*************************************************************************/
 //----------------------  apply_trapezoidal_rule( )  --------------------//
 /*************************************************************************/

 void apply_trapezoidal_rule( )
    {
       int count_1=0;

       for(int count_2=1;count_2<=n;count_2+=count_2)
	  {
	     for(int count_3=0;count_3<max_size;count_3++)
		{
		   xn[count_3]=0;
		   fx[count_3]=0;
		}

	     h=((b-a)/count_2);
	     xn[0]=a;

	     for(int count_4=0;count_4<count_2;count_4++)
		xn[(count_4+1)]=(xn[count_4]+h);

	     for(int count_5=0;count_5<=count_2;count_5++)
		fx[count_5]=evaluate_postfix_expression(xn[count_5]);

	     for(int count_6=1;count_6<count_2;count_6++)
		ri[count_1][0]+=fx[count_6];

	     ri[count_1][0]*=2;
	     ri[count_1][0]+=fx[0];
	     ri[count_1][0]+=fx[count_2];
	     ri[count_1][0]*=(h/2);

	     count_1++;
	  }
    }

 /*************************************************************************/
 //----------------------  apply_romberg_method( )  ----------------------//
 /*************************************************************************/

 void apply_romberg_method( )
    {
       int counter=0;

       switch(n)
	  {
	     case 2 : counter=1;
		      break;

	     case 4 : counter=2;
		      break;

	     case 8 : counter=3;
		      break;
	  }

       for(int count_1=1;count_1<=counter;count_1++)
	  {
	     for(int count_2=count_1;count_2<=counter;count_2++)
		{
		   long double rjk_1=0;
		   long double rj_1k_1=0;

		   rjk_1=ri[count_2][(count_1-1)];
		   rj_1k_1=ri[(count_2-1)][(count_1-1)];

		   ri[count_2][count_1]=(((powl(4,count_1)*rjk_1)-rj_1k_1)/(powl(4,count_1)-1));
		}
	  }
    }

 /*************************************************************************/
 //----------------------------  show_result( )  -------------------------//
 /*************************************************************************/

 void show_result( )
    {
       clear_screen( );

       int counter=0;

       switch(n)
	  {
	     case 2 : counter=1;
		      break;

	     case 4 : counter=2;
		      break;

	     case 8 : counter=3;
		      break;
	  }

       gotoxy(6,10);
       cout<<"Solution :";

       gotoxy(6,11);
       cout<<"";

       if(n==1)
	  {
	     gotoxy(6,13);
	     cout<<"Ŀ";
	  }

       else if(n==2)
	  {
	     gotoxy(6,13);
	     cout<<"Ŀ";
	  }

       else if(n==4)
	  {
	     gotoxy(6,13);
	     cout<<"Ŀ";
	  }

       else if(n==8)
	  {
	     gotoxy(6,13);
	     cout<<"Ŀ";
	  }

       if(n==1)
	  {
	     gotoxy(6,14);
	     cout<<" Number of  Trapezoidal ";
	  }

       else if(n==2)
	  {
	     gotoxy(6,14);
	     cout<<" Number of  Trapezoidal  Romberg Values ";
	  }

       else if(n==4)
	  {
	     gotoxy(6,14);
	     cout<<" Number of  Trapezoidal       Romberg  Values      ";
	  }

       else if(n==8)
	  {
	     gotoxy(6,14);
	     cout<<" Number of  Trapezoidal              Romberg  Values             ";
	  }

       if(n==1)
	  {
	     gotoxy(6,15);
	     cout<<"                        ";
	  }

       else if(n==2)
	  {
	     gotoxy(6,15);
	     cout<<"			      Ĵ";
	  }

       else if(n==4)
	  {
	     gotoxy(6,15);
	     cout<<"                        Ĵ";
	  }

       else if(n==8)
	  {
	     gotoxy(6,15);
	     cout<<"                        Ĵ";
	  }

       if(n==1)
	  {
	     gotoxy(6,16);
	     cout<<" Intervals     Sums     ";
	  }

       else if(n==2)
	  {
	     gotoxy(6,16);
	     cout<<" Intervals     Sums       1ts Order     ";
	  }

       else if(n==4)
	  {
	     gotoxy(6,16);
	     cout<<" Intervals     Sums       1ts Order    2nd Order  ";
	  }

       else if(n==8)
	  {
	     gotoxy(6,16);
	     cout<<" Intervals     Sums       1ts Order    2nd Order    3rd Order  ";
	  }

       if(n==1)
	  {
	     gotoxy(6,17);
	     cout<<"Ĵ";
	  }

       else if(n==2)
	  {
	     gotoxy(6,17);
	     cout<<"Ĵ";
	  }

       else if(n==4)
	  {
	     gotoxy(6,17);
	     cout<<"Ĵ";
	  }

       else if(n==8)
	  {
	     gotoxy(6,17);
	     cout<<"Ĵ";
	  }

       if(n==1)
	  {
	     gotoxy(6,18);
	     cout<<"                        ";
	  }

       else if(n==2)
	  {
	     gotoxy(6,18);
	     cout<<"                                        ";
	  }

       else if(n==4)
	  {
	     gotoxy(6,18);
	     cout<<"                                                  ";
	  }

       else if(n==8)
	  {
	     gotoxy(6,18);
	     cout<<"                                                               ";
	  }

       int y_cord=19;
       int intervals=1;

       for(int count_1=0;count_1<=counter;count_1++)
	  {
	     if(n==1)
		{
		   gotoxy(6,y_cord);
		   cout<<"                        ";

		   gotoxy(6,(y_cord+1));
		   cout<<"                        ";
		}

	     else if(n==2)
		{
		   gotoxy(6,y_cord);
		   cout<<"                                        ";

		   gotoxy(6,(y_cord+1));
		   cout<<"                                        ";
		}

	     else if(n==4)
		{
		   gotoxy(6,y_cord);
		   cout<<"                                                  ";

		   gotoxy(6,(y_cord+1));
		   cout<<"                                                  ";
		}

	     else if(n==8)
		{
		   gotoxy(6,y_cord);
		   cout<<"                                                               ";

		   gotoxy(6,(y_cord+1));
		   cout<<"                                                               ";
		}

	     gotoxy(11,(19+(count_1*2)));
	     cout<<intervals;

	     intervals+=intervals;
	     y_cord+=2;
	  }

       for(int count_2=0;count_2<=counter;count_2++)
	  {
	     for(int count_3=0;count_3<=counter;count_3++)
		{
		   if(count_2==0)
		      {
			 gotoxy(20,(19+(count_3*2)));
			 cout<<ri[count_3][0];
		      }

		   else if(count_2==1 && count_3>=count_2)
		      {
			 gotoxy(34,(19+(count_3*2)));
			 cout<<ri[count_3][1];
		      }

		   else if(count_2==2 && count_3>=count_2)
		      {
			 gotoxy(48,(19+(count_3*2)));
			 cout<<ri[count_3][2];
		      }

		   else if(count_2==3 && count_3>=count_2)
		      {
			 gotoxy(62,(19+(count_3*2)));
			 cout<<ri[count_3][3];
		      }
		}
	  }

       if(n==1)
	  {
	     gotoxy(6,y_cord);
	     cout<<"";
	  }

       else if(n==2)
	  {
	     gotoxy(6,y_cord);
	     cout<<"";
	  }

       else if(n==4)
	  {
	     gotoxy(6,y_cord);
	     cout<<"";
	  }

       else if(n==8)
	  {
	     gotoxy(6,y_cord);
	     cout<<"";
	  }

       gotoxy(6,32);
       cout<<"              b";

       gotoxy(6,34);
       cout<<"              a";

       gotoxy(6,33);
       cout<<"Estimation of  f(x)dx :";

       gotoxy(6,35);
       cout<<"";

       gotoxy(8,37);
       cout<<"Estimated Integral Value = ";

       cout<<ri[counter][counter];

       gotoxy(1,2);
    }

 /*************************************************************************/
 /*************************************************************************/
 //-----------------------------  THE END  -------------------------------//
 /*************************************************************************/
 /*************************************************************************/