
 /*************************************************************************/
 /*************************************************************************

 NA-32  :  A C++ Program to estimate the Integral value of a given function
	   using Gussian Quadrature Rule.

  *************************************************************************/
 /*************************************************************************/
 /*************************************************************************

	  By :
		Muhammad Tahir Shahzad  [ MTS ]
		B.C.S Honours  [ 2000-04 ]
		Government College University Lahore
		Pakistan

      E-mail :  mtshome@wol.net.pk

    Web-Site :  www.mts-home.cjb.net  [ www.wol.net.pk/mtshome ]
		www.mtshome.cjb.net   [ www.geocities.com/mtahirshahzad ]

  *************************************************************************/

 /*************************************************************************/
 /*************************************************************************/
 //---------------------------  Header Files  ----------------------------//
 /*************************************************************************/
 /*************************************************************************/

 # include <iostream.h>
 # include   <stdlib.h>
 # include   <string.h>
 # include    <stdio.h>
 # include    <conio.h>
 # include     <math.h>

 /*************************************************************************/
 /*************************************************************************/
 //------------------------  Global Variables  ---------------------------//
 /*************************************************************************/
 /*************************************************************************/

 const int max_size=13;

 int n=0;
 int top=-1;

 long double a=-1;
 long double b=1;
 long double two_point_result=0;
 long double three_point_result=0;

 char Fx[100]={NULL};
 char Stack[30][30]={NULL};
 char Postfix_expression[30][30]={NULL};

 /*************************************************************************/
 /*************************************************************************/
 //------------------------  Funcion Prototypes  -------------------------//
 /*************************************************************************/
 /*************************************************************************/

 void push(const char *);
 void convert_ie_to_pe(const char *);

 const char* pop( );
 const long double evaluate_postfix_expression(const long double);

 void show_screen( );
 void clear_screen( );
 void get_input( );
 void change_limits( );
 void apply_gaussian_quadrature_rule( );
 void show_result( );

 /*************************************************************************/
 /*************************************************************************/
 //------------------------------  main( )  ------------------------------//
 /*************************************************************************/
 /*************************************************************************/

 int main( )
    {
       clrscr( );
       textmode(C4350);

       show_screen( );
       get_input( );
       show_result( );

       getch( );
       return 0;
     }

 /*************************************************************************/
 /*************************************************************************/
 //------------------------  Funcion Definitions  ------------------------//
 /*************************************************************************/
 /*************************************************************************/

 /*************************************************************************/
 //--------------------------  show_screen( )  ---------------------------//
 /*************************************************************************/

 void show_screen( )
    {
       cprintf("\n********************************************************************************");
       cprintf("***************************-                         -**************************");
       cprintf("*--------------------------- ");

       textbackground(1);
       cprintf(" Numerical Integration ");
       textbackground(8);

       cprintf(" --------------------------*");
       cprintf("*-*************************-                         -************************-*");
       cprintf("*-****************************************************************************-*");

       for(int count=0;count<42;count++)
	  cprintf("*-*                                                                          *-*");

       gotoxy(1,46);
       cprintf("*-****************************************************************************-*");
       cprintf("*------------------------------------------------------------------------------*");
       cprintf("********************************************************************************");

       gotoxy(1,2);
    }

 /*************************************************************************/
 //-------------------------  clear_screen( )  ---------------------------//
 /*************************************************************************/

 void clear_screen( )
    {
       for(int count=0;count<37;count++)
	  {
	     gotoxy(5,8+count);
	     cout<<"                                                                        ";
	  }

       gotoxy(1,2);
    }

 /*************************************************************************/
 //--------------------------  push(const char*)  ------------------------//
 /*************************************************************************/

 void push(const char* Operand)
    {
       if(top==(max_size-1))
	  {
	     cout<<"Error : Stack is full."<<endl;
	     cout<<"\n        Press any key to exit.";

	     getch( );
	     exit(0);
	  }

       else
	  {
	     top++;
	     strcpy(Stack[top],Operand);
	  }
    }

 /*************************************************************************/
 //------------------------------  pop( )  -------------------------------//
 /*************************************************************************/

 const char* pop( )
    {
       char Operand[40]={NULL};

       if(top==-1)
	  {
	     cout<<"Error : Stack is empty."<<endl;
	     cout<<"\n        Press any key to exit.";

	     getch( );
	     exit(0);
	  }

       else
	  {
	     strcpy(Operand,Stack[top]);
	     strset(Stack[top],NULL);
	     top--;
	  }

       return Operand;
    }

 /*************************************************************************/
 //--------------------  convert_ie_to_pe(const char*)  ------------------//
 /*************************************************************************/

 void convert_ie_to_pe(const char* Expression)
    {
       char Infix_expression[100]={NULL};
       char Symbol_scanned[30]={NULL};

       push("(");
       strcpy(Infix_expression,Expression);
       strcat(Infix_expression,"+0)");

       int flag=0;
       int count_1=0;
       int count_2=0;
       int equation_length=strlen(Infix_expression);

       if(Infix_expression[0]=='(')
	  flag=1;

       do
	  {
	     strset(Symbol_scanned,NULL);

	     if(flag==0)
		{
		   int count_3=0;

		   do
		      {
			 Symbol_scanned[count_3]=Infix_expression[count_1];

			 count_1++;
			 count_3++;
		      }
		   while(count_1<=equation_length &&
			   Infix_expression[count_1]!='(' &&
			      Infix_expression[count_1]!='+' &&
				 Infix_expression[count_1]!='-' &&
				    Infix_expression[count_1]!='*' &&
				       Infix_expression[count_1]!='/' &&
					  Infix_expression[count_1]!='^' &&
					     Infix_expression[count_1]!=')');


		   flag=1;
		}

	     else if(flag==1)
		{
		   Symbol_scanned[0]=Infix_expression[count_1];

		   count_1++;

		   if(Infix_expression[count_1]!='(' &&
			 Infix_expression[count_1]!='^' &&
			    Infix_expression[count_1]!='*' &&
			       Infix_expression[count_1]!='/' &&
				  Infix_expression[count_1]!='+' &&
				     Infix_expression[count_1]!='-' &&
					Infix_expression[count_1]!=')')
		      flag=0;

		   if(Infix_expression[count_1-1]=='(' &&
			   (Infix_expression[count_1]=='-' ||
				 Infix_expression[count_1]=='+'))
		      flag=0;
		}

	     if(strcmp(Symbol_scanned,"(")==0)
		push("(");

	     else if(strcmp(Symbol_scanned,")")==0)
		{
		   while(strcmp(Stack[top],"(")!=0)
		      {
			 strcpy(Postfix_expression[count_2],pop( ));

			 count_2++;
		      }

		   pop( );
		}

	     else if(strcmp(Symbol_scanned,"^")==0 ||
			   strcmp(Symbol_scanned,"+")==0 ||
				 strcmp(Symbol_scanned,"-")==0 ||
				       strcmp(Symbol_scanned,"*")==0 ||
					     strcmp(Symbol_scanned,"/")==0)
		{
		   if(strcmp(Symbol_scanned,"^")==0)
		      {  }

		   else if(strcmp(Symbol_scanned,"*")==0 ||
					      strcmp(Symbol_scanned,"/")==0)
		      {
			 while(strcmp(Stack[top],"^")==0 ||
				     strcmp(Stack[top],"*")==0 ||
					   strcmp(Stack[top],"/")==0)
			    {
			       strcpy(Postfix_expression[count_2],pop( ));

			       count_2++;
			    }
		      }

		   else if(strcmp(Symbol_scanned,"+")==0 ||
				    strcmp(Symbol_scanned,"-")==0)
		      {
			 while(strcmp(Stack[top],"(")!=0)
			    {
			       strcpy(Postfix_expression[count_2],pop( ));

			       count_2++;
			    }
		      }

		   push(Symbol_scanned);
		}

	     else
		{
		   strcat(Postfix_expression[count_2],Symbol_scanned);

		   count_2++;
		}
	  }
       while(strcmp(Stack[top],NULL)!=0);

       strcat(Postfix_expression[count_2],"=");
       count_2++;
    }

 /*************************************************************************/
 //----------  evaluate_postfix_expression(const long double)  -----------//
 /*************************************************************************/

 const long double evaluate_postfix_expression(const long double x)
    {
       long double function_value=0;

       int count_1=-1;

       char Symbol_scanned[30]={NULL};

       do
	  {
	     count_1++;

	     strcpy(Symbol_scanned,Postfix_expression[count_1]);

	     if(strcmp(Symbol_scanned,"^")==0 ||
		      strcmp(Symbol_scanned,"*")==0 ||
			    strcmp(Symbol_scanned,"/")==0 ||
				  strcmp(Symbol_scanned,"+")==0 ||
					strcmp(Symbol_scanned,"-")==0)

		{
		   char Result[30]={NULL};
		   char Operand[2][30]={NULL};

		   strcpy(Operand[0],pop( ));
		   strcpy(Operand[1],pop( ));

		   long double operand[2]={0};
		   long double result=0;

		   char *endptr;

		   for(int count_2=0;count_2<2;count_2++)
		      {
			 int flag=0;

			 if(Operand[count_2][0]=='-')
			    {
			       int length=strlen(Operand[count_2]);

			       for(int count_3=0;count_3<(length-1);count_3++)
				  Operand[count_2][count_3]=Operand[count_2][(count_3+1)];

			       Operand[count_2][count_3]=NULL;

			       flag=1;
			    }

			 if(strcmp(Operand[count_2],"x")==0)
			    operand[count_2]=x;

			 else if(strcmp(Operand[count_2],"e")==0)
			    operand[count_2]=2.718282;

			 else if(strcmp(Operand[count_2],"sinx")==0)
			    operand[count_2]=sinl(x);

			 else if(strcmp(Operand[count_2],"cosx")==0)
			    operand[count_2]=cosl(x);

			 else if(strcmp(Operand[count_2],"tanx")==0)
			    operand[count_2]=tanl(x);

			 else if(strcmp(Operand[count_2],"lnx")==0)
			    operand[count_2]=logl(x);

			 else if(strcmp(Operand[count_2],"logx")==0)
			    operand[count_2]=log10l(x);

			 else
			    operand[count_2]=strtod(Operand[count_2],&endptr);

			 if(flag)
			    operand[count_2]*=-1;
		      }

		   switch(Symbol_scanned[0])
		      {
			 case '^' : result=powl(operand[1],operand[0]);
				    break;

			 case '*' : result=operand[1]*operand[0];
				    break;

			 case '/' : result=operand[1]/operand[0];
				    break;

			 case '+' : result=operand[1]+operand[0];
				    break;

			 case '-' : result=operand[1]-operand[0];
				    break;
		      }

		   gcvt(result,25,Result);

		   push(Result);
		}

	     else if(strcmp(Symbol_scanned,"=")!=0)
		push(Symbol_scanned);
	  }
       while(strcmp(Symbol_scanned,"=")!=0);

       char Function_value[30]={NULL};
       char *endptr;

       strcpy(Function_value,pop( ));
       function_value=strtod(Function_value,&endptr);

       return function_value;
    }

 /*************************************************************************/
 //-----------------------------  get_input( )  --------------------------//
 /*************************************************************************/

 void get_input( )
    {
       clear_screen( );

       gotoxy(6,10);
       cout<<"Non-Linear Function :";

       gotoxy(6,11);
       cout<<"";

       gotoxy(6,37);
       cout<<"Note : Write the function with proper Braces ( ) e.g; 2x+3 as (2*x)+3";

       gotoxy(6,40);
       cout<<"Available Operators  :  ^ (raised to power) , * , / , + , -";

       gotoxy(6,42);
       cout<<"Available Operands   :  x , e , sinx , cosx , tanx , lnx , logx ,";

       gotoxy(6,44);
       cout<<"                        n = any number";

       gotoxy(6,14);
       cout<<"Enter the Function : f(x) = ";

       cin>>Fx;

       convert_ie_to_pe(Fx);
    }

 /*************************************************************************/
 //-----------------  apply_gaussian_quadrature_rule( )  -----------------//
 /*************************************************************************/

 void apply_gaussian_quadrature_rule( )
    {
       long double temp_1=0;
       long double temp_2=0;
       long double temp_3=0;

       temp_1=evaluate_postfix_expression((-sqrtl(0.6)));
       temp_1*=(0.555555556);

       temp_2=evaluate_postfix_expression(0);
       temp_2*=(0.888888889);

       temp_3=evaluate_postfix_expression(sqrtl(0.6));
       temp_3*=(0.555555556);

       three_point_result=(temp_1+temp_2+temp_3);

       temp_1=0;
       temp_2=0;


       temp_1=evaluate_postfix_expression((-1/sqrtl(3)));
       temp_2=evaluate_postfix_expression((1/sqrtl(3)));

       two_point_result=(temp_1+temp_2);
    }

 /*************************************************************************/
 //----------------------------  show_result( )  -------------------------//
 /*************************************************************************/

 void show_result( )
    {
       clear_screen( );

       gotoxy(6,9);
       cout<<"Gaussian Quadrature Rule:";

       gotoxy(6,10);
       cout<<"";

       gotoxy(24,12);
       cout<<" 1";

       gotoxy(6,13);
       cout<<"Two Point Rule:     f(x)dx  f(-1/3)+f(1/3)";

       gotoxy(24,14);
       cout<<"-1";

       gotoxy(24,16);
       cout<<" 1";

       gotoxy(6,17);
       cout<<"Three Point Rule:   f(x)dx  (5/9)f(-(3/5))+(8/9)f(0)+(5/9)f((3/5))";

       gotoxy(24,18);
       cout<<"-1";

       apply_gaussian_quadrature_rule( );

       gotoxy(6,22);
       cout<<"              1";

       gotoxy(6,24);
       cout<<"             -1";

       gotoxy(6,23);
       cout<<"Estimation of  f(x)dx :";

       gotoxy(6,25);
       cout<<"";

       gotoxy(8,27);
       cout<<"Estimated Integral Value (using 2-Point Rule) = "<<two_point_result;

       gotoxy(8,29);
       cout<<"Estimated Integral Value (using 3-Point Rule) = "<<three_point_result;

       gotoxy(1,2);
    }

 /*************************************************************************/
 /*************************************************************************/
 //-----------------------------  THE END  -------------------------------//
 /*************************************************************************/
 /*************************************************************************/