
 /*************************************************************************/
 /*************************************************************************

 NA-36  :  A C++ Program to estimate the Differential value of a given
	   function at given point from given data using Runge-Kutta Methods.

  *************************************************************************/
 /*************************************************************************/
 /*************************************************************************

	  By :
		Muhammad Tahir Shahzad  [ MTS ]
		B.C.S Honours  [ 2000-04 ]
		Government College University Lahore
		Pakistan

      E-mail :  mtshome@wol.net.pk

    Web-Site :  www.mts-home.cjb.net  [ www.wol.net.pk/mtshome ]
		www.mtshome.cjb.net   [ www.geocities.com/mtahirshahzad ]

  *************************************************************************/

 /*************************************************************************/
 /*************************************************************************/
 //---------------------------  Header Files  ----------------------------//
 /*************************************************************************/
 /*************************************************************************/

 # include <iostream.h>
 # include   <stdlib.h>
 # include   <string.h>
 # include    <stdio.h>
 # include    <conio.h>
 # include     <math.h>

 /*************************************************************************/
 /*************************************************************************/
 //------------------------  Global Variables  ---------------------------//
 /*************************************************************************/
 /*************************************************************************/

 const int max_size=13;

 int n=0;
 int top=-1;

 long double h=0;
 long double x=0;
 long double x0=0;
 long double y0=0;
 long double two_stage_result=0;
 long double three_stage_result=0;

 long double xx[max_size]={0};
 long double yy2[max_size]={0};
 long double yy3[max_size]={0};

 char Fx[100]={NULL};
 char Stack[30][30]={NULL};
 char Postfix_expression[30][30]={NULL};

 /*************************************************************************/
 /*************************************************************************/
 //------------------------  Funcion Prototypes  -------------------------//
 /*************************************************************************/
 /*************************************************************************/

 void push(const char *);
 void convert_ie_to_pe(const char *);

 const char* pop( );
 const long double evaluate_pe(const long double,const long double);

 void show_screen( );
 void clear_screen( );
 void get_input( );
 void apply_runge_kutta_method( );
 void show_result( );

 /*************************************************************************/
 /*************************************************************************/
 //------------------------------  main( )  ------------------------------//
 /*************************************************************************/
 /*************************************************************************/

 int main( )
    {
       clrscr( );
       textmode(C4350);

       show_screen( );
       get_input( );
       apply_runge_kutta_method( );
       show_result( );

       getch( );
       return 0;
     }

 /*************************************************************************/
 /*************************************************************************/
 //------------------------  Funcion Definitions  ------------------------//
 /*************************************************************************/
 /*************************************************************************/

 /*************************************************************************/
 //--------------------------  show_screen( )  ---------------------------//
 /*************************************************************************/

 void show_screen( )
    {
       cprintf("\n********************************************************************************");
       cprintf("***************************-                         -**************************");
       cprintf("*--------------------------- ");

       textbackground(1);
       cprintf(" Numerical Integration ");
       textbackground(8);

       cprintf(" --------------------------*");
       cprintf("*-*************************-                         -************************-*");
       cprintf("*-****************************************************************************-*");

       for(int count=0;count<42;count++)
	  cprintf("*-*                                                                          *-*");

       gotoxy(1,46);
       cprintf("*-****************************************************************************-*");
       cprintf("*------------------------------------------------------------------------------*");
       cprintf("********************************************************************************");

       gotoxy(1,2);
    }

 /*************************************************************************/
 //-------------------------  clear_screen( )  ---------------------------//
 /*************************************************************************/

 void clear_screen( )
    {
       for(int count=0;count<37;count++)
	  {
	     gotoxy(5,8+count);
	     cout<<"                                                                        ";
	  }

       gotoxy(1,2);
    }

 /*************************************************************************/
 //--------------------------  push(const char*)  ------------------------//
 /*************************************************************************/

 void push(const char* Operand)
    {
       if(top==(max_size-1))
	  {
	     cout<<"Error : Stack is full."<<endl;
	     cout<<"\n        Press any key to exit.";

	     getch( );
	     exit(0);
	  }

       else
	  {
	     top++;
	     strcpy(Stack[top],Operand);
	  }
    }

 /*************************************************************************/
 //------------------------------  pop( )  -------------------------------//
 /*************************************************************************/

 const char* pop( )
    {
       char Operand[40]={NULL};

       if(top==-1)
	  {
	     cout<<"Error : Stack is empty."<<endl;
	     cout<<"\n        Press any key to exit.";

	     getch( );
	     exit(0);
	  }

       else
	  {
	     strcpy(Operand,Stack[top]);
	     strset(Stack[top],NULL);
	     top--;
	  }

       return Operand;
    }

 /*************************************************************************/
 //--------------------  convert_ie_to_pe(const char*)  ------------------//
 /*************************************************************************/

 void convert_ie_to_pe(const char* Expression)
    {
       char Infix_expression[100]={NULL};
       char Symbol_scanned[30]={NULL};

       push("(");
       strcpy(Infix_expression,Expression);
       strcat(Infix_expression,"+0)");

       int flag=0;
       int count_1=0;
       int count_2=0;
       int equation_length=strlen(Infix_expression);

       if(Infix_expression[0]=='(')
	  flag=1;

       do
	  {
	     strset(Symbol_scanned,NULL);

	     if(flag==0)
		{
		   int count_3=0;

		   do
		      {
			 Symbol_scanned[count_3]=Infix_expression[count_1];

			 count_1++;
			 count_3++;
		      }
		   while(count_1<=equation_length &&
			   Infix_expression[count_1]!='(' &&
			      Infix_expression[count_1]!='+' &&
				 Infix_expression[count_1]!='-' &&
				    Infix_expression[count_1]!='*' &&
				       Infix_expression[count_1]!='/' &&
					  Infix_expression[count_1]!='^' &&
					     Infix_expression[count_1]!=')');


		   flag=1;
		}

	     else if(flag==1)
		{
		   Symbol_scanned[0]=Infix_expression[count_1];

		   count_1++;

		   if(Infix_expression[count_1]!='(' &&
			 Infix_expression[count_1]!='^' &&
			    Infix_expression[count_1]!='*' &&
			       Infix_expression[count_1]!='/' &&
				  Infix_expression[count_1]!='+' &&
				     Infix_expression[count_1]!='-' &&
					Infix_expression[count_1]!=')')
		      flag=0;

		   if(Infix_expression[count_1-1]=='(' &&
			   (Infix_expression[count_1]=='-' ||
				 Infix_expression[count_1]=='+'))
		      flag=0;
		}

	     if(strcmp(Symbol_scanned,"(")==0)
		push("(");

	     else if(strcmp(Symbol_scanned,")")==0)
		{
		   while(strcmp(Stack[top],"(")!=0)
		      {
			 strcpy(Postfix_expression[count_2],pop( ));

			 count_2++;
		      }

		   pop( );
		}

	     else if(strcmp(Symbol_scanned,"^")==0 ||
			   strcmp(Symbol_scanned,"+")==0 ||
				 strcmp(Symbol_scanned,"-")==0 ||
				       strcmp(Symbol_scanned,"*")==0 ||
					     strcmp(Symbol_scanned,"/")==0)
		{
		   if(strcmp(Symbol_scanned,"^")==0)
		      {  }

		   else if(strcmp(Symbol_scanned,"*")==0 ||
					      strcmp(Symbol_scanned,"/")==0)
		      {
			 while(strcmp(Stack[top],"^")==0 ||
				     strcmp(Stack[top],"*")==0 ||
					   strcmp(Stack[top],"/")==0)
			    {
			       strcpy(Postfix_expression[count_2],pop( ));

			       count_2++;
			    }
		      }

		   else if(strcmp(Symbol_scanned,"+")==0 ||
				    strcmp(Symbol_scanned,"-")==0)
		      {
			 while(strcmp(Stack[top],"(")!=0)
			    {
			       strcpy(Postfix_expression[count_2],pop( ));

			       count_2++;
			    }
		      }

		   push(Symbol_scanned);
		}

	     else
		{
		   strcat(Postfix_expression[count_2],Symbol_scanned);

		   count_2++;
		}
	  }
       while(strcmp(Stack[top],NULL)!=0);

       strcat(Postfix_expression[count_2],"=");
       count_2++;
    }

 /*************************************************************************/
 //----------  evaluate_pe(const long double,const long double)  ---------//
 /*************************************************************************/

 const long double evaluate_pe(const long double x,const long double y)
    {
       long double function_value=0;

       int count_1=-1;

       char Symbol_scanned[30]={NULL};

       do
	  {
	     count_1++;

	     strcpy(Symbol_scanned,Postfix_expression[count_1]);

	     if(strcmp(Symbol_scanned,"^")==0 ||
		      strcmp(Symbol_scanned,"*")==0 ||
			    strcmp(Symbol_scanned,"/")==0 ||
				  strcmp(Symbol_scanned,"+")==0 ||
					strcmp(Symbol_scanned,"-")==0)

		{
		   char Result[30]={NULL};
		   char Operand[2][30]={NULL};

		   strcpy(Operand[0],pop( ));
		   strcpy(Operand[1],pop( ));

		   long double operand[2]={0};
		   long double result=0;

		   char *endptr;

		   for(int count_2=0;count_2<2;count_2++)
		      {
			 int flag=0;

			 if(Operand[count_2][0]=='-')
			    {
			       int length=strlen(Operand[count_2]);

			       for(int count_3=0;count_3<(length-1);count_3++)
				  Operand[count_2][count_3]=Operand[count_2][(count_3+1)];

			       Operand[count_2][count_3]=NULL;

			       flag=1;
			    }

			 if(strcmp(Operand[count_2],"x")==0)
			    operand[count_2]=x;

			 else if(strcmp(Operand[count_2],"y")==0)
			    operand[count_2]=y;

			 else if(strcmp(Operand[count_2],"e")==0)
			    operand[count_2]=2.718282;

			 else if(strcmp(Operand[count_2],"sinx")==0)
			    operand[count_2]=sinl(x);

			 else if(strcmp(Operand[count_2],"cosx")==0)
			    operand[count_2]=cosl(x);

			 else if(strcmp(Operand[count_2],"tanx")==0)
			    operand[count_2]=tanl(x);

			 else if(strcmp(Operand[count_2],"lnx")==0)
			    operand[count_2]=logl(x);

			 else if(strcmp(Operand[count_2],"logx")==0)
			    operand[count_2]=log10l(x);

			 else if(strcmp(Operand[count_2],"siny")==0)
			    operand[count_2]=sinl(y);

			 else if(strcmp(Operand[count_2],"cosy")==0)
			    operand[count_2]=cosl(y);

			 else if(strcmp(Operand[count_2],"tany")==0)
			    operand[count_2]=tanl(y);

			 else if(strcmp(Operand[count_2],"lny")==0)
			    operand[count_2]=logl(y);

			 else if(strcmp(Operand[count_2],"logy")==0)
			    operand[count_2]=log10l(y);

			 else
			    operand[count_2]=strtod(Operand[count_2],&endptr);

			 if(flag)
			    operand[count_2]*=-1;
		      }

		   switch(Symbol_scanned[0])
		      {
			 case '^' : result=powl(operand[1],operand[0]);
				    break;

			 case '*' : result=operand[1]*operand[0];
				    break;

			 case '/' : result=operand[1]/operand[0];
				    break;

			 case '+' : result=operand[1]+operand[0];
				    break;

			 case '-' : result=operand[1]-operand[0];
				    break;
		      }

		   gcvt(result,25,Result);

		   push(Result);
		}

	     else if(strcmp(Symbol_scanned,"=")!=0)
		push(Symbol_scanned);
	  }
       while(strcmp(Symbol_scanned,"=")!=0);

       char Function_value[30]={NULL};
       char *endptr;

       strcpy(Function_value,pop( ));
       function_value=strtod(Function_value,&endptr);

       return function_value;
    }

 /*************************************************************************/
 //-----------------------------  get_input( )  --------------------------//
 /*************************************************************************/

 void get_input( )
    {
       clear_screen( );

       gotoxy(6,10);
       cout<<"Input :";

       gotoxy(6,11);
       cout<<"";

       gotoxy(6,37);
       cout<<"Note : Write the function with proper Braces ( ) e.g; 2x+3 as (2*x)+3";

       gotoxy(6,40);
       cout<<"Available Operators  :  ^ (raised to power) , * , / , + , -";

       gotoxy(6,42);
       cout<<"Available Operands   :  x , e , sinx , cosx , tanx , lnx , logx ,";

       gotoxy(6,44);
       cout<<"                        any number and all above functions with y.";

       gotoxy(6,14);
       cout<<"Enter the Function : f(x,y) = ";

       cin>>Fx;

       convert_ie_to_pe(Fx);

       gotoxy(6,17);
       cout<<"Enter the value of xn = ";

       cin>>x;

       gotoxy(6,19);
       cout<<"Enter the value of x0 = ";

       cin>>x0;

       gotoxy(6,21);
       cout<<"Enter the value of y0 = ";

       cin>>y0;

       gotoxy(6,23);
       cout<<"Enter the value of h = ";

       cin>>h;
    }

 /*************************************************************************/
 //--------------------  apply_ruunge_kutta_method( )  -------------------//
 /*************************************************************************/

 void apply_runge_kutta_method( )
    {
       xx[0]=x0;
       yy2[0]=y0;
       yy3[0]=y0;

       do
	  {
	     xx[(n+1)]=(xx[n]+h);
	     n++;
	  }
       while(xx[n]<x);

       long double k1=0;
       long double k2=0;
       long double ynp1=0;
       long double xn=x0;
       long double yn=y0;

       for(int count_1=0;count_1<n;count_1++)
	  {
	     k1=0;
	     k2=0;
	     ynp1=0;

	     k1=evaluate_pe(xn,yn);
	     k2=evaluate_pe((xn+h),(yn+(h*k1)));

	     ynp1=(yn+((h*(k1+k2))/2));

	     yn=ynp1;
	     xn+=h;
	     yy2[(count_1+1)]=ynp1;
	  }

       two_stage_result=ynp1;

       long double k3=0;
       long double k4=0;

       xn=x0;
       yn=y0;

       for(int count_2=0;count_2<n;count_2++)
	  {
	     k1=0;
	     k2=0;
	     k3=0;
	     k4=0;
	     ynp1=0;

	     k1=evaluate_pe(xn,yn);
	     k2=evaluate_pe((xn+(h/2)),(yn+((h*k1)/2)));
	     k3=evaluate_pe((xn+(h/2)),(yn+((h*k2)/2)));
	     k4=evaluate_pe((xn+h),(yn+(h*k3)));

	     ynp1=(yn+((h*(k1+(2*k2)+(2*k3)+k4))/6));

	     yn=ynp1;
	     xn+=h;
	     yy3[(count_2+1)]=ynp1;
	  }

       three_stage_result=ynp1;

       clear_screen( );

       gotoxy(6,9);
       cout<<"Solution :";

       gotoxy(6,10);
       cout<<"";

       gotoxy(18,12);
       cout<<"Ŀ";

       gotoxy(18,13);
       cout<<"       x         2-stage  y     3-stage  y   ";

       gotoxy(18,14);
       cout<<"Ĵ";

       gotoxy(18,15);
       cout<<"                                             ";

       for(int count_3=0;count_3<=n;count_3++)
	  {
	     gotoxy(18,(wherey( )+1));
	     cout<<"                                             ";

	     gotoxy(18,(wherey( )+1));
	     cout<<"                                             ";
	  }

       gotoxy(18,(wherey( )+1));
       cout<<"";

       gotoxy(25,16);

       for(int count_4=0;count_4<=n;count_4++)
	  {
	     gotoxy(20,wherey( ));
	     cout<<xx[count_4];

	     gotoxy(36,wherey( ));
	     cout<<yy2[count_4];

	     gotoxy(52,wherey( ));
	     cout<<yy3[count_4];

	     gotoxy(25,(wherey( )+2));
	  }

       gotoxy(25,43);
       cout<<"Press any key to continue...";

       getch( );

    }

 /*************************************************************************/
 //----------------------------  show_result( )  -------------------------//
 /*************************************************************************/

 void show_result( )
    {
       clear_screen( );

       gotoxy(6,9);
       cout<<"Runge-Kutta Methods :";

       gotoxy(6,10);
       cout<<"";

       gotoxy(6,12);
       cout<<"2-Stage Method :  y(n+1) = yn + (h/2)(k1+k2)";

       gotoxy(40,14);
       cout<<"where :   k1 = f(xn,yn)";

       gotoxy(40,15);
       cout<<"          k2 = f(xn+h,yn+hk1)";

       gotoxy(6,18);
       cout<<"3-Stage Method:   y(n+1) = yn + (h/6)(k1+2k2+2k3+k4)";

       gotoxy(40,20);
       cout<<"where :  k1 = f(xn,yn)";

       gotoxy(40,21);
       cout<<"         k2 = f(xn+(h/2),yn+(h/2)k1)";

       gotoxy(40,22);
       cout<<"         k3 = f(xn+(h/2),yn(h/2)k2)";

       gotoxy(40,23);
       cout<<"         k4 = f(xn+h,yn+hk3)";

       gotoxy(6,25);
       cout<<"Estimated Value :";

       gotoxy(6,26);
       cout<<"";

       gotoxy(8,28);
       cout<<"Estimated Differential Value (using 2-Stage Method) = "<<two_stage_result;

       gotoxy(8,30);
       cout<<"Estimated Differential Value (using 3-Stage Method) = "<<three_stage_result;

       gotoxy(1,2);
    }

 /*************************************************************************/
 /*************************************************************************/
 //-----------------------------  THE END  -------------------------------//
 /*************************************************************************/
 /*************************************************************************/