
 /*************************************************************************/
 /*************************************************************************

 A C++ program to develop two Classes as follows:

 CArray
	- GetArray( )
	- ShowArray( )
	- ArraySum( )
	- CopyArray(int [])
	- SearchArray(int)
	- SortArray(int)
	- ShowArrayDuplicates( )
	- Overload Operators : == , = , + , - , *

 CString
	- GetString( )
	- ShowString( )
	- StringCompare(char [])
	- StringCopy(char [])
	- StringLength( )
	- StringConcatination(char [])
	- Overload Operators : == , = , += , +

  *************************************************************************/
 /*************************************************************************/

  /*************************************************************************

	  By :
		Muhammad Tahir Shahzad  [ MTS ]
		B.C.S Honours  [ 2000-04 ]
		Government College University Lahore
		Pakistan

      E-mail :  mtshome@wol.net.pk

    Web-Site :  www.mts-home.cjb.net  [ www.wol.net.pk/mtshome ]
		www.mtshome.cjb.net   [ www.geocities.com/mtahirshahzad ]

  *************************************************************************/

 /*************************************************************************/
 /*************************************************************************/
 //---------------------------  Header Files  ----------------------------//
 /*************************************************************************/
 /*************************************************************************/

 /*************************************************************************/
 //-----------------------------  user-defined  --------------------------//
 /*************************************************************************/

 # include "VCPP_02.h"

 /*************************************************************************/
 /*************************************************************************/
 //------------------------  Funcion Definitions  ------------------------//
 /*************************************************************************/
 /*************************************************************************/

 /*************************************************************************/
 /*************************************************************************/
 //------------------------------  CArray  -------------------------------//
 /*************************************************************************/
 /*************************************************************************/

 /*************************************************************************/
 //-----------------------------  CArray( )  -----------------------------//
 /*************************************************************************/

 CArray::CArray( )
    {
       for(int count=0;count<10;count++)
	  array[count]=0;
    }

 /*************************************************************************/
 //-----------------------------  GetArray( )  ---------------------------//
 /*************************************************************************/

 void CArray::GetArray( )
    {
       for(int count=0;count<10;count++)
	  {
	      cout<<"\t Element["<<count<<"]  =  ";
	      cin>>array[count];
	  }
    }

 /*************************************************************************/
 //-----------------------------  ShowArray( )  --------------------------//
 /*************************************************************************/

 void CArray::ShowArray( )
    {
       for(int count=0;count<10;count++)
	  cout<<"\t Element["<<count<<"]  =  "<<array[count]<<endl;
    }

 /*************************************************************************/
 //-----------------------------  SortArray( )  --------------------------//
 /*************************************************************************/

 void CArray::SortArray(const int order)
    {
       for(int count_1=0;count_1<10;count_1++)
	  {
	     for(int count_2=0;count_2<9;count_2++)
		{
		   if((array[count_2]>array[(count_2+1)] && order==0) ||
			    (array[count_2]<array[(count_2+1)] && order==1))
		      {
			 int temp=0;

			 temp=array[count_2];
			 array[count_2]=array[(count_2+1)];
			 array[(count_2+1)]=temp;
		      }
		}
	  }
    }

 /*************************************************************************/
 //-----------------------------  CopyArray( )  --------------------------//
 /*************************************************************************/

 void CArray::CopyArray(const int copy_array[])
    {
       for(int count=0;count<10;count++)
	  array[count]=copy_array[count];
    }

 /*************************************************************************/
 //-----------------------------  ArraySum( )  ---------------------------//
 /*************************************************************************/

 const long CArray::ArraySum( )
    {
       long sum=0;

       for(int count=0;count<10;count++)
	  sum+=array[count];

       return sum;
    }

 /*************************************************************************/
 //-------------------------  ShowArrayDuplicates( )  --------------------//
 /*************************************************************************/

 const int CArray::ShowArrayDuplicates( )
    {
       int duplicate_flag=0;

       for(int count_1=0;count_1<10;count_1++)
	  {
	     int repeat=0;
	     int counter=0;

	     for(int count_2=0;count_2<count_1;count_2++)
		{
		   if(array[count_2]==array[count_1])
		      repeat=1;
		}

	     for(int count_3=count_1;count_3<10;count_3++)
		{
		   if(array[count_3]==array[count_1])
		      counter++;
		}

	     if(counter>=2 && repeat==0)
		cout<<"\n\t Element["<<count_1<<"]  =  "<<array[count_1];

	     if(counter>=2 && repeat==0 && duplicate_flag==0)
		duplicate_flag=1;
	  }

       return duplicate_flag;
    }

 /*************************************************************************/
 //-----------------------------  SearchArray( )  ------------------------//
 /*************************************************************************/

 const int CArray::SearchArray(const int search_key)
    {
       for(int count=0;count<10;count++)
	  {
	     if(search_key==array[count])
		return count;
	  }

       return -1;
    }

 /*************************************************************************/
 //-----------------------------  operator+( )  --------------------------//
 /*************************************************************************/

 const CArray CArray::operator+(const CArray plus_array)
    {
       CArray temp;

       for(int count=0;count<10;count++)
	  temp.array[count]=(array[count]+plus_array.array[count]);

       return temp;
    }

 /*************************************************************************/
 //-----------------------------  operator-( )  --------------------------//
 /*************************************************************************/

 const CArray CArray::operator-(const CArray minus_array)
    {
       CArray temp;

       for(int count=0;count<10;count++)
	  temp.array[count]=(array[count]-minus_array.array[count]);

       return temp;
    }

 /*************************************************************************/
 //-----------------------------  operator*( )  --------------------------//
 /*************************************************************************/

 const CArray CArray::operator*(const CArray multiply_array)
    {
       CArray temp;

       for(int count=0;count<10;count++)
	  temp.array[count]=(array[count]*multiply_array.array[count]);

       return temp;
    }

 /*************************************************************************/
 //-----------------------------  operator=( )  --------------------------//
 /*************************************************************************/

 const CArray CArray::operator=(const CArray assign_array)
    {
       for(int count=0;count<10;count++)
	  array[count]=assign_array.array[count];

       return assign_array;
    }

 /*************************************************************************/
 //----------------------------  operator==( )  --------------------------//
 /*************************************************************************/

 const int CArray::operator==(const CArray compare_array)
    {
       for(int count=0;count<10;count++)
	  {
	     if(array[count]!=compare_array.array[count])
		return 0;
	  }

       return 1;
    }

 /*************************************************************************/
 /*************************************************************************/
 //------------------------------  CString  -------------------------------//
 /*************************************************************************/
 /*************************************************************************/

 /*************************************************************************/
 //-----------------------------  CString( )  ----------------------------//
 /*************************************************************************/

 CString::CString( )
    {
       for(int count=0;count<100;count++)
	  String[count]=NULL;
    }

 /*************************************************************************/
 //-----------------------------  GetString( )  --------------------------//
 /*************************************************************************/

 void CString::GetString( )
    {
		cin>>String;
    }

 /*************************************************************************/
 //----------------------------  ShowString( )  --------------------------//
 /*************************************************************************/

 void CString::ShowString( )
    {
       for(int count=0;count<100;count++)
	  {
	     if(String[count]==NULL)
		break;

	     cout<<String[count];
	  }
    }

 /*************************************************************************/
 //----------------------------  StringCopy( )  --------------------------//
 /*************************************************************************/

 void CString::StringCopy(const char *Copy_string)
    {
       int count=0;

       do
	  {
	     String[count]=Copy_string[count];

	     count++;
	  }
       while(Copy_string[count]!=NULL);

       String[count]=NULL;
    }

 /*************************************************************************/
 //-----------------------  StringConcatenation( )  ----------------------//
 /*************************************************************************/

 void CString::StringConcatenation(const char *Concating_string)
    {
       int length=0;

       do
	  {
	     if(String[length]==NULL)
		break;

	     length++;
	  }
       while(1);

       int count=0;

       do
	  {
	     String[length]=Concating_string[count];

	     count++;
	     length++;
	  }
       while(Concating_string[count]!=NULL);

       String[length]=NULL;
    }

 /*************************************************************************/
 //---------------------------  StringCompare( )  ------------------------//
 /*************************************************************************/

 const int CString::StringCompare(const char *Compare_string,
						   const int case_sensitive)
    {
       int count=0;

       if(case_sensitive==0)
	  {
	     do
		{
		   if(String[count]==Compare_string[count])
		      count++;

		   else if(String[count]>Compare_string[count])
		      return 1;

		   else if(String[count]<Compare_string[count])
		      return -1;
		}
	     while(Compare_string[count]!=NULL && String[count]!=NULL);
	  }

       else if(case_sensitive!=0)
	  {
	     int key_1=NULL;
	     int key_2=NULL;

	     do
		{
		   key_1=NULL;
		   key_2=NULL;

		   key_1=int(String[count]);
		   key_2=int(Compare_string[count]);

		   if(key_1>=97 && key_1<=122)
		      key_1-=32;

		   if(key_2>=97 && key_2<=122)
		      key_2-=32;

		   if(key_1==key_2)
		      count++;

		   else if(key_1>key_2)
		      return 1;

		   else if(key_1<key_2)
		      return -1;
		}
	     while(Compare_string[count]!=NULL && String[count]!=NULL);
	  }

       if(String[count]!=NULL)
	  return 1;

       else if(Compare_string[count]!=NULL)
	  return -1;

       return 0;
    }

 /*************************************************************************/
 //---------------------------  StringLength( )  -------------------------//
 /*************************************************************************/

 const int CString::StringLength( )
    {
       int length=0;

       do
	  {
	     if(String[length]==NULL)
		break;

	     length++;
	  }
       while(1);

       return length;
    }

 /*************************************************************************/
 //-----------------------------  operator+( )  --------------------------//
 /*************************************************************************/

 const CString CString::operator+(const CString Add_string)
    {
       CString Temp;

       int length=0;

       do
	  {
	     if(String[length]==NULL)
		break;

	     Temp.String[length]=String[length];

	     length++;
	  }
       while(1);

       int count=0;

       do
	  {
	     Temp.String[length]=Add_string.String[count];

	     count++;
	     length++;
	  }
       while(Add_string.String[count]!=NULL);

       Temp.String[length]=NULL;

       return Temp;
    }

 /*************************************************************************/
 //-----------------------------  operator=( ) ---------------------------//
 /*************************************************************************/

 const CString CString::operator=(const CString Assign_string)
    {
       int count=0;

       do
	  {
	     String[count]=Assign_string.String[count];

	     count++;
	  }
       while(Assign_string.String[count]!=NULL);

       String[count]=NULL;

       return Assign_string;
    }

 /*************************************************************************/
 //----------------------------  operator+=( )  --------------------------//
 /*************************************************************************/

 const CString CString::operator+=(const CString Concatenate_string)
    {
       CString Temp;

       int length=0;

       do
	  {
	     if(String[length]==NULL)
		break;

	     Temp.String[length]=String[length];

	     length++;
	  }
       while(1);

       int count=0;

       do
	  {
	     String[length]=Concatenate_string.String[count];
	     Temp.String[length]=Concatenate_string.String[count];

	     count++;
	     length++;
	  }
       while(Concatenate_string.String[count]!=NULL);

       String[length]=NULL;
       Temp.String[length]=NULL;

       return Temp;
    }

 /*************************************************************************/
 //-----------------------------  operator==( )  -------------------------//
 /*************************************************************************/

 const int CString::operator==(const CString Compare_string)
    {
       int count=0;

       do
	  {
	     if(String[count]==Compare_string.String[count])
		count++;

	     else
		return 0;
	  }
       while(Compare_string.String[count]!=NULL && String[count]!=NULL);

       if(String[count]!=NULL || Compare_string.String[count]!=NULL)
	  return 0;

       return 1;
    }

 /*************************************************************************/
 /*************************************************************************/
 //------------------------------  main( )  ------------------------------//
 /*************************************************************************/
 /*************************************************************************/

 int main( )
    {
       cout<<" \n **********  CArray Class Implementation  ********* \n"<<endl;
	 
	   CArray Array_object_1;
       CArray Array_object_2;
       CArray Array_object_3;

       int arr[10]={5,1,7,0,8,3,6,9,2,4};

       cout<<" Enter the Elements of the Array : \n";
       Array_object_1.GetArray( );

       getch( );

       cout<<" \n The Elements of the Array are : \n";
       Array_object_1.ShowArray( );

       getch( );

       Array_object_1.CopyArray(arr);
       Array_object_2.CopyArray(arr);
       Array_object_3.CopyArray(arr);

       cout<<" \n The Copied Elements of the Array are : \n";
       Array_object_1.ShowArray( );

       getch( );

       Array_object_1.SortArray( );

       cout<<" \n The Elements of the Array in Ascending Order are : \n";
       Array_object_1.ShowArray( );

       getch( );

       Array_object_1.SortArray(1);

       cout<<" \n The Elements of the Array in Descending are : \n";
       Array_object_1.ShowArray( );

       getch( );

       cout<<" \n The Duplicate Elements of the Array are : \n";

       if(Array_object_1.ShowArrayDuplicates( )==0)
		  cout<<"\t No Duplicate Element found."<<endl<<endl;

       cout<<" \n Result of Array Comparison = ";

       if(Array_object_2==Array_object_3)
		cout<<"Equal"<<endl<<endl;

       else
		cout<<" Not Equal"<<endl<<endl;

       cout<<" Sum of the array elements = "<<Array_object_1.ArraySum( )<<endl<<endl;

       cout<<" Search result for 4 = "<<Array_object_1.SearchArray(4)<<endl;

       cout<<" Search result for 14 = "<<Array_object_1.SearchArray(14)<<endl;

       getch( );

       cout<<" \n The Elements of the Array after addition are : \n";
       Array_object_1=Array_object_2+Array_object_3;
       Array_object_1.ShowArray( );

       getch( );

       cout<<" \n The Elements of the Array after subtraction are : \n";
       Array_object_1=Array_object_2-Array_object_3;
       Array_object_1.ShowArray( );

       getch( );

       cout<<" \n The Elements of the Array after multiplication are : \n";
       Array_object_1=Array_object_2*Array_object_3;
       Array_object_1.ShowArray( );

       getch();

	   cout<<" \n *********  CString Class Implementation  ********* \n "<<endl;

       CString String_object_1;
       CString String_object_2;
       CString String_object_3;

       cout<<" Enter the String : ";
       String_object_1.GetString( );

       cout<<"\n\n The String is : ";
       String_object_1.ShowString( );

       cout<<"\n\n Length of the String = "<<String_object_1.StringLength( );

       String_object_1.StringCopy("MTS");

       cout<<"\n\n The String is : ";
       String_object_1.ShowString( );

       cout<<"\n\n Result of String Comparison = "<<String_object_1.StringCompare("mTs");
       cout<<"\n\n Result of String Comparison = "<<String_object_1.StringCompare("MTS",1);

       String_object_1.StringConcatenation(" of Computer");

       cout<<"\n\n The String is : ";
       String_object_1.ShowString( );

       String_object_2.StringCopy("Muhammad");
       String_object_3.StringCopy(" Tahir Shahzad");

       String_object_1=String_object_2+String_object_3;

       cout<<"\n\n The String is : ";
       String_object_1.ShowString( );

       String_object_2.StringCopy(" - Bachelor of");
       String_object_3.StringCopy(" Computer Science");

       String_object_1+=String_object_2+=String_object_3;

       cout<<"\n\n The String is : ";
       String_object_1.ShowString( );

       String_object_2.StringCopy("Bachelor of");
       String_object_3.StringCopy("Computer Scince");

       cout<<"\n\n Result of String Comparison = ";

       if(String_object_2==String_object_3)
		cout<<"Equal"<<endl<<endl;

       else
		  cout<<"Not Equal"<<endl<<endl;

       return 0;
    }

 /*************************************************************************/
 /*************************************************************************/
 //-----------------------------  THE END  -------------------------------//
 /*************************************************************************/
 /*************************************************************************/

