
 /*************************************************************************/
 //----------------------  MATHLIB.H  ------------------------------------//
 /*************************************************************************/

  /*************************************************************************

	  By :
		Muhammad Tahir Shahzad  [ MTS ]
		B.C.S Honours  [ 2000-04 ]
		Government College University Lahore
		Pakistan

      E-mail :  mtshome@wol.net.pk

    Web-Site :  www.mts-home.cjb.net  [ www.wol.net.pk/mtshome ]
		www.mtshome.cjb.net   [ www.geocities.com/mtahirshahzad ]

  *************************************************************************/

 #ifndef MATHLIB_H
 #define MATHLIB_H

/**************************************************************************/
//----------------------  Header Files  ----------------------------------//
/**************************************************************************/

 #include<conio.h>
 #include<math.h>

/**************************************************************************/
//----------------------  FACTORIAL(long double)  ------------------------//
/**************************************************************************/

 long double FACTORIAL(long double number)
    {
       long double factorial=1;

       if(number<0)
	  factorial=0;

       else if(number==0 || number==1)
	  factorial=1;

       else
	  {
	     for(int count=1;count<=number;count++)
		factorial=factorial*count;
	  }

       return factorial;
    }

/**************************************************************************/
//----------------------  nCr(long double,long double)  ------------------//
/**************************************************************************/

 long double nCr(long double n,long double r)
    {
       long double ncr;

       ncr=FACTORIAL(n)/( FACTORIAL(n-r)*FACTORIAL(r) );

       return ncr;
    }

/**************************************************************************/
//----------------------  nPr(long double,long double)  ------------------//
/**************************************************************************/

 long double nPr(long double n,long double r)
    {
       long double npr;

       npr=FACTORIAL(n)/FACTORIAL(n-r);

       return npr;
    }

/**************************************************************************/
//----------------------  SIN_DEG(long double)  --------------------------//
/**************************************************************************/

 long double  SIN_DEG(long double angle)
    {
       long double result;

       result=sinl(angle*0.017453292);

       return result;
    }

/**************************************************************************/
//----------------------  COS_DEG(long double)  --------------------------//
/**************************************************************************/

 long double COS_DEG(long double angle)
    {
       long double result;

       result=cosl(angle*0.017453292);

       return result;
    }

/**************************************************************************/
//----------------------  TAN_DEG(long double)  --------------------------//
/**************************************************************************/

 long double TAN_DEG(long double angle)
    {
       long double result;

       result=tanl(angle*0.017453292);

       return result;
    }

/**************************************************************************/
//----------------------  COSEC_DEG(long double)  ------------------------//
/**************************************************************************/

 long double COSEC_DEG(long double angle)
    {
       long double result;

       result=1/sinl(angle*0.017453292);

       return result;
    }

/**************************************************************************/
//----------------------  SEC_DEG(long double)  --------------------------//
/**************************************************************************/

 long double SEC_DEG(long double angle)
    {
       long double result;

       result=1/cosl(angle*0.017453292);

       return result;
    }

/**************************************************************************/
//----------------------  COT_DEG(long double)  --------------------------//
/**************************************************************************/

 long double COT_DEG(long double angle)
    {
       long double result;

       result=1/tanl(angle*0.017453292);

       return result;
    }

/**************************************************************************/
//----------------------  SIN_1_DEG(long double)  ------------------------//
/**************************************************************************/
 long double SIN_1_DEG(long double angle)
    {
       long double i=-1;
       long double answer;

       answer=fabsl(angle);

       if(angle<-1 || angle>1)
	  return -0.009009009;

       else if(answer==1)
	  return ((angle<0)?-90:90);

       else if(angle==0)
	  return 0;

       else
	  {
	     do
		{
		   i+=0.01;
		}
	     while(sinl(i*0.017453292)<=answer);

	     return ((angle<0)?-i:i);
	  }
    }

/**************************************************************************/
//----------------------  COS_1_DEG(long double)  ------------------------//
/**************************************************************************/

 long double COS_1_DEG(long double angle)
    {
       long double value[200]={
		      180,171.89,168.523,165.93,163.74,161.85,160.052,158.435,
		      156.926,155.505,154.158,152.873,151.642,150.459,149.317,
		      148.217,147.140,146.099,145.085,144.096,143.130,142.186,
		      141.261,140.354,139.464,138.590,137.731,136.886,136.054,
		      135.235,134.427,133.630,132.844,132.067,131.300,130.542,
		      129.792,129.050,128.316,127.590,126.870,126.157,125.450,
		      124.750,124.056,123.367,122.684,122.006,121.332,120.664,
		      120.000,119.341,118.685,118.034,117.387,116.744,116.104,
		      115.468,114.835,114.205,113.578,112.954,112.334,111.716,
		      111.100,110.487,109.877,109.469,108.633,108.059,107.458,
		      106.858,106.260,105.664,105.070,104.478,103.886,103.297,
		      102.709,102.122,101.537,100.953,100.370,99.788,99.207,
		      98.627,98.048,97.470,96.892,96.315,95.739,95.164,94.589,
		      94.014,93.440,92.866,92.292,91.719,91.146,90.573,90,
		      89.427,88.854,88.281,87.708,87.134,86.560,85.986,85.411,
		      84.836,84.261,83.685,83.108,82.530,81.952,81.381,80.793,
		      80.212,79.630,79.047,78.463,77.877,77.291,76.703,76.113,
		      75.522,74.930,74.336,73.740,73.142,72.542,71.940,71.337,
		      70.731,70.123,69.513,68.909,68.284,67.666,67.046,66.422,
		      65.795,65.165,64.532,63.896,63.256,62.613,61.315,61.315,
		      60.659,60,59.336,58.668,57.995,57.316,56.633,55.944,
		      55.25,54.55,53.843,52.410,51.684,50.95,50.208,49.458,48.7,
		      47.933,47.156,46.370,45.573,44.765,43.946,43.114,42.269,
		      41.410,40.536,39.646,38.739,37.814,36.870,36.870,35.904,
		      34.915,33.901,32.860,31.788,30.683,29.541,28.358,27.127,
		      25.842,24.495,23.074,21.565,19.948,18.195,16.260,14.070,
		      11.478,8.110};

       long double  result;

       if(angle>1 || angle<-1)
	  result=-0.009009009;

       else if(angle==1)
	  result=0;

       else
	  {
	     long double temp=-1;

	     int count=0;

	     while(temp<angle)
	       {
		  temp+=0.01;
		  count++;
	       };

	     if(count<=153)
		result=value[count];

	     else if(count>153)
		result=value[count-1];
	  }
       return result;
    }

/**************************************************************************/
//----------------------  TAN_1_DEG(long double)  ------------------------//
/**************************************************************************/

 long double TAN_1_DEG(long double angle)
    {
       long double i=0;
       long double answer;

       answer=fabsl(angle);

       if(angle>115)
	  return 90;

       else
	  {
	     do
		{
		  i+=0.01;
		}
	     while(tanl(i*0.017453292)<=answer);

	     return ((angle<0)?-i:i);
	  }
    }

/**************************************************************************/
//----------------------  SIN_RAD(long double)  --------------------------//
/**************************************************************************/

 long double  SIN_RAD(long double angle)
    {
       long double result;

       result=sinl(angle);

       return result;
    }

/**************************************************************************/
//----------------------  COS_RAD(long double)  --------------------------//
/**************************************************************************/

 long double COS_RAD(long double angle)
    {
       long double result;

       result=cosl(angle);

       return result;
    }

/**************************************************************************/
//----------------------  TAN_RAD(long double)  --------------------------//
/**************************************************************************/

 long double TAN_RAD(long double angle)
    {
       long double result;

       result=tanl(angle);

       return result;
    }

/**************************************************************************/
//----------------------  COSEC_RAD(long double)  ------------------------//
/**************************************************************************/

 long double COSEC_RAD(long double angle)
    {
       long double result;

       result=1/sinl(angle);

       return result;
    }

/**************************************************************************/
//----------------------  SEC_RAD(long double)  --------------------------//
/**************************************************************************/

 long double SEC_RAD(long double angle)
    {
       long double result;

       result=1/cosl(angle);

       return result;
    }

/**************************************************************************/
//----------------------  COT_RAD(long double)  --------------------------//
/**************************************************************************/

 long double COT_RAD(long double angle)
    {
       long double result;

       result=1/tanl(angle);

       return result;
    }
/**************************************************************************/
//----------------------  SIN_1_RAD(long double)  ------------------------//
/**************************************************************************/

 long double SIN_1_RAD(long double angle)
    {
       long double i=-1;
       long double answer;

       answer=fabsl(angle);

       if(angle<-1 || angle>1)
	  return -0.009009009;

       else if(answer==1)
	  return ((angle<0)?-90:90);

       else if(angle==0)
	  return 0;

       else
	  {
	     do
		{
		   i+=0.01;
		}
	     while(sinl(i)<=answer);

	     return ((angle<0)?-i:i);
	  }
    }

/**************************************************************************/
//----------------------  COS_1_RAD(long double)  ------------------------//
/**************************************************************************/

long double COS_1_RAD(long double angle)
 {
       long double value[200]={
		      3.142,3.000,2.941,2.896,2.855,2.824,2.793,2.765,2.739,
		      2.714,2.691,2.668,2.647,2.626,2.606,2.587,2.508,2.550,
		      2.532,2.515,2.498,2.482,2.466,2.450,2.434,2.419,2.404,
		      2.389,2.375,2.360,2.346,2.332,2.319,2.305,2.292,2.278,
		      2.265,2.252,2.240,2.227,2.214,2.202,2.190,2.177,2.165,
		      2.153,2.141,2.129,2.118,2.106,2.094,2.083,2.071,2.060,
		      2.049,2.038,2.026,2.015,2.004,1.993,1.982,1.971,1.961,
		      1.950,1.939,1.928,1.918,1.907,1.896,1.886,1.875,1.865,
		      1.854,1.844,1.834,1.823,1.813,1.803,1.793,1.782,1.772,
		      1.762,1.752,1.742,1.731,1.721,1.711,1.701,1.691,1.681,
		      1.671,1.661,1.651,1.641,1.631,1.621,1.611,1.601,1.591,
		      1.581,1.571,1.561,1.551,1.541,1.531,1.521,1.511,1.501,
		      1.491,1.481,1.471,1.461,1.450,1.440,1.430,1.420,1.410,
		      1.400,1.390,1.380,1.370,1.360,1.349,1.339,1.328,1.318,
		      1.308,1.297,1.287,1.276,1.266,1.256,1.245,1.234,1.224,
		      1.213,1.202,1.192,1.181,1.170,1.159,1.148,1.137,1.126,
		      1.115,1.104,1.093,1.082,1.070,1.059,1.047,1.036,1.024,
		      1.012,1.000,0.988,0.976,0.964,0.952,0.940,0.927,0.915,
		      0.902,0.889,0.876,0.863,0.850,0.837,0.823,0.809,0.795,
		      0.781,0.767,0.752,0.738,0.723,0.707,0.692,0.676,0.660,
		      0.644,0.627,0.609,0.592,0.574,0.555,0.536,0.516,0.495,
		      0.473,0.451,0.428,0.403,0.376,0.348,0.318,0.284,0.246,
		      0.200,0.142};

       long double  result;

       if(angle>1 || angle<-1)
	  result=-0.009009009;

       else if(angle==1)
	  result=0;

       else
	  {
	     long double temp=-1;

	     int count=0;

	     while(temp<angle)
	       {
		  temp+=0.01;
		  count++;
	       };

	     if(count<=153)
		result=value[count];

	     else if(count>153)
		result=value[count-1];
	  }
       return result;
    }

/**************************************************************************/
//----------------------  TAN_1_RAD(long double)  ------------------------//
/**************************************************************************/

 long double TAN_1_RAD(long double angle)
    {
       long double i=0;
       long double answer;

       answer=fabsl(angle);

       if(angle>115)
	  return 90;
       else
	  {
	     do
		{
		   i+=0.01;
		}
	     while(tanl(i)<=answer);

	     return ((angle<0)?-i:i);
	}
    }

/**************************************************************************/
//----------------------  EXP(long double,long double)  ------------------//
/**************************************************************************/

 long double EXP(long double x,long double y)
    {
      long double count=1;
      long double answer=0;

      for(int i=1;i<=y;i++)
	 count=count*10;

      answer=x*count;

      return answer;
   }

/**************************************************************************/
//-------------------------------  THE END  ------------------------------//
/**************************************************************************/

 #endif
