// FilePage.cpp : implementation file
//

#include "stdafx.h"
#include "VCPP_16.h"
#include "FilePage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFilePage property page

IMPLEMENT_DYNCREATE(CFilePage, CPropertyPage)

CFilePage::CFilePage() : CPropertyPage(CFilePage::IDD)
{
	//{{AFX_DATA_INIT(CFilePage)
	//}}AFX_DATA_INIT
}

CFilePage::~CFilePage()
{
	m_imgFile.Detach( );
}

void CFilePage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFilePage)
	DDX_Control(pDX, IDC_LIST_RESULT, m_ctlList);
	DDX_Control(pDX, IDC_EDIT_FILE_NAME, m_ctlFileName);
	DDX_Control(pDX, IDC_COMBO_DRIVE_NAME, m_cbDriveNames);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFilePage, CPropertyPage)
	//{{AFX_MSG_MAP(CFilePage)
	ON_BN_CLICKED(IDC_BTN_SEARCH, OnBtnSearch)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFilePage message handlers

BOOL CFilePage::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	m_ctlList.InsertColumn(0,"File Name",LVCFMT_LEFT,100);
	m_ctlList.InsertColumn(1,"Location",LVCFMT_LEFT,140);
	m_ctlList.InsertColumn(2,"Type",LVCFMT_LEFT,70);
	m_ctlList.InsertColumn(3,"Size (Bytes)",LVCFMT_LEFT,80);

	char aDrives[120]={NULL};

	GetLogicalDriveStrings(120,aDrives);

	int nIndex=0;

	while(aDrives[nIndex]!=NULL)
	{
		CString strDriveName(aDrives[nIndex]);

		strDriveName+=":\\";
		
		CString strDrive;

		if(GetDriveType(strDriveName)==DRIVE_REMOVABLE)
			strDrive="3.5\" Floppy";

		else if(GetDriveType(strDriveName)==DRIVE_CDROM)
			strDrive="Compact Disc";

		else if(GetDriveType(strDriveName)==DRIVE_FIXED)
			strDrive="Local Disc";

		else if(GetDriveType(strDriveName)==DRIVE_REMOTE)
			strDrive="Network Disc";

		strDrive+=( " (" + strDriveName + ")");

		m_cbDriveNames.AddString(strDrive);
		nIndex+=4;
	}

 HIMAGELIST  hSystemImageList; 
 SHFILEINFO    sfi; 

   //get a handle to the system small icon list 
 hSystemImageList = 
  (HIMAGELIST)SHGetFileInfo( 
  (LPCTSTR)_T("C:\\"), 
  0, 
  &sfi, 
  sizeof(SHFILEINFO), 
  SHGFI_SYSICONINDEX | SHGFI_SMALLICON); 

 m_imgFile.Attach(hSystemImageList); 

 m_ctlList.SetImageList(&m_imgFile, LVSIL_SMALL); 


	return TRUE;
}

void CFilePage::OnBtnSearch() 
{
	// TODO: Add your control notification handler code here
	CString strSelectedDrive;
	CString strFileName;

	m_ctlFileName.GetWindowText(strFileName);
	m_cbDriveNames.GetWindowText(strSelectedDrive);

	if(strFileName.GetLength( )==0)
	{
		MessageBox("Invalid File Name. Please enter a valid file name to search.","Error",MB_ICONINFORMATION);

		m_ctlFileName.SetFocus( );
	}

	else if(strSelectedDrive.GetLength( )==0)
	{
		MessageBox("Invalid Drive Name. Please select a valid drive name.","Error",MB_ICONINFORMATION);

		m_cbDriveNames.SetFocus( );
	}

	else
	{
		int nLength=strSelectedDrive.GetLength( );
		
//		CString strSelectedDriveName;
		CString strPath;

//		strSelectedDriveName=strSelectedDrive.GetAt((nLength-4));
//		strSelectedDriveName+=":\\";
		strPath=strSelectedDrive.GetAt((nLength-4));
		strPath+=":";
//		strPath+=":\\";

//		strSelectedDriveName+=strFileName;

		m_ctlList.DeleteAllItems( );
		
		CFileFind File;

		m_nIndex=0;

		SearchFile(strPath,strFileName);
/*
		BOOL bFileFound=File.FindFile(strSelectedDriveName);
		
		while(bFileFound)
		{
			bFileFound=File.FindNextFile( );

			CString strFileName=File.GetFileName( );
			CString strFileLocation=File.GetFilePath( );
			CString strFileType="File";
			CString strFileSize;
			
			strFileSize.Format("%d",File.GetLength( ));

			if(File.IsDirectory( ))
				strFileType="Folder";

			if(!File.IsDots( ) && !File.IsHidden( ) && !File.IsSystem( ))
			{
				m_ctlList.InsertItem(m_nIndex,strFileName);
				m_ctlList.SetItemText(m_nIndex,1,strFileLocation);
				m_ctlList.SetItemText(m_nIndex,2,strFileType);
				m_ctlList.SetItemText(m_nIndex,3,strFileSize);

				m_nIndex++;
			}
		}
*/
	}
}

BOOL CFilePage::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	if(pMsg->message==WM_KEYDOWN)
	{
		if(pMsg->wParam==13)
		{
			OnBtnSearch( );

			return true;
		}
	}
	
	return CPropertyPage::PreTranslateMessage(pMsg);
}


void CFilePage::SearchFile(CString strPath, CString strFile_Name)
{
	CString strFile=strPath+"\\"+strFile_Name;

	CFileFind File;

	BOOL bFileFound=File.FindFile(strFile);
	
	while(bFileFound)
	{
		bFileFound=File.FindNextFile( );

		CString strFileName=File.GetFileName( );
		CString strFileLocation=File.GetFilePath( );
		CString strFileType="File";
		CString strFileSize;
			
		strFileSize.Format("%d",File.GetLength( ));

		if(File.IsDirectory( ))
			strFileType="Folder";

		if(!File.IsDots( ) && !File.IsHidden( ) && !File.IsSystem( ))
		{
			CString strFile=strFileLocation;

			int nLength=(strFileLocation.GetLength( )-strFileName.GetLength( ));
			
			strFileLocation.SetAt(nLength,NULL);

			m_ctlList.InsertItem(m_nIndex,strFileName,GetIconIndex(strFile));
			m_ctlList.SetItemText(m_nIndex,1,strFileLocation);
			m_ctlList.SetItemText(m_nIndex,2,strFileType);
			m_ctlList.SetItemText(m_nIndex,3,strFileSize);

			m_nIndex++;

			CString strTemp=strPath+"\\"+strFileName;

			if(File.IsDirectory( ) && !File.IsDots( ) && !File.IsHidden( ) && !File.IsSystem( ))
				SearchFile(strTemp,strFile_Name);
		}
	}
}

int CFilePage::GetIconIndex(const CString &strFileName)
{
        SHFILEINFO    sfi;

        SHGetFileInfo(
           (LPCTSTR)strFileName, 
           0,
           &sfi, 
           sizeof(SHFILEINFO), 
           SHGFI_SYSICONINDEX | SHGFI_SMALLICON );

       return sfi.iIcon;
}
