// RestoreFile.cpp : implementation file
//

#include "stdafx.h"
#include "direct.h"
#include "VCPP_20.h"
#include "RestoreFile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRestoreFile property page

IMPLEMENT_DYNCREATE(CRestoreFile, CPropertyPage)

CRestoreFile::CRestoreFile() : CPropertyPage(CRestoreFile::IDD)
{
	//{{AFX_DATA_INIT(CRestoreFile)
	//}}AFX_DATA_INIT
}

CRestoreFile::~CRestoreFile()
{
}

void CRestoreFile::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRestoreFile)
	DDX_Control(pDX, IDC_EDIT_RESTORE_FILE_PATH, m_ctlRestoreFilePath);
	DDX_Control(pDX, IDC_EDIT_RESTORE_FOLDER_PATH, m_ctlRestoreFolderPath);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRestoreFile, CPropertyPage)
	//{{AFX_MSG_MAP(CRestoreFile)
	ON_BN_CLICKED(IDC_BTN_BROWSE_RESTORE_FILE, OnBtnBrowseRestoreFile)
	ON_BN_CLICKED(IDC_BTN_BROWSE_RESTORE_FOLDER, OnBtnBrowseRestoreFolder)
	ON_BN_CLICKED(IDC_BTN_RESTORE_FILE, OnBtnRestoreFile)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRestoreFile message handlers

BOOL CRestoreFile::OnInitDialog()
{
	CPropertyPage::OnInitDialog( );

	return TRUE;
}

void CRestoreFile::OnBtnBrowseRestoreFile() 
{
	// TODO: Add your control notification handler code here
    char BASED_CODE szFilter[] = "Splits Restore Files (*.srf)|*.srf||";
 	
	CFileDialog BrowseFile(TRUE,NULL,NULL,OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,szFilter);

	if(BrowseFile.DoModal( )==IDOK)
	{
		CString strFilePath=BrowseFile.GetPathName( );
		CString strFolderPath=strFilePath;

		CFileFind File;

		BOOL bflag=File.FindFile(strFilePath);

		if(bflag==FALSE)
			return;

		int nLength=strFolderPath.GetLength( );

		nLength--;

		while(strFolderPath.GetAt(nLength)!='\\')
		{
			strFolderPath.SetAt(nLength,NULL);

			nLength--;
		}

		strFolderPath.SetAt(nLength,NULL);

		m_ctlRestoreFilePath.SetWindowText(strFilePath);
		m_ctlRestoreFolderPath.SetWindowText(strFolderPath);
	}		
}

void CRestoreFile::OnBtnBrowseRestoreFolder() 
{
	// TODO: Add your control notification handler code here
	CString strFolderPath;

	if(GetFolder(&strFolderPath,"Select the folder wher you want to place the restored file:",this->m_hWnd,NULL,NULL))
	{
		if(!strFolderPath.IsEmpty( ))
			m_ctlRestoreFolderPath.SetWindowText(strFolderPath);
	}		
}

void CRestoreFile::OnCheckDeleteSplitFiles() 
{
	// TODO: Add your control notification handler code here
	
}

void CRestoreFile::OnBtnRestoreFile() 
{
	// TODO: Add your control notification handler code here

	CString strFilePath;
	CString strFolderPath;

	m_ctlRestoreFilePath.GetWindowText(strFilePath);
	m_ctlRestoreFolderPath.GetWindowText(strFolderPath);

	if(strFilePath=="")
	{
		MessageBox("Please select the file that you want to restore.","MTS File Splitter - Error",MB_ICONINFORMATION);

		m_ctlRestoreFilePath.SetFocus( );
		
		return;		
	}

	int nLength=strFilePath.GetLength( );

	if(strFilePath.GetAt(nLength-4)!='.' || strFilePath.GetAt(nLength-3)!='s' || strFilePath.GetAt(nLength-2)!='r' || strFilePath.GetAt(nLength-1)!='f')
	{
		MessageBox("Invalid selected splits restore file.","MTS File Splitter - Error",MB_ICONINFORMATION);

		m_ctlRestoreFilePath.SetFocus( );
		
		return;		
	}

	CFileFind File;

	if(!File.FindFile(strFilePath))
	{
		MessageBox("Unable to find the selected file.","MTS File Splitter - Error",MB_ICONINFORMATION);

		m_ctlRestoreFilePath.SetFocus( );

		return;
	}

	if(strFolderPath=="")
	{
		MessageBox("Please select the folder where you want to place the restored file.","MTS File Splitter - Error",MB_ICONINFORMATION);

		m_ctlRestoreFolderPath.SetFocus( );

		return;		
	}

	mkdir(strFolderPath);

	if(File.FindFile(strFolderPath))
	{
		File.FindNextFile( );

		 if(!File.IsDirectory( ))
		 {
			MessageBox("Unable to find/create the specified folder.","MTS File Splitter - Error",MB_ICONINFORMATION);

			m_ctlRestoreFolderPath.SetFocus( );		 

			return;
		 }
	}

	// Restoring the file

	CFile srFile;

	if(!srFile.Open(strFilePath,CFile::modeRead))
	{
	   MessageBox("Unable to open the splits restore file for restoring.","MTS File Splitter - Error",MB_ICONINFORMATION);

	   return;
	}

	CArchive SplitsRestoreFile(&srFile,CArchive::load);

	CString strRestoreFile;

	int nSplitFilesCount=0;

	SplitsRestoreFile>>strRestoreFile;
	SplitsRestoreFile>>nSplitFilesCount;
	
	SplitsRestoreFile.Close( );
	srFile.Close( );

	CFile iFile;
	CFile oFile;

	CString strFileName=strFolderPath+"\\"+strRestoreFile;

	if(File.FindFile(strFileName))
	{
		if(MessageBox("A file with the original name of split files already exists. Do you want to replace it.","MTS File Splitter - Warning",MB_YESNO|MB_ICONQUESTION)==IDNO)
		{
			m_ctlRestoreFolderPath.SetFocus( );

			return;
		}
	}

	if(!oFile.Open(strFileName,CFile::modeCreate|CFile::modeWrite|CFile::typeBinary))
	{
		MessageBox("Unable to create the restore file","MTS File Splitter - Error",MB_ICONINFORMATION);

		m_ctlRestoreFilePath.SetFocus( );
		
		return;
	}

	oFile.Seek(0,CFile::begin);

    CString strSplitFileName;
	
	for(int i=1;i<=nSplitFilesCount;i++)
	{
		char aPartNo[15]={NULL};;

		itoa(i,aPartNo,10);

		strSplitFileName.Empty( );
		strSplitFileName=strFilePath;
		strSplitFileName.Delete((strSplitFileName.GetLength( )-4),4);
		strSplitFileName+=".p0";
		strSplitFileName+=aPartNo;

		if(!iFile.Open(strSplitFileName,CFile::modeRead|CFile::typeBinary))
		{
		   MessageBox("Unable to open a split file for restoring the original file.","MTS File Splitter - Error",MB_ICONINFORMATION);

		   return;
		}

		iFile.Seek(0,CFile::begin);

		char aData[1024]={NULL};

		UINT nBytesRead=0;

		do
		{
			nBytesRead=iFile.Read(aData,1024);

			oFile.Write(aData,nBytesRead);

			if(nBytesRead!=1024)
				break;
		}
		while(1);

		iFile.Close( );
	}

	oFile.Close( );

	MessageBox("The selected file has been sucessfully restored.","MTS File Splitter",MB_ICONINFORMATION);		
}

BOOL CRestoreFile::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	if(pMsg->message==WM_KEYDOWN)
	{
		if(pMsg->wParam==13)
		{
			OnBtnRestoreFile( );

			return true;
		}
		
		else if(pMsg->wParam==27)
			return true;
	}
	
	return CPropertyPage::PreTranslateMessage(pMsg);
}
