// SplitFile.cpp : implementation file
//

#include "stdafx.h"
#include "direct.h"
#include "VCPP_20.h"
#include "SplitFile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSplitFile property page

IMPLEMENT_DYNCREATE(CSplitFile, CPropertyPage)

CSplitFile::CSplitFile() : CPropertyPage(CSplitFile::IDD)
{
	//{{AFX_DATA_INIT(CSplitFile)
	//}}AFX_DATA_INIT
}

CSplitFile::~CSplitFile()
{
}

void CSplitFile::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSplitFile)
	DDX_Control(pDX, IDC_COMBO_SPLIT_FILE_SIZE, m_ctlSplitFileSize);
	DDX_Control(pDX, IDC_STATIC_SPLIT_FILES_CREATED, m_ctlSplitFilesCreated);
	DDX_Control(pDX, IDC_STATIC_FILE_SIZE, m_ctlFileSize);
	DDX_Control(pDX, IDC_EDIT_SPLIT_FOLDER_PATH, m_ctlSplitFolderPath);
	DDX_Control(pDX, IDC_EDIT_SPLIT_FILE_PATH, m_ctlSplitFilePath);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSplitFile, CPropertyPage)
	//{{AFX_MSG_MAP(CSplitFile)
	ON_BN_CLICKED(IDC_BTN_BROWSE_SPLIT_FILE, OnBtnBrowseSplitFile)
	ON_BN_CLICKED(IDC_BTN_BROWSE_SPLIT_FOLDER, OnBtnBrowseSplitFolder)
	ON_BN_CLICKED(IDC_BTN_SPLIT_FILE, OnBtnSplitFile)
	ON_EN_UPDATE(IDC_EDIT_SPLIT_FILE_PATH, OnUpdateEditSplitFilePath)
	ON_CBN_EDITUPDATE(IDC_COMBO_SPLIT_FILE_SIZE, OnEditupdateComboSplitFileSize)
	ON_CBN_SELCHANGE(IDC_COMBO_SPLIT_FILE_SIZE, OnSelchangeComboSplitFileSize)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSplitFile message handlers

BOOL CSplitFile::OnInitDialog( )
{
	CPropertyPage::OnInitDialog( );

	m_ctlSplitFileSize.SetWindowText("1024");

	return TRUE;
}

void CSplitFile::ShowFileInfo( )
{
	CString strFilePath;

	m_ctlSplitFilePath.GetWindowText(strFilePath);

	if(strFilePath=="")
		return;		

	CFile File;

	if(!File.Open(strFilePath,CFile::modeRead))
	{
		m_ctlFileSize.SetWindowText("-----");
		m_ctlSplitFilesCreated.SetWindowText("-----");

		return;
	}

	else
	{
		m_nFileSize=(File.GetLength( )/1024);

		if((File.GetLength( )%1024)!=0)
			m_nFileSize++;

		char aFileSize[25]={NULL};

		ultoa(m_nFileSize,aFileSize,10);

		strcat(aFileSize,"  KB");

		m_ctlFileSize.SetWindowText(aFileSize);

	    File.Close( );
	}

	CString strSplitFileSize;

	m_ctlSplitFileSize.GetWindowText(strSplitFileSize);

	if(strSplitFileSize=="")
	{
		m_nSplitFileSize=0;
		m_nSplitFilesCount=0;
		m_ctlSplitFilesCreated.SetWindowText("-----");		
	}
	
	else
	{
		char *Ptr=NULL;

		m_nSplitFileSize=strtoul(strSplitFileSize,&Ptr,10);

		if(m_nSplitFileSize<=0)
		{
			m_ctlSplitFilesCreated.SetWindowText("-----");

			return;
		}

		m_nSplitFilesCount=(m_nFileSize/m_nSplitFileSize);

		if((m_nFileSize%m_nSplitFileSize)!=0)
			m_nSplitFilesCount++;		

		char aSplitFilesCount[15]={NULL};

		ultoa(m_nSplitFilesCount,aSplitFilesCount,10);
		strcat(aSplitFilesCount,"  (+ 1)");

		m_ctlSplitFilesCreated.SetWindowText(aSplitFilesCount);
	}
}

void CSplitFile::OnBtnBrowseSplitFile() 
{
	// TODO: Add your control notification handler code here
    char BASED_CODE szFilter[] = "All Files (*.*)|*.*||";
 	
	CFileDialog BrowseFile(TRUE,NULL,NULL,OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,szFilter);

	if(BrowseFile.DoModal( )==IDOK)
	{
		CString strFilePath=BrowseFile.GetPathName( );
		CString strFolderPath=strFilePath;
		CString strFileSize;

		CFileFind File;

		BOOL bflag=File.FindFile(strFilePath);

		if(bflag==FALSE)
			return;

		int nLength=strFolderPath.GetLength( );

		nLength--;

		while(strFolderPath.GetAt(nLength)!='\\')
		{
			strFolderPath.SetAt(nLength,NULL);

			nLength--;
		}

		strFolderPath.SetAt(nLength,NULL);

		m_ctlSplitFilePath.SetWindowText(strFilePath);
		m_ctlSplitFolderPath.SetWindowText(strFolderPath);
	}	
}

void CSplitFile::OnBtnBrowseSplitFolder() 
{
	// TODO: Add your control notification handler code here
	CString strFolderPath;

	if(GetFolder(&strFolderPath,"Select the folder wher you want to place the split files:",this->m_hWnd,NULL,NULL))
	{
		if(!strFolderPath.IsEmpty( ))
			m_ctlSplitFolderPath.SetWindowText(strFolderPath);
	}	
}

void CSplitFile::OnBtnSplitFile() 
{
	// TODO: Add your control notification handler code here
	CString strFilePath;
	CString strFolderPath;
	CString strSplitFileSize;

	m_ctlSplitFilePath.GetWindowText(strFilePath);

	if(strFilePath=="")
	{
		MessageBox("Please select the file that you want to split.","MTS File Splitter - Error",MB_ICONINFORMATION);

		m_ctlSplitFilePath.SetFocus( );
		
		return;		
	}

	CFileFind File;

	if(!File.FindFile(strFilePath))
	{
		MessageBox("Unable to find the selected file.","MTS File Splitter - Error",MB_ICONINFORMATION);

		m_ctlSplitFilePath.SetFocus( );

		return;
	}

	m_ctlSplitFolderPath.GetWindowText(strFolderPath);

	mkdir(strFolderPath);

	if(strFolderPath=="")
	{
		MessageBox("Please select the folder where you want to place the splitted files.","MTS File Splitter - Error",MB_ICONINFORMATION);

		m_ctlSplitFolderPath.SetFocus( );

		return;		
	}
	
	if(m_nSplitFileSize==0)
	{
		MessageBox("Please write a valid Split size.","MTS File Splitter - Error",MB_ICONINFORMATION);

		m_ctlSplitFileSize.SetFocus( );
		
		return;		
	}

	if(m_nSplitFileSize<1 || m_nSplitFileSize>1048576)
	{
		MessageBox("Split size must be between 1 - 1048576 KB.","MTS File Splitter - Error",MB_ICONINFORMATION);

		m_ctlSplitFileSize.SetFocus( );
		
		return;		
	}
	
	CFile iFile;
	CFile oFile;

	if(!iFile.Open(strFilePath,CFile::modeRead|CFile::typeBinary))
	{
		MessageBox("Unable to Open the selected file","MTS File Splitter - Error",MB_ICONINFORMATION);

		m_ctlSplitFilePath.SetFocus( );
		
		return;
	}

	iFile.Seek(0,CFile::begin);

	if(m_nFileSize<=m_nSplitFileSize)
	{
		MessageBox("No Need to split the selected file.","MTS File Splitter - Error",MB_ICONINFORMATION);

		m_ctlSplitFileSize.SetFocus( );

		return;
	}

	// Splitting the File

    int nPartNo=1;

    CString strSplitFileName;
    CString strFileName;

	strFileName=iFile.GetFileName( );

	do
	{
		char aPartNo[15]={NULL};;

		itoa(nPartNo,aPartNo,10);

		strSplitFileName.Empty( );
		strSplitFileName=(strFolderPath+"\\"+strFileName+".p0"+aPartNo);

		if(!oFile.Open(strSplitFileName,CFile::modeWrite|CFile::modeCreate|CFile::typeBinary))
		{
		   MessageBox("Unable to create a split file.","MTS File Splitter - Error",MB_ICONINFORMATION);

		   return;
		}

		oFile.Seek(0,CFile::begin);

		unsigned int count=1;

		char aData[1024]={NULL};

		UINT nBytesRead=0;

		do
		{
			nBytesRead=iFile.Read(aData,1024);

			oFile.Write(aData,nBytesRead);

			if(nBytesRead!=1024 || count==m_nSplitFileSize)
				break;

			count++;
		}
		while(1);

	    nPartNo++;

		oFile.Close( );

        if(nBytesRead!=1024)
			break;
	}
    while(1);

	iFile.Close( );


    // Making Batch File for Restoring

	CString strBatchFile;

    strBatchFile=(strFolderPath+"\\"+strFileName+".bat");

	if(!oFile.Open(strBatchFile,CFile::modeCreate|CFile::modeWrite))
	{
	   MessageBox("Unable to create the batch file for restoring.","MTS File Splitter - Error",MB_ICONINFORMATION);

	   return;
	}

	CArchive BatchFile(&oFile,CArchive::store);

	BatchFile.WriteString("@echo off \n");
	BatchFile.WriteString("echo MTS File Splitter v1.0 \n");
	BatchFile.WriteString("echo Restore Batch File \n");
	BatchFile.WriteString("echo Copyright (c) 2000-03 \n");
	BatchFile.WriteString("echo Muhammad Tahir Shahzad \n");
	BatchFile.WriteString("echo Please ensure all split files are in the same current folder \n");
	BatchFile.WriteString("Copy /b ");

	CString strSplitFile;

	for(int i=1;i<nPartNo;i++)
	{
		strSplitFile.Empty( );
		strSplitFile=(strFileName+".p0");

		char aPartNo[15]={NULL};

	    itoa(i,aPartNo,10);

		strSplitFile+=aPartNo;;

		BatchFile.WriteString(strSplitFile);

		if(i<(nPartNo-1))
			BatchFile.WriteString(" + ");
	 }

	BatchFile.WriteString(" ");
	BatchFile.WriteString(strFileName);

	BatchFile.Close( );
	oFile.Close( );

    // Making Splits Restore File for Restoring

	CString strSplitsRestoreFile;

    strSplitsRestoreFile=(strFolderPath+"\\"+strFileName+".srf");

	if(!oFile.Open(strSplitsRestoreFile,CFile::modeCreate|CFile::modeWrite))
	{
	   MessageBox("Unable to create the splits restore file for restoring.","MTS File Splitter - Error",MB_ICONINFORMATION);

	   return;
	}

	CArchive SplitsRestoreFile(&oFile,CArchive::store);

	SplitsRestoreFile<<strFileName;
	SplitsRestoreFile<<m_nSplitFilesCount;
	
	SplitsRestoreFile.Close( );
	oFile.Close( );

/*
    // Making Help File for restoring

	CString strHelpFile;

    strHelpFile=(strFolderPath+"\\"+strFileName+".txt");

	if(!oFile.Open(strHelpFile,CFile::modeCreate|CFile::modeWrite))
	{
	   MessageBox("Unable to create the help file for restoring.","MTS File Splitter - Error",MB_ICONINFORMATION);

	   return;
	}

	CArchive HelpFile(&oFile,CArchive::store);

	HelpFile.WriteString("MTS File Splitter v1.0 \n");
	HelpFile.WriteString("\n");
	HelpFile.WriteString("Restore Help File \n");
	HelpFile.WriteString("Copyright (c) 2000-03 \n");
	HelpFile.WriteString("Muhammad Tahir Shahzad \n");
	HelpFile.WriteString("Please ensure all split files are in the same current folder \n");
	HelpFile.WriteString("Run the batch file to restore your original file.");

	HelpFile.Close( );
	oFile.Close( );
*/
	MessageBox("The selected file has been sucessfully splitted.","MTS File Splitter",MB_ICONINFORMATION);	
}

BOOL CSplitFile::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	if(pMsg->message==WM_KEYDOWN)
	{
		if(pMsg->wParam==13)
		{
			OnBtnSplitFile( );

			return true;
		}
		
		else if(pMsg->wParam==27)
			return true;
	}
	
	return CPropertyPage::PreTranslateMessage(pMsg);	
}

void CSplitFile::OnUpdateEditSplitFilePath() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CPropertyPage::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_UPDATE flag ORed into the lParam mask.
	
	// TODO: Add your control notification handler code here
	ShowFileInfo( );	
}

void CSplitFile::OnEditupdateComboSplitFileSize() 
{
	// TODO: Add your control notification handler code here
	ShowFileInfo( );		
}

void CSplitFile::OnSelchangeComboSplitFileSize() 
{
	// TODO: Add your control notification handler code here
	int nCurrentSelection=m_ctlSplitFileSize.GetCurSel( );	

	CString strCurrentSelection;

	m_ctlSplitFileSize.GetLBText(nCurrentSelection,strCurrentSelection);
	m_ctlSplitFileSize.SetWindowText(strCurrentSelection);

	ShowFileInfo( );
}
