// VCPP_20.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "VCPP_20.h"
#include "SplitFile.h"
#include "RestoreFile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVCPP_20App

BEGIN_MESSAGE_MAP(CVCPP_20App, CWinApp)
	//{{AFX_MSG_MAP(CVCPP_20App)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVCPP_20App construction

CVCPP_20App::CVCPP_20App()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CVCPP_20App object

CVCPP_20App theApp;

/////////////////////////////////////////////////////////////////////////////
// CVCPP_20App initialization

BOOL CVCPP_20App::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	CPropertySheet Splitter("MTS File Splitter v1.0");

	Splitter.m_psh.dwFlags|=PSH_NOAPPLYNOW;

	CSplitFile SplitFile;
	CRestoreFile RestoreFile;

	Splitter.AddPage(&SplitFile);
	Splitter.AddPage(&RestoreFile);

	m_pMainWnd = &Splitter;

	int nResponse = Splitter.DoModal( );

	if (nResponse == IDOK)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with OK
	}
	else if (nResponse == IDCANCEL)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with Cancel
	}

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}

CString strTmpPath;

int CALLBACK BrowseCallbackProc(HWND hwnd,UINT uMsg,LPARAM lparam,LPARAM lpData)
{
	TCHAR szDir[MAX_PATH];

	switch(uMsg)
	{
	case BFFM_INITIALIZED:	if(lpData)
							{
								strcpy(szDir,strTmpPath.GetBuffer(strTmpPath.GetLength( )));

								SendMessage(hwnd,BFFM_SETSELECTION,TRUE,(LPARAM)szDir);
							}
		break;

	case BFFM_SELCHANGED:	if(SHGetPathFromIDList((LPITEMIDLIST)lparam,szDir))
							SendMessage(hwnd,BFFM_SETSTATUSTEXT,0,(LPARAM)szDir);
							
		break;
	}

	return 0;
}

BOOL GetFolder(CString* strSelectedFolder,const char* lpszTitle,const HWND hwndOwner,const char* strRootFolder,const char* strStartFolder)
{
	char pszDisplayName[MAX_PATH];
	LPITEMIDLIST lpID;
	BROWSEINFOA bi;

	bi.hwndOwner=hwndOwner;

	if(strRootFolder==NULL)
		bi.pidlRoot=NULL;

	else
	{
		LPITEMIDLIST pIdl=NULL;
		IShellFolder* pDesktopFolder;
		char szPath[MAX_PATH];
		OLECHAR olePath[MAX_PATH];
		ULONG chEaten;
		ULONG dwAttributes;

		strcpy(szPath,(LPCTSTR)strRootFolder);

		if(SUCCEEDED(SHGetDesktopFolder(&pDesktopFolder)))
		{
			MultiByteToWideChar(CP_ACP,MB_PRECOMPOSED,szPath,-1,olePath,MAX_PATH);
			pDesktopFolder->ParseDisplayName(NULL,NULL,olePath,&chEaten,&pIdl,&dwAttributes);
			pDesktopFolder->Release( );
		}

		bi.pidlRoot=pIdl;
	}

	bi.pszDisplayName=pszDisplayName;
	bi.lpszTitle=lpszTitle;
	bi.ulFlags=BIF_RETURNONLYFSDIRS|BIF_STATUSTEXT;
	bi.lpfn=BrowseCallbackProc;

	if(strStartFolder==NULL)
		bi.lParam=FALSE;

	else
	{
		strTmpPath.Format("%s",strStartFolder);
		bi.lParam=TRUE;
	}

	bi.iImage=NULL;
	lpID=SHBrowseForFolderA(&bi);

	if(lpID!=NULL)
	{
		BOOL b=SHGetPathFromIDList(lpID,pszDisplayName);

		if(b==TRUE)
		{
			strSelectedFolder->Format("%s",pszDisplayName);

			return TRUE;
		}

		else
			strSelectedFolder->Empty( );
	}

	return FALSE;
}
