// VCPP_24Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "VCPP_24.h"
#include "VCPP_24Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVCPP_24Dlg dialog

CVCPP_24Dlg::CVCPP_24Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVCPP_24Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVCPP_24Dlg)
	m_strProductDescription = _T("");
	m_strProductName = _T("");
	m_strProductType = _T("");
	m_nProductId = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CVCPP_24Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVCPP_24Dlg)
	DDX_Text(pDX, IDC_EDIT_PRODUCT_DESCRIPTION, m_strProductDescription);
	DDX_Text(pDX, IDC_EDIT_PRODUCT_NAME, m_strProductName);
	DDX_Text(pDX, IDC_EDIT_PRODUCT_TYPE, m_strProductType);
	DDX_Text(pDX, IDC_EDIT_PRODUCT_ID, m_nProductId);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVCPP_24Dlg, CDialog)
	//{{AFX_MSG_MAP(CVCPP_24Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTN_EXIT, OnBtnExit)
	ON_BN_CLICKED(IDC_BTN_FIRST, OnBtnFirst)
	ON_BN_CLICKED(IDC_BTN_BACK, OnBtnBack)
	ON_BN_CLICKED(IDC_BTN_NEXT, OnBtnNext)
	ON_BN_CLICKED(IDC_BTN_LAST, OnBtnLast)
	ON_BN_CLICKED(IDC_BTN_CLEAR, OnBtnClear)
	ON_BN_CLICKED(IDC_BTN_INSERT, OnBtnInsert)
	ON_BN_CLICKED(IDC_BTN_DELETE, OnBtnDelete)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVCPP_24Dlg message handlers

BOOL CVCPP_24Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_dbDatabase.OpenEx("DSN=ProductInfo");
	m_rsRecord.m_pDatabase=&m_dbDatabase;
	m_rsRecord.Open(CRecordset::snapshot,"Select * from Product");

	ShowRecord( );
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CVCPP_24Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CVCPP_24Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CVCPP_24Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CVCPP_24Dlg::ShowRecord( )
{
	try
	{
		CDBVariant vProductId;
		
		m_rsRecord.GetFieldValue((short)0,vProductId);
		m_nProductId=vProductId.m_iVal;

		m_rsRecord.GetFieldValue((short)1,m_strProductType);
		m_rsRecord.GetFieldValue((short)2,m_strProductName);
		m_rsRecord.GetFieldValue((short)3,m_strProductDescription);

		UpdateData(false);
	}

	catch(CDBException *Exp)
	{
		Exp->ReportError( );
	}
}

void CVCPP_24Dlg::OnBtnFirst() 
{
	// TODO: Add your control notification handler code here
	m_rsRecord.MoveFirst( );
	ShowRecord( );
}

void CVCPP_24Dlg::OnBtnBack() 
{
	// TODO: Add your control notification handler code here
	m_rsRecord.MovePrev( );
	ShowRecord( );	
}

void CVCPP_24Dlg::OnBtnNext() 
{
	// TODO: Add your control notification handler code here
	m_rsRecord.MoveNext( );
	ShowRecord( );	
}

void CVCPP_24Dlg::OnBtnLast() 
{
	// TODO: Add your control notification handler code here
	m_rsRecord.MoveLast( );
	ShowRecord( );	
}

void CVCPP_24Dlg::OnBtnClear() 
{
	// TODO: Add your control notification handler code here
	m_nProductId=0;
	m_strProductType="";
	m_strProductName="";
	m_strProductDescription="";

	UpdateData(false);
}

void CVCPP_24Dlg::OnBtnInsert() 
{
	// TODO: Add your control notification handler code here
	UpdateData( );

	CString strQuery;

	strQuery.Format("Insert into Product values(%d,'%s','%s','%s')",m_nProductId,m_strProductType,m_strProductName,m_strProductDescription);

	m_dbDatabase.BeginTrans( );
	m_dbDatabase.ExecuteSQL(strQuery);
	m_dbDatabase.CommitTrans( );

	m_rsRecord.Requery( );
	
	OnBtnClear( );
	OnBtnFirst( );
}

void CVCPP_24Dlg::OnBtnDelete() 
{
	// TODO: Add your control notification handler code here
	UpdateData( );

	CString strQuery;

	strQuery.Format("Delete from Product where ProductId=%d",m_nProductId);

	m_dbDatabase.BeginTrans( );
	m_dbDatabase.ExecuteSQL(strQuery);
	m_dbDatabase.CommitTrans( );

	m_rsRecord.Requery( );
	
	OnBtnClear( );
	OnBtnLast( );	
}

void CVCPP_24Dlg::OnBtnExit() 
{
	// TODO: Add your control notification handler code here
	SendMessage(WM_CLOSE);	
}

BOOL CVCPP_24Dlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	if(pMsg->message==WM_KEYDOWN)
	{
		if(pMsg->wParam==13 || pMsg->wParam==27)
			return true;
	}
	
	return CDialog::PreTranslateMessage(pMsg);
}
