// VCPP_25Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "VCPP_25.h"
#include "VCPP_25Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVCPP_25Dlg dialog

CVCPP_25Dlg::CVCPP_25Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVCPP_25Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVCPP_25Dlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CVCPP_25Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVCPP_25Dlg)
	DDX_Control(pDX, IDC_LIST_PRODUCT, m_ctlList);
	DDX_Control(pDX, IDC_COMBO_FILTER, m_ctlFilter);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVCPP_25Dlg, CDialog)
	//{{AFX_MSG_MAP(CVCPP_25Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_CBN_SELCHANGE(IDC_COMBO_FILTER, OnSelchangeComboFilter)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVCPP_25Dlg message handlers

BOOL CVCPP_25Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_ctlFilter.SetCurSel(0);

	m_ctlList.InsertColumn(0,"Product ID",LVCFMT_LEFT,70);
	m_ctlList.InsertColumn(1,"Product Type",LVCFMT_LEFT,100);
	m_ctlList.InsertColumn(2,"Product Name",LVCFMT_LEFT,100);
	m_ctlList.InsertColumn(3,"Product Description",LVCFMT_LEFT,185);

	m_dbDatabase.OpenEx("DSN=ProductInfo");
	m_rsRecord.m_pDatabase=&m_dbDatabase;
	m_rsRecord.Open(CRecordset::snapshot,"Select Count(*) from Product");

	try
	{
		CDBVariant vRecordsCount;
		
		m_rsRecord.GetFieldValue((short)0,vRecordsCount);
		
		m_nRecordsCount=vRecordsCount.m_iVal;
	}

	catch(CDBException *Exp)
	{
		Exp->ReportError( );
	}

	m_rsRecord.Close( );
	m_rsRecord.Open(CRecordset::snapshot,"Select * from Product");
	
	int nIndex=0;

	for(int i=0;i<m_nRecordsCount;i++)
	{
		try
		{
			CDBVariant vProductId;

			CString strProductType;
			CString strProductName;
			CString strProductDescription;
		
			m_rsRecord.GetFieldValue((short)0,vProductId);
			m_rsRecord.GetFieldValue((short)1,strProductType);
			m_rsRecord.GetFieldValue((short)2,strProductName);
			m_rsRecord.GetFieldValue((short)3,strProductDescription);

			if(m_ctlFilter.FindStringExact(0,strProductType)==-1)
				m_ctlFilter.AddString(strProductType);

			CString strProductId;

			strProductId.Format("%d",vProductId.m_iVal);

			m_ctlList.InsertItem(nIndex,strProductId);
			m_ctlList.SetItemText(nIndex,1,strProductType);
			m_ctlList.SetItemText(nIndex,2,strProductName);
			m_ctlList.SetItemText(nIndex,3,strProductDescription);
			
			m_rsRecord.MoveNext( );
			nIndex++;
		}

		catch(CDBException *Exp)
		{
			Exp->ReportError( );
		}
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CVCPP_25Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CVCPP_25Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CVCPP_25Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CVCPP_25Dlg::OnSelchangeComboFilter() 
{
	// TODO: Add your control notification handler code here
	m_ctlList.DeleteAllItems( );
	
	int nIndex=0;

	CString strFilter;
	
	m_ctlFilter.GetLBText(m_ctlFilter.GetCurSel( ),strFilter);

	m_rsRecord.MoveFirst( );

	for(int i=0;i<m_nRecordsCount;i++)
	{
		try
		{
			CDBVariant vProductId;

			CString strProductType;
			CString strProductName;
			CString strProductDescription;
		
			m_rsRecord.GetFieldValue((short)0,vProductId);
			m_rsRecord.GetFieldValue((short)1,strProductType);
			m_rsRecord.GetFieldValue((short)2,strProductName);
			m_rsRecord.GetFieldValue((short)3,strProductDescription);

			if(strProductType==strFilter || strFilter=="----------")
			{
				CString strProductId;

				strProductId.Format("%d",vProductId.m_iVal);

				m_ctlList.InsertItem(nIndex,strProductId);
				m_ctlList.SetItemText(nIndex,1,strProductType);
				m_ctlList.SetItemText(nIndex,2,strProductName);
				m_ctlList.SetItemText(nIndex,3,strProductDescription);

				nIndex++;			
			}
		
			m_rsRecord.MoveNext( );
		}

		catch(CDBException *Exp)
		{
			Exp->ReportError( );
		}
	}
}
