// VCPP_26Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "VCPP_26.h"
#include "VCPP_26Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVCPP_26Dlg dialog

CVCPP_26Dlg::CVCPP_26Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVCPP_26Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVCPP_26Dlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CVCPP_26Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVCPP_26Dlg)
	DDX_Control(pDX, IDC_LIST_EXPLOEER, m_ctlExplorer);
	DDX_Control(pDX, IDC_TREE_BROWSER, m_ctlBrowser);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVCPP_26Dlg, CDialog)
	//{{AFX_MSG_MAP(CVCPP_26Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_NOTIFY(TVN_SELCHANGED, IDC_TREE_BROWSER, OnSelchangedTreeBrowser)
	ON_COMMAND(IDR_FILE_EXIT, OnFileExit)
	ON_COMMAND(IDR_HELP_ABOUT, OnHelpAbout)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVCPP_26Dlg message handlers

BOOL CVCPP_26Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	m_imgBrowser.Create(16,16,ILC_COLOR8,0,100);
	m_imgBrowser.SetBkColor(RGB(255,255,255));

	HICON hIcon;

	for(int i=0;i<100;i++)
	{
		hIcon=ExtractIcon(AfxGetInstanceHandle( ),"shell32.dll",i);

		m_imgBrowser.Add(hIcon);
	}

	m_ctlBrowser.SetImageList(&m_imgBrowser,LVSIL_NORMAL);

	HTREEITEM hRoot=m_ctlBrowser.InsertItem("My Computer",94,94);

	int nIcon=0;
	int nIndex=0;
	int nDrivesIndex=0;

	char aDrives[128]={NULL};

	GetLogicalDriveStrings(128,aDrives);

	while(aDrives[nIndex]!=NULL)
		{
			CString strDriveName(aDrives[nIndex]);
			CString strDrivePath(aDrives[nIndex]);

			strDrivePath+=":\\";
			strDriveName+=":";
		
			CString strDrive;

			if(GetDriveType(strDriveName)==DRIVE_REMOVABLE)
				nIcon=6;

			else if(GetDriveType(strDriveName)==DRIVE_CDROM)
				nIcon=11;

			else if(GetDriveType(strDriveName)==DRIVE_FIXED)
				nIcon=8;

			else if(GetDriveType(strDriveName)==DRIVE_REMOTE)
				nIcon=9;

			HTREEITEM hDriveRoot=m_ctlBrowser.InsertItem(strDrivePath,nIcon,nIcon,hRoot);

			AddChildItems(strDrivePath,hDriveRoot);

			nDrivesIndex++;
			nIndex+=4;
	}

	m_ctlBrowser.Expand(hRoot,TVE_EXPAND);

	HIMAGELIST hSystemImageList; 

	SHFILEINFO sfi; 

	hSystemImageList=(HIMAGELIST)SHGetFileInfo((LPCTSTR)_T("C:\\"),0,&sfi,sizeof(SHFILEINFO),SHGFI_SYSICONINDEX | SHGFI_ICON); 

	m_imgExplorer.Attach(hSystemImageList);
	m_ctlExplorer.SetImageList(&m_imgExplorer,LVSIL_NORMAL);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CVCPP_26Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CVCPP_26Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CVCPP_26Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CVCPP_26Dlg::AddChildItems(CString strParentPath, HTREEITEM hRoot)
{
	CString strPath=strParentPath;
	CString strChildPath=strParentPath;

	strParentPath+="*.*";

	CFileFind File;

	BOOL bFound=File.FindFile(strParentPath);

	HTREEITEM hChildRoot;

	while(bFound)
	{
		bFound=File.FindNextFile( );

		if(File.IsDirectory( ) && !File.IsDots( ) && !File.IsHidden( ) && !File.IsSystem( ))
		{
			char strFileName[260];

			strcpy(strFileName,File.GetFileName( ));

			hChildRoot=m_ctlBrowser.InsertItem(strFileName,3,4,hRoot);
			strChildPath=(strPath+strFileName+"\\");

			AddChildItems(strChildPath,hChildRoot);
		}
	}
}

CVCPP_26Dlg::~CVCPP_26Dlg( )
{
	m_imgExplorer.Detach( );
	m_imgBrowser.Detach( );
}

void CVCPP_26Dlg::OnSelchangedTreeBrowser(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
	m_ctlExplorer.DeleteAllItems( );

	int nIndex=0;

	CString strPath;

 	HTREEITEM hSelectedItem=m_ctlBrowser.GetSelectedItem( );

	while(hSelectedItem!=NULL)
	{
		strPath=m_ctlBrowser.GetItemText(hSelectedItem)+"\\"+strPath;

		hSelectedItem=m_ctlBrowser.GetParentItem(hSelectedItem);
	}

	strPath.Delete(0,12);
	strPath.Delete(2);

	if(strPath.GetLength( )==0)
	{
		HTREEITEM hSelectedItem=m_ctlBrowser.GetSelectedItem( );

		if(m_ctlBrowser.ItemHasChildren(hSelectedItem))
		{
			HTREEITEM hChildItem=m_ctlBrowser.GetChildItem(hSelectedItem);

			while(hChildItem)
			{
				CString strChildItem=m_ctlBrowser.GetItemText(hChildItem);

				m_ctlExplorer.InsertItem(nIndex,strChildItem,GetFileIconIndex(strChildItem));

				nIndex++;

				hChildItem=m_ctlBrowser.GetNextItem(hChildItem,TVGN_NEXT);
			}
		}
	}

	else
	{
		strPath+="*.*";

		CFileFind File;

		BOOL bFound=File.FindFile(strPath);

		while(bFound)
		{
			bFound=File.FindNextFile( );

			if(!File.IsDots( ) && !File.IsHidden( ) && !File.IsSystem( ) && !File.IsTemporary( ))
			{
				m_ctlExplorer.InsertItem(nIndex,File.GetFileName( ),GetFileIconIndex(File.GetFilePath( )));

				nIndex++;
			}
		}
	}	

	*pResult = 0;
}

void CVCPP_26Dlg::OnFileExit() 
{
	// TODO: Add your command handler code here
	OnOK( );	
}

void CVCPP_26Dlg::OnHelpAbout() 
{
	// TODO: Add your command handler code here
	CAboutDlg dlg;

	dlg.DoModal( );
}

BOOL CVCPP_26Dlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	if(pMsg->message==WM_KEYDOWN)
	{
		if(pMsg->wParam==13 || pMsg->wParam==27)
			return TRUE;
	}
	
	return CDialog::PreTranslateMessage(pMsg);
}

int CVCPP_26Dlg::GetFileIconIndex(const CString& strFileName)
{
	SHFILEINFO sfi;

    SHGetFileInfo((LPCTSTR)strFileName,0,&sfi,sizeof(SHFILEINFO),SHGFI_SYSICONINDEX | SHGFI_SMALLICON);

	return sfi.iIcon;
}
