// VCPP_37View.cpp : implementation of the CVCPP_37View class
//

#include "stdafx.h"
#include "VCPP_37.h"

#include "VCPP_37Doc.h"
#include "VCPP_36.h"
#include "VCPP_37View.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVCPP_37View

IMPLEMENT_DYNCREATE(CVCPP_37View, CFormView)

BEGIN_MESSAGE_MAP(CVCPP_37View, CFormView)
	//{{AFX_MSG_MAP(CVCPP_37View)
	ON_BN_CLICKED(IDC_CALCULATE, OnCalculate)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CFormView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVCPP_37View construction/destruction

CVCPP_37View::CVCPP_37View()
	: CFormView(CVCPP_37View::IDD)
{
	//{{AFX_DATA_INIT(CVCPP_37View)
	m_lHScan = 50;
	m_lRefresh = 0;
	m_lHRes = 0;
	m_lVRes = 0;
	//}}AFX_DATA_INIT
	// TODO: add construction code here
	if(FAILED(CoInitialize(NULL)))
	{
		AfxMessageBox("COM Library init failed.");
		AfxAbort( );
	}

	m_pRefRateDriver=new IRefRate;
	m_pRefRateDriver->CreateDispatch(_T("VCPP_36.RefRate.1"));
}

CVCPP_37View::~CVCPP_37View()
{
	delete m_pRefRateDriver;
	CoUninitialize( );
}

void CVCPP_37View::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVCPP_37View)
	DDX_Text(pDX, IDC_HSCAN, m_lHScan);
	DDX_Text(pDX, IDC_REFRESH, m_lRefresh);
	DDX_Text(pDX, IDC_HRES, m_lHRes);
	DDX_Text(pDX, IDC_VRES, m_lVRes);
	//}}AFX_DATA_MAP
}

BOOL CVCPP_37View::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}

void CVCPP_37View::OnInitialUpdate()
{
	CFormView::OnInitialUpdate();
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();

}

/////////////////////////////////////////////////////////////////////////////
// CVCPP_37View printing

BOOL CVCPP_37View::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CVCPP_37View::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CVCPP_37View::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

void CVCPP_37View::OnPrint(CDC* pDC, CPrintInfo* /*pInfo*/)
{
	// TODO: add customized printing code here
}

/////////////////////////////////////////////////////////////////////////////
// CVCPP_37View diagnostics

#ifdef _DEBUG
void CVCPP_37View::AssertValid() const
{
	CFormView::AssertValid();
}

void CVCPP_37View::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CVCPP_37Doc* CVCPP_37View::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CVCPP_37Doc)));
	return (CVCPP_37Doc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CVCPP_37View message handlers

void CVCPP_37View::OnCalculate() 
{
	// TODO: Add your control notification handler code here
	UpdateData( );

	m_lRefresh=m_pRefRateDriver->RefreshRate(m_lHScan);
	m_lHRes=m_pRefRateDriver->GetHRes( );
	m_lVRes=m_pRefRateDriver->GetVRes( );

	UpdateData(false);
}
