// VCPP_38Ctl.cpp : Implementation of the CVCPP_38Ctrl ActiveX Control class.

#include "stdafx.h"
#include "VCPP_38.h"
#include "VCPP_38Ctl.h"
#include "VCPP_38Ppg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNCREATE(CVCPP_38Ctrl, COleControl)


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CVCPP_38Ctrl, COleControl)
	//{{AFX_MSG_MAP(CVCPP_38Ctrl)
	ON_WM_LBUTTONUP()
	//}}AFX_MSG_MAP
	ON_OLEVERB(AFX_IDS_VERB_PROPERTIES, OnProperties)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Dispatch map

BEGIN_DISPATCH_MAP(CVCPP_38Ctrl, COleControl)
	//{{AFX_DISPATCH_MAP(CVCPP_38Ctrl)
	DISP_PROPERTY_NOTIFY(CVCPP_38Ctrl, "ShowFrame", m_showFrame, OnShowFrameChanged, VT_BOOL)
	DISP_STOCKPROP_BACKCOLOR()
	//}}AFX_DISPATCH_MAP
	DISP_FUNCTION_ID(CVCPP_38Ctrl, "AboutBox", DISPID_ABOUTBOX, AboutBox, VT_EMPTY, VTS_NONE)
END_DISPATCH_MAP()


/////////////////////////////////////////////////////////////////////////////
// Event map

BEGIN_EVENT_MAP(CVCPP_38Ctrl, COleControl)
	//{{AFX_EVENT_MAP(CVCPP_38Ctrl)
	EVENT_STOCK_CLICK()
	//}}AFX_EVENT_MAP
END_EVENT_MAP()


/////////////////////////////////////////////////////////////////////////////
// Property pages

// TODO: Add more property pages as needed.  Remember to increase the count!
BEGIN_PROPPAGEIDS(CVCPP_38Ctrl, 2)
	PROPPAGEID(CVCPP_38PropPage::guid)
	PROPPAGEID(CLSID_CColorPropPage)
END_PROPPAGEIDS(CVCPP_38Ctrl)


/////////////////////////////////////////////////////////////////////////////
// Initialize class factory and guid

IMPLEMENT_OLECREATE_EX(CVCPP_38Ctrl, "VCPP38.VCPP38Ctrl.1",
	0x9f7d2de5, 0x12de, 0x4e52, 0x85, 0x7b, 0xd4, 0x9d, 0xd5, 0xa2, 0xe5, 0x25)


/////////////////////////////////////////////////////////////////////////////
// Type library ID and version

IMPLEMENT_OLETYPELIB(CVCPP_38Ctrl, _tlid, _wVerMajor, _wVerMinor)


/////////////////////////////////////////////////////////////////////////////
// Interface IDs

const IID BASED_CODE IID_DVCPP_38 =
		{ 0x1761845c, 0x8032, 0x408c, { 0x81, 0x1b, 0xb9, 0x94, 0x32, 0x93, 0x91, 0x5 } };
const IID BASED_CODE IID_DVCPP_38Events =
		{ 0x87fa0850, 0x8304, 0x4c11, { 0x8b, 0x4d, 0xdf, 0x75, 0x21, 0xa1, 0x7f, 0x3e } };


/////////////////////////////////////////////////////////////////////////////
// Control type information

static const DWORD BASED_CODE _dwVCPP_38OleMisc =
	OLEMISC_ACTIVATEWHENVISIBLE |
	OLEMISC_SETCLIENTSITEFIRST |
	OLEMISC_INSIDEOUT |
	OLEMISC_CANTLINKINSIDE |
	OLEMISC_RECOMPOSEONRESIZE;

IMPLEMENT_OLECTLTYPE(CVCPP_38Ctrl, IDS_VCPP_38, _dwVCPP_38OleMisc)


/////////////////////////////////////////////////////////////////////////////
// CVCPP_38Ctrl::CVCPP_38CtrlFactory::UpdateRegistry -
// Adds or removes system registry entries for CVCPP_38Ctrl

BOOL CVCPP_38Ctrl::CVCPP_38CtrlFactory::UpdateRegistry(BOOL bRegister)
{
	// TODO: Verify that your control follows apartment-model threading rules.
	// Refer to MFC TechNote 64 for more information.
	// If your control does not conform to the apartment-model rules, then
	// you must modify the code below, changing the 6th parameter from
	// afxRegApartmentThreading to 0.

	if (bRegister)
		return AfxOleRegisterControlClass(
			AfxGetInstanceHandle(),
			m_clsid,
			m_lpszProgID,
			IDS_VCPP_38,
			IDB_VCPP_38,
			afxRegApartmentThreading,
			_dwVCPP_38OleMisc,
			_tlid,
			_wVerMajor,
			_wVerMinor);
	else
		return AfxOleUnregisterClass(m_clsid, m_lpszProgID);
}


/////////////////////////////////////////////////////////////////////////////
// CVCPP_38Ctrl::CVCPP_38Ctrl - Constructor

CVCPP_38Ctrl::CVCPP_38Ctrl()
{
	InitializeIIDs(&IID_DVCPP_38, &IID_DVCPP_38Events);

	// TODO: Initialize your control's instance data here.
	m_BitmapNight.LoadBitmap(IDB_BITMAP1);
	m_BitmapDay.LoadBitmap(IDB_BITMAP2);
	m_CurrentBitmap=&m_BitmapNight;
}


/////////////////////////////////////////////////////////////////////////////
// CVCPP_38Ctrl::~CVCPP_38Ctrl - Destructor

CVCPP_38Ctrl::~CVCPP_38Ctrl()
{
	// TODO: Cleanup your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CVCPP_38Ctrl::OnDraw - Drawing function

void CVCPP_38Ctrl::OnDraw(
			CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid)
{
	// TODO: Replace the following code with your own drawing code.
	CBrush Brush(TranslateColor(GetBackColor()));
	pdc->FillRect(rcBounds,&Brush);
	
	BITMAP BM;
	CDC dc;

	dc.CreateCompatibleDC(NULL);
	dc.SelectObject(*m_CurrentBitmap);

	m_CurrentBitmap->GetObject(sizeof(BM),&BM);
	pdc->BitBlt((rcBounds.right-BM.bmWidth)/2,(rcBounds.bottom-BM.bmHeight)/2,BM.bmWidth,BM.bmHeight,&dc,0,0,SRCCOPY);

	if(m_showFrame)
	{
		CBrush* pOldBrush=(CBrush*)pdc->SelectStockObject(NULL_BRUSH);
		CPen Pen(PS_SOLID|PS_INSIDEFRAME,10,RGB(0,0,0));
		CPen* pOldPen=pdc->SelectObject(&Pen);

		pdc->Rectangle(rcBounds);

		pdc->SelectObject(pOldPen);
		pdc->SelectObject(pOldBrush);
	}
}


/////////////////////////////////////////////////////////////////////////////
// CVCPP_38Ctrl::DoPropExchange - Persistence support

void CVCPP_38Ctrl::DoPropExchange(CPropExchange* pPX)
{
	ExchangeVersion(pPX, MAKELONG(_wVerMinor, _wVerMajor));
	COleControl::DoPropExchange(pPX);

	// TODO: Call PX_ functions for each persistent custom property.
	PX_Bool (pPX,_T("ShowFrame"),m_showFrame,FALSE);
}


/////////////////////////////////////////////////////////////////////////////
// CVCPP_38Ctrl::OnResetState - Reset control to default state

void CVCPP_38Ctrl::OnResetState()
{
	COleControl::OnResetState();  // Resets defaults found in DoPropExchange

	// TODO: Reset any other control state here.
}


/////////////////////////////////////////////////////////////////////////////
// CVCPP_38Ctrl::AboutBox - Display an "About" box to the user

void CVCPP_38Ctrl::AboutBox()
{
	CDialog dlgAbout(IDD_ABOUTBOX_VCPP_38);
	dlgAbout.DoModal();
}


/////////////////////////////////////////////////////////////////////////////
// CVCPP_38Ctrl message handlers

void CVCPP_38Ctrl::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	if(m_CurrentBitmap==&m_BitmapNight)
		m_CurrentBitmap=&m_BitmapDay;
	else
		m_CurrentBitmap=&m_BitmapNight;

	InvalidateControl();
	
	COleControl::OnLButtonUp(nFlags, point);
}

void CVCPP_38Ctrl::OnShowFrameChanged() 
{
	// TODO: Add notification handler code
	InvalidateControl( );

	SetModifiedFlag();
}
