// VCPP_43Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "VCPP_43.h"
#include "VCPP_43Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVCPP_43Dlg dialog

CVCPP_43Dlg::CVCPP_43Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVCPP_43Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVCPP_43Dlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CVCPP_43Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVCPP_43Dlg)
	DDX_Control(pDX, IDC_LIST, m_ctlList);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVCPP_43Dlg, CDialog)
	//{{AFX_MSG_MAP(CVCPP_43Dlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVCPP_43Dlg message handlers

BOOL CVCPP_43Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	m_ctlList.InsertColumn(0,"Volume",LVCFMT_LEFT,60);
	m_ctlList.InsertColumn(1,"Bytes/Sector",LVCFMT_LEFT,85);
	m_ctlList.InsertColumn(2,"Sectors/Cluster",LVCFMT_LEFT,85);
	m_ctlList.InsertColumn(3,"Cluster Size",LVCFMT_LEFT,85);
	m_ctlList.InsertColumn(4,"Free Clusters",LVCFMT_LEFT,85);
	m_ctlList.InsertColumn(5,"Total Clusters",LVCFMT_LEFT,85);
	m_ctlList.InsertColumn(6,"Total Capacity (MB)",LVCFMT_LEFT,110);

	char aDrives[256]={NULL};

	GetLogicalDriveStrings(256,aDrives);	

    DWORD SectorsPerCluster;
	DWORD BytesPerSector;
	DWORD FreeClusters;
	DWORD TotalClusters;

	int nCount=0;
	int nIndex=0;

	char aDriveName[5]={NULL};

    aDriveName[1]=':';
    aDriveName[2]='\\';

	do
	{
		aDriveName[0]=aDrives[nCount];

		UINT DriveType=GetDriveType(aDriveName);

		if(DriveType==DRIVE_FIXED)
		{
			GetDiskFreeSpace(aDriveName,&SectorsPerCluster,&BytesPerSector,&FreeClusters,&TotalClusters);

			CString strBytesPerSector;
			CString strSectorsPerCluster;
			CString strClusterSize;
			CString strFreeClusters;
			CString strTotalClusters;
			CString strTotalCapacity;

			unsigned long double nClusterSize=(SectorsPerCluster*BytesPerSector);
			unsigned long double nCapacity=(((nClusterSize*TotalClusters)/1024)/1024);

			strBytesPerSector.Format("%d",BytesPerSector);
			strSectorsPerCluster.Format("%d",SectorsPerCluster);
			strClusterSize.Format("%d",nClusterSize);
			strFreeClusters.Format("%d",FreeClusters);
			strTotalClusters.Format("%d",TotalClusters);
			strTotalCapacity.Format("%0.0f",nCapacity);

			m_ctlList.InsertItem(nIndex,aDriveName);
			m_ctlList.SetItemText(nIndex,1,strBytesPerSector);
			m_ctlList.SetItemText(nIndex,2,strSectorsPerCluster);
			m_ctlList.SetItemText(nIndex,3,strClusterSize);
			m_ctlList.SetItemText(nIndex,4,strFreeClusters);
			m_ctlList.SetItemText(nIndex,5,strTotalClusters);
			m_ctlList.SetItemText(nIndex,6,strTotalCapacity);

			nIndex++;
		}

		nCount+=4;;
	}
	while(aDrives[nCount]!=NULL);
		
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CVCPP_43Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CVCPP_43Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}
