// VCPP_44Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "VCPP_44.h"
#include "VCPP_44Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVCPP_44Dlg dialog

CVCPP_44Dlg::CVCPP_44Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVCPP_44Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVCPP_44Dlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CVCPP_44Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVCPP_44Dlg)
	DDX_Control(pDX, IDC_LIST, m_ctlList);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVCPP_44Dlg, CDialog)
	//{{AFX_MSG_MAP(CVCPP_44Dlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVCPP_44Dlg message handlers

BOOL CVCPP_44Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	m_ctlList.InsertColumn(0,"Volume",LVCFMT_LEFT,100);
	m_ctlList.InsertColumn(1,"Total Capacity (MB)",LVCFMT_LEFT,125);

	char aDrives[256]={NULL};

	GetLogicalDriveStrings(256,aDrives);	

    DWORD SectorsPerCluster;
	DWORD BytesPerSector;
	DWORD FreeClusters;
	DWORD TotalClusters;

	int nCount=0;
	int nIndex=0;

	char aDriveName[5]={NULL};

    aDriveName[1]=':';
    aDriveName[2]='\\';

	do
	{
		aDriveName[0]=aDrives[nCount];

		UINT DriveType=GetDriveType(aDriveName);

		if(DriveType==DRIVE_CDROM)
		{
			GetDiskFreeSpace(aDriveName,&SectorsPerCluster,&BytesPerSector,&FreeClusters,&TotalClusters);

			CString strTotalCapacity;

			unsigned long double nClusterSize=(SectorsPerCluster*BytesPerSector);
			unsigned long double nCapacity=(((nClusterSize*TotalClusters)/1024)/1024);

			strTotalCapacity.Format("%0.0f",nCapacity);

			m_ctlList.InsertItem(nIndex,aDriveName);
			m_ctlList.SetItemText(nIndex,1,strTotalCapacity);

			nIndex++;
		}

		nCount+=4;;
	}
	while(aDrives[nCount]!=NULL);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CVCPP_44Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CVCPP_44Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}
