// VCPP_47Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "VCPP_47.h"
#include "VCPP_47Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVCPP_47Dlg dialog

CVCPP_47Dlg::CVCPP_47Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVCPP_47Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVCPP_47Dlg)
	m_strStaticTime = _T("");
	m_strStaticCount = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CVCPP_47Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVCPP_47Dlg)
	DDX_Control(pDX, IDC_BTN_STOP_TIMER, m_cStopTimer);
	DDX_Control(pDX, IDC_BTN_START_TIMER, m_cStartTimer);
	DDX_Text(pDX, IDC_STATIC_TIME, m_strStaticTime);
	DDX_Text(pDX, IDC_STATIC_COUNT, m_strStaticCount);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVCPP_47Dlg, CDialog)
	//{{AFX_MSG_MAP(CVCPP_47Dlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BTN_START_TIMER, OnBtnStartTimer)
	ON_BN_CLICKED(IDC_BTN_STOP_TIMER, OnBtnStopTimer)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVCPP_47Dlg message handlers

BOOL CVCPP_47Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_iInterval=100;

	SetDlgItemText(IDC_EDIT_INTERVAL,"100");

	SetTimer(ID_CLOCK_TIMER, 1000, NULL);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CVCPP_47Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CVCPP_47Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CVCPP_47Dlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	CTime curTime = CTime::GetCurrentTime();

	int nHours=curTime.GetHour();
	int nMinutes=curTime.GetMinute();
	int nSeconds=curTime.GetSecond();

	switch(nIDEvent)
	{
		case ID_CLOCK_TIMER : m_strStaticTime.Format("%d:%d:%d",nHours,nMinutes,nSeconds);
			break;

		case ID_COUNT_TIMER : m_iCount++;
					          m_strStaticCount.Format("%d", m_iCount);
			break;
	}

	UpdateData(FALSE);
	
	CDialog::OnTimer(nIDEvent);
}

void CVCPP_47Dlg::OnBtnStartTimer() 
{
	// TODO: Add your control notification handler code here
	m_iCount = 0;

	m_strStaticCount.Format("%d", m_iCount);

	UpdateData(FALSE);

	m_iInterval=GetDlgItemInt(IDC_EDIT_INTERVAL);

	if(m_iInterval<=0 || m_iInterval>100000)
		MessageBox("The value of the Timer Interval can only be b/w 1 and 100000.","Fatal Error",MB_ICONINFORMATION);

	else
	{
		SetTimer(ID_COUNT_TIMER, m_iInterval, NULL);

		m_cStopTimer.EnableWindow(TRUE);
	    m_cStartTimer.EnableWindow(FALSE);
	}
}

void CVCPP_47Dlg::OnBtnStopTimer() 
{
	// TODO: Add your control notification handler code here
	KillTimer(ID_COUNT_TIMER);	

    m_cStopTimer.EnableWindow(FALSE);
    m_cStartTimer.EnableWindow(TRUE);
}
