// VCPP_48Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "VCPP_48.h"
#include "VCPP_48Dlg.h"
#include "CustomDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVCPP_48Dlg dialog

CVCPP_48Dlg::CVCPP_48Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVCPP_48Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVCPP_48Dlg)
	m_sResult = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CVCPP_48Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVCPP_48Dlg)
	DDX_Control(pDX, IDC_BTN_WHICH_OPTION, m_cWhichOption);
	DDX_Text(pDX, IDC_EDIT_RESULT, m_sResult);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVCPP_48Dlg, CDialog)
	//{{AFX_MSG_MAP(CVCPP_48Dlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTN_OPEN, OnBtnFileOpen)
	ON_BN_CLICKED(IDC_BTN_SAVE_AS, OnBtnFileSaveAs)
	ON_BN_CLICKED(IDC_BTN_COLOR, OnBtnColor)
	ON_BN_CLICKED(IDC_BTN_FONT, OnBtnFont)
	ON_BN_CLICKED(IDC_BTN_CUSTOM_DIALOG, OnBtnCustomDialog)
	ON_BN_CLICKED(IDC_BTN_WHICH_OPTION, OnBtnWhichOption)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVCPP_48Dlg message handlers

BOOL CVCPP_48Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CVCPP_48Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CVCPP_48Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CVCPP_48Dlg::OnBtnFileOpen() 
{
	// TODO: Add your control notification handler code here
	CString sFilter;

	sFilter="All Files (*.*)|*.*|Text Documents (*.txt)|*.txt|";

	CFileDialog fdOpen(TRUE,NULL,NULL,(OFN_HIDEREADONLY|OFN_FILEMUSTEXIST),sFilter,NULL);
	
	if(fdOpen.DoModal( )==IDOK)
		m_sResult=fdOpen.GetPathName( );

	else
		m_sResult="No File is Selected.";

	UpdateData(FALSE);
}

void CVCPP_48Dlg::OnBtnFileSaveAs() 
{
	// TODO: Add your control notification handler code here
	CString sFilter;

	sFilter="All Files (*.*)|*.*|Text Documents (*.txt)|*.txt|";

	CFileDialog fdSaveAs(FALSE,"txt",NULL,(OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT),sFilter,NULL);
	
	if(fdSaveAs.DoModal( )==IDOK)
		m_sResult=fdSaveAs.GetPathName( );

	else
		m_sResult="No File is Selected.";

	UpdateData(FALSE);	
}

void CVCPP_48Dlg::OnBtnColor() 
{
	// TODO: Add your control notification handler code here
	CColorDialog cdColor;
	
	COLORREF crColor;

	if(cdColor.DoModal( )==IDOK)
	{
		crColor=cdColor.GetColor( );

		int nRed=0;
		int nGreen=0;
		int nBlue=0;

		bool bFlag=false;

		for(int r=0;r<=255;r++)
		{
			for(int g=0;g<=255;g++)
			{
				for(int b=0;b<=255;b++)
				{
					if(crColor==RGB(r,g,b))
					{
						nRed=r;
						nGreen=g;
						nBlue=b;

						bFlag=true;
	
						break;
					}
				}

				if(bFlag==true)
					break;
			}

			if(bFlag==true)
				break;
		}

		m_sResult.Format("RGB ( %d , %d , %d )",nRed,nGreen,nBlue);

	}

	else
		m_sResult="No Color is Selected.";

	UpdateData(FALSE);
}

void CVCPP_48Dlg::OnBtnFont() 
{
	// TODO: Add your control notification handler code here
	CFontDialog fdFont;

	if(fdFont.DoModal( )==IDOK)
		m_sResult.Format("%s , %d",fdFont.GetFaceName( ),(fdFont.GetSize( )/10));	

	else
		m_sResult="No Font is Selected.";

	UpdateData(FALSE);	
}

void CVCPP_48Dlg::OnBtnCustomDialog() 
{
	// TODO: Add your control notification handler code here
	if(customDialog.DoModal( )==IDOK)
	{
		m_sResult=customDialog.m_sMessage;

		m_cWhichOption.EnableWindow( );
	}

	else
		m_sResult="No Message is entered.";

	UpdateData(FALSE);
}

void CVCPP_48Dlg::OnBtnWhichOption() 
{
	// TODO: Add your control notification handler code here
	switch(customDialog.m_iOptionNumber)
	{
		case 0 : m_sResult="Option # 1 was selected";
			break;

		case 1 : m_sResult="Option # 2 was selected";
			break;

		case 2 : m_sResult="Option # 3 was selected";
			break;
	}

	UpdateData(FALSE);

	m_cWhichOption.EnableWindow(FALSE);
}
