// VCPP_51Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "VCPP_51.h"
#include "VCPP_51Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVCPP_51Dlg dialog

CVCPP_51Dlg::CVCPP_51Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVCPP_51Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVCPP_51Dlg)
	m_strMessage = _T("");
	m_strServerName = _T("");
	m_iServerPort = 0;
	m_iServerType = -1;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CVCPP_51Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVCPP_51Dlg)
	DDX_Control(pDX, IDC_LIST_RECIEVED, m_ctlReceived);
	DDX_Control(pDX, IDC_LIST_SENT, m_ctlSent);
	DDX_Text(pDX, IDC_EDIT_MESSAGE, m_strMessage);
	DDX_Text(pDX, IDC_EDIT_SERVER_NAME, m_strServerName);
	DDX_Text(pDX, IDC_EDIT_SERVER_PORT, m_iServerPort);
	DDX_Radio(pDX, IDC_RADIO_SERVER, m_iServerType);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVCPP_51Dlg, CDialog)
	//{{AFX_MSG_MAP(CVCPP_51Dlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_RADIO_CLIENT, OnRadioClient)
	ON_BN_CLICKED(IDC_RADIO_SERVER, OnRadioServer)
	ON_BN_CLICKED(IDC_BTN_CONNECT_LISTEN, OnBtnConnect)
	ON_EN_CHANGE(IDC_EDIT_MESSAGE, OnChangeEditMessage)
	ON_BN_CLICKED(IDC_BTN_SEND, OnBtnSend)
	ON_BN_CLICKED(IDC_BTN_CLOSE, OnBtnClose)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVCPP_51Dlg message handlers

BOOL CVCPP_51Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_iServerType=0;
    m_strServerName="127.0.0.1";
    m_iServerPort=4000;


	this->SetWindowText("Server Window");

	m_ctlSent.ResetContent( );
	m_ctlReceived.ResetContent( );

	UpdateData(FALSE);

    m_wsConnectSocket.SetParent(this);
    m_wsListenSocket.SetParent(this);

	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CVCPP_51Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CVCPP_51Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CVCPP_51Dlg::OnRadioClient() 
{
    // Sync the controls with the variables
     UpdateData(TRUE);

     // Which mode are we in?
     if(m_iServerType==1)    // Set the appropriate text on the button
	 {
         GetDlgItem(IDC_BTN_CONNECT_LISTEN)->SetWindowText("Connect");

		 this->SetWindowText("Client Window");
	 }

     else
	 {
         GetDlgItem(IDC_BTN_CONNECT_LISTEN)->SetWindowText("Listen");

		 this->SetWindowText("Server Window");
	 }
}

void CVCPP_51Dlg::OnRadioServer() 
{
    // Sync the controls with the variables
     UpdateData(TRUE);

     // Which mode are we in?
     if(m_iServerType==1)    // Set the appropriate text on the button
	 {
         GetDlgItem(IDC_BTN_CONNECT_LISTEN)->SetWindowText("Connect");

		 this->SetWindowText("Client Window");
	 }

     else
	 {
         GetDlgItem(IDC_BTN_CONNECT_LISTEN)->SetWindowText("Listen");

		 this->SetWindowText("Server Window");
	 }	
}

void CVCPP_51Dlg::OnBtnConnect() 
{
	// TODO: Add your control notification handler code here
    UpdateData(TRUE);

	bool bFlag=false;

    // Are we running as client or server?
	if(m_iServerType==1)
     {
		// Client, create a default socket
        if(m_wsConnectSocket.Create( )==TRUE)
		{
	        // Open the connection to the server
		    if(m_wsConnectSocket.Connect(m_strServerName,m_iServerPort)==FALSE)
			{
				if(m_wsConnectSocket.GetLastError( )!=WSAEWOULDBLOCK)
				{
					MessageBox("Unable to create a connection with the server","Fatal Error",MB_ICONSTOP);

					bFlag=true;
				}
			}
			else
				MessageBox("ERROR");
		}

		else
			MessageBox("Unable to create a Socket","Fatal Error",MB_ICONSTOP);
     }

     else
     {
		// Server, create a socket bound to the port specified
        if(m_wsListenSocket.Create(m_iServerPort)==TRUE)
		{
	        // Listen for connection requests
		    if(m_wsListenSocket.Listen( )==FALSE)
			{
				MessageBox("Unable to connect with the client","Fatal Error",MB_ICONSTOP);

				bFlag=true;
			}
		}

		else
			MessageBox("Unable to create a Socket","Fatal Error",MB_ICONSTOP);
     }

	 if(bFlag==false)
	 {
	     // Disable the connection and type controls
		GetDlgItem(IDC_BTN_CONNECT_LISTEN)->EnableWindow(FALSE);

	    GetDlgItem(IDC_EDIT_SERVER_NAME)->EnableWindow(FALSE);
	    GetDlgItem(IDC_EDIT_SERVER_PORT)->EnableWindow(FALSE);

	    GetDlgItem(IDC_STATIC_SERVER_NAME)->EnableWindow(FALSE);
	    GetDlgItem(IDC_STATIC_SERVER_PORT)->EnableWindow(FALSE);

	    GetDlgItem(IDC_STATIC_SOCKET_TYPE)->EnableWindow(FALSE);

	    GetDlgItem(IDC_RADIO_CLIENT)->EnableWindow(FALSE);
	    GetDlgItem(IDC_RADIO_SERVER)->EnableWindow(FALSE);
	 }
}

void CVCPP_51Dlg::OnChangeEditMessage() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData( );
	
	if(m_strMessage!="")
		GetDlgItem(IDC_BTN_SEND)->EnableWindow( );

	else
		GetDlgItem(IDC_BTN_SEND)->EnableWindow(FALSE);
}

void CVCPP_51Dlg::OnAccept()
{
	// Accept the connection request
    if(m_wsListenSocket.Accept(m_wsConnectSocket)==TRUE)
	{
	    // Enable the text and message controls
		GetDlgItem(IDC_EDIT_MESSAGE)->EnableWindow( );

		GetDlgItem(IDC_BTN_SEND)->EnableWindow( );

		GetDlgItem(IDC_STATIC_MESSAGE)->EnableWindow( );
	}

	else
		MessageBox("Unable to make the connectiom.","Fatal Error",MB_ICONSTOP);
}

void CVCPP_51Dlg::OnConnect()
{
    // Enable the text and message controls
    GetDlgItem(IDC_EDIT_MESSAGE)->EnableWindow( );

	GetDlgItem(IDC_BTN_SEND)->EnableWindow( );
	GetDlgItem(IDC_BTN_CLOSE)->EnableWindow( );

    GetDlgItem(IDC_STATIC_MESSAGE)->EnableWindow( );
}

void CVCPP_51Dlg::OnSend()
{
    int iLen;
    int iSent;

	// Sync the controls with the variables
    UpdateData( );

    // Get the length of the message
    iLen=m_strMessage.GetLength( );

	if(iLen!=0)
	{
	    // Send the message
	    iSent=m_wsConnectSocket.Send(LPCTSTR(m_strMessage),iLen);

	    // Were we able to send it?
		if(iSent==SOCKET_ERROR)
			MessageBox("Unable to send the Message","Error",MB_ICONSTOP);

		else
		{
			// Add the message to the list box.
	        m_ctlSent.AddString(m_strMessage);

			m_strMessage="";

			// Sync the variables with the controls
			UpdateData(FALSE);

			GetDlgItem(IDC_BTN_SEND)->EnableWindow(FALSE);
			GetDlgItem(IDC_EDIT_MESSAGE)->SetFocus( );
		}
    }
}

void CVCPP_51Dlg::OnReceive()
{
    char *pBuf=new char[1025];
 
	int iBufSize=1024;
    int iRcvd;

    CString strRecvd;
 
	// Receive the message
    iRcvd=m_wsConnectSocket.Receive(pBuf,iBufSize);

	// Did we receive anything?
    if (iRcvd == SOCKET_ERROR)
		MessageBox("Unable to receive the Message","Error",MB_ICONSTOP);

    else
    {
        // Truncate the end of the message
        pBuf[iRcvd]=NULL;

        // Copy the message to a CString
        strRecvd=pBuf;

        // Add the message to the received list box
        m_ctlReceived.AddString(strRecvd);

        // Sync the variables with the controls
        UpdateData(FALSE);
    }
}

void CVCPP_51Dlg::OnClose()
{
    // Close the connected socket
    m_wsConnectSocket.Close( );

    // Disable the message sending controls
    GetDlgItem(IDC_EDIT_MESSAGE)->EnableWindow(FALSE);
    GetDlgItem(IDC_STATIC_MESSAGE)->EnableWindow(FALSE);

	GetDlgItem(IDC_BTN_SEND)->EnableWindow(FALSE);
	GetDlgItem(IDC_BTN_CLOSE)->EnableWindow(FALSE);

	// Are we running in Client mode?
    if (m_iServerType==1)
    {
        // Yes, so enable the connection configuration controls
		GetDlgItem(IDC_BTN_CONNECT_LISTEN)->EnableWindow( );

        GetDlgItem(IDC_STATIC_SOCKET_TYPE)->EnableWindow( );

		GetDlgItem(IDC_RADIO_CLIENT)->EnableWindow( );
        GetDlgItem(IDC_RADIO_SERVER)->EnableWindow( );

        GetDlgItem(IDC_EDIT_SERVER_NAME)->EnableWindow( );
        GetDlgItem(IDC_EDIT_SERVER_PORT)->EnableWindow( );

        GetDlgItem(IDC_STATIC_SERVER_NAME)->EnableWindow( );
        GetDlgItem(IDC_STATIC_SERVER_PORT)->EnableWindow( );
    }
}

void CVCPP_51Dlg::OnBtnSend() 
{
	// TODO: Add your control notification handler code here
	OnSend();
}

void CVCPP_51Dlg::OnBtnClose() 
{
	// TODO: Add your control notification handler code here
	OnClose( );	
}
