// VCPP_52View.cpp : implementation of the CVCPP_52View class
//

#include "stdafx.h"
#include "VCPP_52.h"

#include "VCPP_52Set.h"
#include "VCPP_52Doc.h"
#include "VCPP_52View.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVCPP_52View

IMPLEMENT_DYNCREATE(CVCPP_52View, CRecordView)

BEGIN_MESSAGE_MAP(CVCPP_52View, CRecordView)
	//{{AFX_MSG_MAP(CVCPP_52View)
	ON_COMMAND(IDM_RECORD_NEW, OnRecordNew)
	ON_COMMAND(IDM_RECORD_DELETE, OnRecordDelete)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVCPP_52View construction/destruction

CVCPP_52View::CVCPP_52View()
	: CRecordView(CVCPP_52View::IDD)
{
	//{{AFX_DATA_INIT(CVCPP_52View)
	m_pSet = NULL;
	m_oleBirthDate = COleDateTime::GetCurrentTime();
	//}}AFX_DATA_INIT
	// TODO: add construction code here

}

CVCPP_52View::~CVCPP_52View()
{
}

void CVCPP_52View::DoDataExchange(CDataExchange* pDX)
{
	CRecordView::DoDataExchange(pDX);

    // Copy the DOB from the record set to the view variable
	if(pDX->m_bSaveAndValidate==FALSE)
		m_oleBirthDate=m_pSet->m_BirthDate;

	//{{AFX_DATA_MAP(CVCPP_52View)
	DDX_FieldCheck(pDX, IDC_CHECK_SEND_CARD, m_pSet->m_SendCard, m_pSet);
	DDX_FieldText(pDX, IDC_EDIT_ADDRESS, m_pSet->m_Address, m_pSet);
	DDX_FieldText(pDX, IDC_EDIT_CITY, m_pSet->m_City, m_pSet);
	DDX_FieldText(pDX, IDC_EDIT_COUNTRY, m_pSet->m_Country, m_pSet);
	DDX_FieldText(pDX, IDC_EDIT_EMAIL, m_pSet->m_EmailAddress, m_pSet);
	DDX_FieldText(pDX, IDC_EDIT_FIRST_NAME, m_pSet->m_FirstName, m_pSet);
	DDX_FieldText(pDX, IDC_EDIT_HOME_PHONE, m_pSet->m_HomePhone, m_pSet);
	DDX_FieldText(pDX, IDC_EDIT_ID, m_pSet->m_ID, m_pSet);
	DDX_FieldText(pDX, IDC_EDIT_LAST_NAME, m_pSet->m_LastName, m_pSet);
	DDX_FieldText(pDX, IDC_EDIT_MOBILE_PHONE, m_pSet->m_MobilePhone, m_pSet);
	DDX_FieldText(pDX, IDC_EDIT_NOTES, m_pSet->m_Notes, m_pSet);
	DDX_FieldText(pDX, IDC_EDIT_POSTAL_CODE, m_pSet->m_PostalCode, m_pSet);
	DDX_FieldText(pDX, IDC_EDIT_PROVINCE, m_pSet->m_Province, m_pSet);
	DDX_FieldText(pDX, IDC_EDIT_WORK_PHONE, m_pSet->m_WorkPhone, m_pSet);
	DDX_Text(pDX, IDC_EDIT_BIRTH_DATE, m_oleBirthDate);
	//}}AFX_DATA_MAP

    // Copy the DOB variable back from the view variable to the record         set
    if(pDX->m_bSaveAndValidate==TRUE)
        m_pSet->m_BirthDate=m_oleBirthDate;

}

BOOL CVCPP_52View::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CRecordView::PreCreateWindow(cs);
}

void CVCPP_52View::OnInitialUpdate()
{
	m_pSet = &GetDocument()->m_vCPP_52Set;
	CRecordView::OnInitialUpdate();
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();

}

/////////////////////////////////////////////////////////////////////////////
// CVCPP_52View diagnostics

#ifdef _DEBUG
void CVCPP_52View::AssertValid() const
{
	CRecordView::AssertValid();
}

void CVCPP_52View::Dump(CDumpContext& dc) const
{
	CRecordView::Dump(dc);
}

CVCPP_52Doc* CVCPP_52View::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CVCPP_52Doc)));
	return (CVCPP_52Doc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CVCPP_52View database support
CRecordset* CVCPP_52View::OnGetRecordset()
{
	return m_pSet;
}


/////////////////////////////////////////////////////////////////////////////
// CVCPP_52View message handlers

void CVCPP_52View::OnRecordNew() 
{
	// TODO: Add your command handler code here
    // Get a pointer to the record set
    CRecordset* pSet = OnGetRecordset();

   // Make sure that any changes to the current record have been saved
    if (pSet->CanUpdate() && !pSet->IsDeleted())
    {
        pSet->Edit();

        if (!UpdateData())
            return;

        pSet->Update();
    }

	long ID=m_pSet->GetNextID( );

    // Add the new record
    m_pSet->AddNew();

    // Set the ID in the new record
    m_pSet->m_ID = ID;

    // Save the new record
    m_pSet->Update();

    // Refresh the record set
    m_pSet->Requery();

    // Move to the new record
    m_pSet->MoveLast();

    // Update the form
    UpdateData(FALSE);		
}

void CVCPP_52View::OnRecordDelete() 
{
	// TODO: Add your command handler code here

    // Make sure the user wants to delete this record
    if (MessageBox("Are you sure you want to delete this record?","Delete this record?",MB_YESNO|MB_ICONQUESTION)==IDYES)
    {
        // Delete the record
        m_pSet->Delete();

        // Move to the previous record
        m_pSet->MovePrev();

        // Update the form
        UpdateData(FALSE);
    }
}
