// Perceptron Neural Network Class
// Artificial Neural Net: Perceptron Using Perceptron Learning Rule

#ifndef CPNET_H
#define CPNET_H

#include <cstdio>
#include <conio.h>
#include <windows.h>
#include <iostream>
#include <ctime>
using std::cout;
using std::endl;
using std::cin;

class CPnet {
    public:
        CPnet();
		~CPnet();
		void CPMenu(void); // creates a menu for the program
		void CreateNet(void); // function for creating Neural Net
		void SaveNet(void); // function for saving Neural Net to a file
		void LoadNet(void); // function for loading Neural Net from file
		void TrainNetwork(void); // function for training Neural Net
		void TestNetwork(void); // function for testing Neral Net
		void SelectiveTest(int pattern_num ); // performs selective patterns test
		void Train(); // function for training Neural Net
		void Run(); // function for testing Neral Net
		bool fExist( char* filepath ); // checks if a given filename exist
		float ComputeWeightedSum(float *Input); // compute weighted sum
		void RandomizeWeights(); // initialise weight vector with random values
		void ComputeAverageError(); // computes average error
		void NormalizeInput(); // normalize the input vector
		void NormalizeTarget(); // normalize the target vector
		void DeNormalizeInput(); // denormalize input vector
		void DeNormalizeTarget(); // denormalize input vector
		void UpdateScreen(); // function for updating the screen
		void SaveCurrentData(); // saves current net data
	private:
		char *szNeuralNetName; // name or complete path for the Neural Net
		float LEARNING_RATE; // learning rate for the Neural Net
		int CPN_ITER;  // number of epochs or training sessions for the Neural Net
		float *Input; // input vector
		float *Output; // output vector
		float *input; // temporary input vector
		float *delta; // delta
		float *Target; // target vector
		float *Weight; // weight vector
		float threshold; // threshold
		int input_num; // number of inputs
		int neuron_num; // number of neurons
		int target_num; // number of targets
		int total_input_num; // total number of inputs
		float fAverageError; // variable for average error
		float Max; // greatest input value
		float MaxT; // greatest target value
		bool bNeuralNetCreated;
		bool bNeuralNetTrained;
		bool bNeuralNetSaved;
		bool bNeuralNetLoaded;
		bool bNewModifications;
};

#endif






