using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace ControlLib
{
	/// <summary>
	/// Summary description for ActiveButton.
	/// </summary>
	public class ActiveButton : System.Windows.Forms.Button
	{
		/// <summary> 
		/// Required designer variable.
		/// </summary>		
		private bool m_bActive;
		private int m_nSteps;		
		private System.Timers.Timer timer2;
		private System.ComponentModel.Container components = null;

		public ActiveButton()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			m_nSteps=0;
			m_bActive=false;

			// TODO: Add any initialization after the InitForm call

		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.timer2 = new System.Timers.Timer();
			((System.ComponentModel.ISupportInitialize)(this.timer2)).BeginInit();
			// 
			// timer2
			// 
			this.timer2.Enabled = true;
			this.timer2.SynchronizingObject = this;
			this.timer2.Elapsed += new System.Timers.ElapsedEventHandler(this.timer2_Click);
			// 
			// ActiveButton
			// 
			this.MouseEnter += new System.EventHandler(this.ActiveButton_MouseEnter);
			this.MouseLeave += new System.EventHandler(this.ActiveButton_MouseLeave);
			((System.ComponentModel.ISupportInitialize)(this.timer2)).EndInit();

		}
		#endregion

		private void ActiveButton_MouseEnter(object sender, System.EventArgs e)
		{
			m_bActive=true;
			timer2.Interval=50;		
		}

		private void ActiveButton_MouseLeave(object sender, System.EventArgs e)
		{
			m_bActive=false;
			timer2.Interval=150;		
		}		
		
		private void timer2_Click(object sender, System.Timers.ElapsedEventArgs e)
		{
			if (m_bActive && m_nSteps !=10)
			{
				try
				{
					BackColor=Color.FromArgb(BackColor.R-10,BackColor.G-10,BackColor.B-10);
				}
				catch(Exception)
				{
				}
				finally
				{
					m_nSteps++;
				}
			}
			else if (!m_bActive && m_nSteps>0)
			{
				try
				{
					BackColor=Color.FromArgb(BackColor.R+10,BackColor.G+10,BackColor.B+10);
				}
				catch(Exception)
				{
				}
				finally
				{
					m_nSteps--;
				}
			}
		}
	}
}
