using System;

namespace Gauss_Jacobi
{
	class Class1
	{
		static void Main(string[] args)
		{
			Console.WriteLine("\t\tGAUSSIAN JACOBI METHOD");
			Console.WriteLine("\t\t======================");
			Console.WriteLine();

			Console.Write("Enter the No of Equations == ");
			int no = int.Parse(Console.ReadLine()); // User Input No Of Equations
			Console.Write("Enter the Tolerance Limit (No of Iterations) == ");
			int tol = int.Parse(Console.ReadLine()); // Input Tolreance Limit (No Of Iterations)

			float [,] Mtrx = new float[no,no]; // Initializing The Matrix 
			float[] b = new float[no];

			Mtrx = FilMtrx_2Dim(Mtrx,no,"Coefficient"); // Filling Coefficient Matrix
			b = FilMtrx_1Dim(b,no,"B","Constant"); // Filling Constant Matrix
			
			DispMtrx_2Dim(Mtrx,no,"Coefficient"); // Filling Coefficient Matrix
			DispMtrx_1Dim(b,no,"B","Constant"); // Filling Costant Matrix
			Console.WriteLine();

			Gauss_Jacobi(Mtrx,b,no,tol); // Finding the values of X in Different Iterations 
           
			Console.ReadLine();
	    }

		//// Finding the values of X in Different Iterations 
		static void Gauss_Jacobi(float[,] Mtrx, float[] b, int no, int tol)
		{
			float[] old_x = new float[no]; // Matrix of initial values of X
			float[] new_x = new float[no]; // Matrix of Post values of X

			for(int i=0; i<no; i++)
			{
				b[i] = b[i]/Mtrx[i,i];
				new_x[i]=old_x[i];
				for(int j=0; j<no; j++)
				{
					if(i != j)		Mtrx[i,j] = Mtrx[i,j]/Mtrx[i,i];
				}
			}

			for(int k=1; k<=tol; k++) // Applaying Tolerance Limit
			{
				Console.Write("ITE {0}\t",k);
				for(int i=0; i<no; i++)
				{
					old_x[i] = new_x[i];
					new_x[i] = b[i];
				}
				for(int i=0; i<no; i++)
				{
					for(int j=0; j<no; j++)
					{
						if(i != j)	new_x[i] = new_x[i]-Mtrx[i,j] * old_x[j];
					}
				}
				for(int i=0; i<no; i++)
				{
					Console.Write("X{0}={1:F3} \t",i,new_x[i]);
				}
				Console.WriteLine();
			}
		}

		// Filling Two Dimesion Matrix
		static float[,] FilMtrx_2Dim(float[,] Mtrx, int no, string s) 
		{
			Console.WriteLine();
			Console.WriteLine("Enter the values in {0} Matrix",s);
			for(int i=0; i<no; i++)
			{
				for(int j=0; j<no; j++)
				{
					Console.Write("M[{0},{1}] == ",i,j);
					Mtrx[i,j] = float.Parse(Console.ReadLine());
				}
			}
			return Mtrx;
		}

		// Filling One Dimesion Matrix
		static float[] FilMtrx_1Dim(float[] Mtrx,int no, string s, string ss)
		{
			Console.WriteLine();
			Console.WriteLine("Enter the {0} values in {1} Matrix",ss,s);
			for(int i=0; i<no; i++)
			{
				
					Console.Write("{0}[{1}] == ",s,i);
					Mtrx[i] = float.Parse(Console.ReadLine());
				
			}
			return Mtrx;
		}

		// Displaying Two Dimesion Matrix
		static void DispMtrx_2Dim(float[,] Mtrx, int no, string s)
		{
			Console.WriteLine();
			Console.WriteLine("Displaying the values of {0} Matrix",s);
			for(int i=0; i<no; i++)
			{
				for(int j=0; j<no; j++)
				{
					Console.Write("{0:F2}\t",Mtrx[i,j]);
				}
				Console.WriteLine();
			}
		}

		// Displaying One Dimesion Matrix
		static void DispMtrx_1Dim(float[] Mtrx,int no, string s, string ss)
		{
			Console.WriteLine();
			Console.WriteLine("Displaying the {0} values in {1} Matrix",ss,s);
			for(int i=0; i<no; i++)
			{
				Console.WriteLine("{0:F2}",Mtrx[i]);
			}
		}
	}

}
