#define WIN32_LEAN_AND_MEAN

#include <windows.h>


LRESULT CALLBACK WndProc(HWND hwnd, UINT message , WPARAM wParam , LPARAM lParam)
{	
	switch(message)
	{
		case WM_DESTROY:
			PostQuitMessage(0);			
			break;				
			
		default:
			return (DefWindowProc(hwnd,message,wParam,lParam));			
	}

	return 0;	
}

int WINAPI WinMain (HINSTANCE hInstance , HINSTANCE hPreviousInstance , LPSTR lpCmdLine , int nShowCmd)
{
	WNDCLASSEX windowClass;
	HWND hwndMain,hwndPopup;
	MSG msg;
	bool done;

	windowClass.cbSize=sizeof(WNDCLASSEX);
	windowClass.style=CS_HREDRAW | CS_VREDRAW;
	windowClass.lpfnWndProc=mainWindowClass;
	windowClass.cbClsExtra=0;
	windowClass.cbWndExtra=0;
	windowClass.hInstance=hInstance;
	windowClass.hIcon=LoadIcon(NULL,IDI_APPLICATION);
	windowClass.hCursor=LoadCursor(NULL,IDC_UPARROW);
	windowClass.hbrBackground=(HBRUSH)GetStockObject(GRAY_BRUSH);
	windowClass.lpszMenuName=NULL;
	windowClass.lpszClassName="MainWindowClass";
	windowClass.hIconSm=LoadIcon(NULL,IDI_WINLOGO);


	windowClass.lpfnWndProc=popupWindowClass;
	windowClass.hCursor=LoadCursor(NULL,IDC_HELP);
	windowClass.hbrBackground=(HBRUSH)(COLOR_WINDOW+1);	
	windowClass.lpszClassName="PopupWindowClass";	

	if(!RegisterClassEx(&windowClass))
		return 0;

	hwndMain = CreateWindowEx(NULL,
							"MainWindowClass",
							"Main Window",
							WS_OVERLAPPEDWINDOW |
							WS_VISIBLE, 
							100,100,
							400,300,
							NULL,
							NULL,
							hInstance,
							NULL);

	hwndPopup = CreateWindowEx(NULL,
							"PopupWindowClass",
							"Popup Window",
							WS_POPUP | WS_CAPTION |
							WS_VISIBLE, 
							250,250,
							300,250,
							hwndMain,
							NULL,
							hInstance,
							NULL);

	CreateWindow("BUTTON","Rectangle",							
							WS_CHILD |
							WS_VISIBLE, 
							10,10,
							100,50,
							hwndMain,
							5,
							hInstance,
							NULL);

	CreateWindow("EDIT","Message",							
							WS_CHILD |
							WS_VISIBLE | ES_LOWERCASE, 
							10,190,
							200,25,
							hwndMain,
							8,
							hInstance,
							NULL);

	if (!hwndMain)
		return 0;

	done=false;	

	while(!done)
	{
		PeekMessage(&msg,hwnd,NULL,NULL,PM_REMOVE);

		if (msg.message == WM_QUIT)
		{
			done=true;
		}
		else
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return msg.wParam;
}

