using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO;

namespace netpcap_distrib
{
	/// <summary>
	/// Summary description for Analysis.
	/// </summary>
	public class Analysis : System.Windows.Forms.Form
	{
		private System.Windows.Forms.ListBox listBox1;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Button BtnAn;
		private System.Windows.Forms.Button BtnSort;
		private System.Windows.Forms.ComboBox comboBox1;
		private System.Windows.Forms.Button BtnAdv;
		private string[] server_names;
		private string[] host_names;
		private int server_index;
		private int host_index;
		
		
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Analysis()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.listBox1 = new System.Windows.Forms.ListBox();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.BtnAn = new System.Windows.Forms.Button();
			this.BtnSort = new System.Windows.Forms.Button();
			this.comboBox1 = new System.Windows.Forms.ComboBox();
			this.BtnAdv = new System.Windows.Forms.Button();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// listBox1
			// 
			this.listBox1.HorizontalScrollbar = true;
			this.listBox1.ItemHeight = 16;
			this.listBox1.Location = new System.Drawing.Point(15, 28);
			this.listBox1.Name = "listBox1";
			this.listBox1.Size = new System.Drawing.Size(481, 244);
			this.listBox1.TabIndex = 0;
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.listBox1});
			this.groupBox1.Font = new System.Drawing.Font("Microsoft Sans Serif", 10F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.groupBox1.Location = new System.Drawing.Point(15, 12);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(512, 288);
			this.groupBox1.TabIndex = 1;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "PACKETS ANALYZE";
			// 
			// BtnAn
			// 
			this.BtnAn.BackColor = System.Drawing.SystemColors.InactiveCaptionText;
			this.BtnAn.Location = new System.Drawing.Point(16, 312);
			this.BtnAn.Name = "BtnAn";
			this.BtnAn.Size = new System.Drawing.Size(120, 23);
			this.BtnAn.TabIndex = 16;
			this.BtnAn.Text = "Analyze";
			this.BtnAn.Click += new System.EventHandler(this.BtnAn_Click);
			// 
			// BtnSort
			// 
			this.BtnSort.BackColor = System.Drawing.SystemColors.InactiveCaptionText;
			this.BtnSort.Location = new System.Drawing.Point(400, 312);
			this.BtnSort.Name = "BtnSort";
			this.BtnSort.Size = new System.Drawing.Size(120, 23);
			this.BtnSort.TabIndex = 17;
			this.BtnSort.Text = "Sort";
			this.BtnSort.Click += new System.EventHandler(this.BtnSort_Click);
			// 
			// comboBox1
			// 
			this.comboBox1.Location = new System.Drawing.Point(40, 312);
			this.comboBox1.Name = "comboBox1";
			this.comboBox1.Size = new System.Drawing.Size(352, 21);
			this.comboBox1.TabIndex = 18;
			this.comboBox1.Text = "Sorting the Packet List according to the severs";
			this.comboBox1.Visible = false;
			this.comboBox1.SelectedIndexChanged += new System.EventHandler(this.comboBox1_SelectedIndexChanged);
			// 
			// BtnAdv
			// 
			this.BtnAdv.BackColor = System.Drawing.SystemColors.InactiveCaptionText;
			this.BtnAdv.Location = new System.Drawing.Point(400, 312);
			this.BtnAdv.Name = "BtnAdv";
			this.BtnAdv.Size = new System.Drawing.Size(120, 23);
			this.BtnAdv.TabIndex = 19;
			this.BtnAdv.Text = "Advance";
			this.BtnAdv.Visible = false;
			this.BtnAdv.Click += new System.EventHandler(this.BtnAdv_Click);
			// 
			// Analysis
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(544, 350);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.comboBox1,
																		  this.BtnSort,
																		  this.BtnAn,
																		  this.groupBox1,
																		  this.BtnAdv});
			this.Name = "Analysis";
			this.Text = "Packets Analyze";
			this.Load += new System.EventHandler(this.Analysis_Load);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		public void Read_File(int allow)
		{
			FileInfo file=new FileInfo(@"C:\sample2.txt");			
			StreamReader sr=file.OpenText();						
			listBox1.Items.Clear();														

			string s=null;
			int a=-1;
			bool check=false;						
			
			do
			{				
				s=sr.ReadLine();

				if (s==null)
					break;

				s=s.ToUpper();
				a=-1;
				check=false;				

				a=s.IndexOf("GET HTTP");

				if ((a!=-1)&&((allow==3)||(allow==2)))
				{
					check=true;
				}

				if (a==-1)
				{
					a=s.IndexOf("HTTP/");

					if ((a!=-1)&&((allow==3)||(allow==1)))
					{
						check=true;
					}
				}

				if (check==true)
				{					
					s=s.Remove(0,a);			

					listBox1.Items.Add(s);					

					do
					{
						s=sr.ReadLine();						
						listBox1.Items.Add(s);

						if (allow==3)
						{
							if (s.IndexOf("Server")==0)
							{
								Save_Servers(s);	
							}

							if (s.IndexOf("Host")==0)
							{
								Save_Hosts(s);	
							}
							
						}
					}
					while(s!="");
				}		
				
			}
			while(true);			
			sr.Close();			
		}
		
		private void Read_Required_File(string search)
		{
			FileInfo file=new FileInfo(@"C:\sample2.txt");			
			StreamReader sr=file.OpenText();				
			int read_count=0;
			int inner_count=0;

			listBox1.Items.Clear();														

			string s=null;
			int a=-1;
			bool check=false;						
			
			do
			{				
				inner_count=0;
				s=sr.ReadLine();
				read_count++;

				if (s==null)
					break;

				s=s.ToUpper();
				a=-1;
				check=false;				

				a=s.IndexOf("GET HTTP");

				if (a!=-1)
				{
					check=true;
				}

				if (a==-1)
				{
					a=s.IndexOf("HTTP/");

					if (a!=-1)
					{
						check=true;
					}
				}

				if (check==true)
				{
					do
					{
						s=sr.ReadLine();												
						read_count++;
						inner_count++;
						
						if (s==search)
						{			
							FileInfo file2=new FileInfo(@"C:\sample2.txt");			
							StreamReader sr2=file2.OpenText();			

							for (int i=1 ; i<=(read_count-inner_count-1) ; i++)
							{
								s=sr2.ReadLine();								
							}							

							s=sr2.ReadLine();							
							a=s.IndexOf("GET HTTP");

							if (a==-1)
								a=s.IndexOf("HTTP/");

							s=s.Remove(0,a);			
							listBox1.Items.Add(s);					

							do
							{	
								s=sr2.ReadLine();						
								listBox1.Items.Add(s);							
							}
							while(s!="");							

							sr2.Close();
						}
					}
					while(s!="");
				}					
			}
			while(true);			
			sr.Close();				
		}

		private void Analysis_Load(object sender, System.EventArgs e)
		{
		
		}

		private void BtnAn_Click(object sender, System.EventArgs e)
		{	
			this.comboBox1.Visible=false;			
			this.BtnSort.Location = new System.Drawing.Point(400, 312);
			this.BtnAn.Location = new System.Drawing.Point(16, 312);				
			this.Size=new System.Drawing.Size(552,384);			
			listBox1.Items.Clear();
			server_names=new String[20];
			host_names=new String[20];
			server_index=0;
			host_index=0;
			Read_File(3);			
		}

		private void BtnSort_Click(object sender, System.EventArgs e)
		{
			listBox1.Items.Clear();
			this.Size=new System.Drawing.Size(552,430);			
			this.BtnSort.Location = new System.Drawing.Point(400, 352);
			this.BtnAn.Location = new System.Drawing.Point(16, 352);	
			this.comboBox1.Visible=true;
			this.BtnAdv.Visible=true;			
			this.comboBox1.Text="Sort According to the Responses";
			this.comboBox1.Items.Clear();
			this.comboBox1.Items.Add("Http Request");
			this.comboBox1.Items.Add("Http Response");
		}

		private bool Check_Server_Name(string server_name)
		{
			for (int i=0 ; i<server_index ; i++)
			{
				if (server_names[i]==server_name)
					return false;				
			}

			return true;
		}

		private bool Check_Host_Name(string host_name)
		{
			for (int i=0 ; i<host_index ; i++)
			{
				if (host_names[i]==host_name)
					return false;				
			}

			return true;
		}

		private void Save_Servers(string server_name)
		{				
			if (Check_Server_Name(server_name)==true)
			{
				server_names[server_index]=server_name;
				server_index++;
			}
		}

		private void Save_Hosts(string host_name)
		{				
			if (Check_Host_Name(host_name)==true)
			{
				host_names[host_index]=host_name;
				host_index++;
			}
		}

		private void Display_Server_List()
		{
			this.comboBox1.Items.Clear();

			for (int i=0 ; i<server_index ; i++)
			{
				this.comboBox1.Items.Add(server_names[i]);
			}
		}

		private void Display_Host_List()
		{
			this.comboBox1.Items.Clear();

			for (int i=0 ; i<host_index ; i++)
			{
				this.comboBox1.Items.Add(host_names[i]);
			}
		}

		private void comboBox1_SelectedIndexChanged(object sender, System.EventArgs e)
		{			
			if (this.comboBox1.SelectedItem.ToString()=="Http Response")
			{
				Read_File(1);
			}
			else if (this.comboBox1.SelectedItem.ToString()=="Http Request")
			{
				Read_File(2);
			}			
			else
			{				
				Read_Required_File(this.comboBox1.SelectedItem.ToString());
			}

		}

		private void BtnAdv_Click(object sender, System.EventArgs e)
		{
			if (this.BtnAdv.BackColor==System.Drawing.SystemColors.ControlLightLight)		
			{
				this.BtnAdv.BackColor=System.Drawing.SystemColors.InactiveCaptionText;											
				BtnSort_Click(sender,e);
			}
			else
			{
				this.BtnAdv.BackColor=System.Drawing.SystemColors.ControlLightLight;												

				if (this.comboBox1.SelectedItem.ToString()=="Http Response")
				{
					this.comboBox1.Text="Sort According to the Severs";				
					Display_Server_List();
				}
				else
				{
					this.comboBox1.Text="Sort According to the Hosts";				
					Display_Host_List();
				}				
			}
			
		}
	}
}
