using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Runtime.InteropServices;
using System.Text;
using System.IO;


namespace netpcap
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{

		ArrayList devlist=null;
		private System.Windows.Forms.Label labAdapters;
		private System.Windows.Forms.ComboBox cbAdapters;
		private System.Windows.Forms.SaveFileDialog sfd;
		private System.Windows.Forms.Label labPacketCnt;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label labDump;
		long pack_count=0;
		private System.Windows.Forms.RichTextBox rtb;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem menuItem5;
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.MenuItem menuItem7;
		private System.Windows.Forms.MenuItem menuItem8;
		private System.Windows.Forms.MenuItem menuItem9;
		private System.Windows.Forms.MenuItem menuItem10;
		private System.Windows.Forms.MenuItem menuItem11;
		private System.Windows.Forms.MenuItem menuItem12;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Button BtnAn;
		private dotnetWinpCap.ReceivePacket rcvPack=null;

		[DllImport("advapi32.dll")]
		public static extern bool GetUserName( StringBuilder name, ref int size);

		dotnetWinpCap wpcap=null;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;



		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.cbAdapters = new System.Windows.Forms.ComboBox();
			this.labAdapters = new System.Windows.Forms.Label();
			this.sfd = new System.Windows.Forms.SaveFileDialog();
			this.labPacketCnt = new System.Windows.Forms.Label();
			this.label1 = new System.Windows.Forms.Label();
			this.labDump = new System.Windows.Forms.Label();
			this.rtb = new System.Windows.Forms.RichTextBox();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.menuItem5 = new System.Windows.Forms.MenuItem();
			this.menuItem6 = new System.Windows.Forms.MenuItem();
			this.menuItem11 = new System.Windows.Forms.MenuItem();
			this.menuItem12 = new System.Windows.Forms.MenuItem();
			this.menuItem7 = new System.Windows.Forms.MenuItem();
			this.menuItem8 = new System.Windows.Forms.MenuItem();
			this.menuItem9 = new System.Windows.Forms.MenuItem();
			this.menuItem10 = new System.Windows.Forms.MenuItem();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.BtnAn = new System.Windows.Forms.Button();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// cbAdapters
			// 
			this.cbAdapters.Anchor = ((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.cbAdapters.Location = new System.Drawing.Point(104, 16);
			this.cbAdapters.Name = "cbAdapters";
			this.cbAdapters.Size = new System.Drawing.Size(368, 21);
			this.cbAdapters.TabIndex = 2;
			this.cbAdapters.SelectedIndexChanged += new System.EventHandler(this.cbAdapters_SelectedIndexChanged);
			// 
			// labAdapters
			// 
			this.labAdapters.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.labAdapters.Location = new System.Drawing.Point(24, 16);
			this.labAdapters.Name = "labAdapters";
			this.labAdapters.Size = new System.Drawing.Size(56, 16);
			this.labAdapters.TabIndex = 4;
			this.labAdapters.Text = "Adapters";
			// 
			// sfd
			// 
			this.sfd.FileName = "doc1";
			// 
			// labPacketCnt
			// 
			this.labPacketCnt.Anchor = (System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left);
			this.labPacketCnt.Location = new System.Drawing.Point(24, 96);
			this.labPacketCnt.Name = "labPacketCnt";
			this.labPacketCnt.Size = new System.Drawing.Size(64, 16);
			this.labPacketCnt.TabIndex = 9;
			// 
			// label1
			// 
			this.label1.Anchor = (System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left);
			this.label1.Location = new System.Drawing.Point(16, 72);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(72, 16);
			this.label1.TabIndex = 10;
			this.label1.Text = "Packet count";
			// 
			// labDump
			// 
			this.labDump.Anchor = (System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right);
			this.labDump.Location = new System.Drawing.Point(16, 248);
			this.labDump.Name = "labDump";
			this.labDump.Size = new System.Drawing.Size(128, 16);
			this.labDump.TabIndex = 11;
			// 
			// rtb
			// 
			this.rtb.Location = new System.Drawing.Point(8, 24);
			this.rtb.Name = "rtb";
			this.rtb.ReadOnly = true;
			this.rtb.Size = new System.Drawing.Size(352, 152);
			this.rtb.TabIndex = 14;
			this.rtb.Text = "";
			this.rtb.WordWrap = false;
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItem1,
																					  this.menuItem3,
																					  this.menuItem7});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItem2});
			this.menuItem1.Text = "File";
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 0;
			this.menuItem2.Text = "Exit";
			this.menuItem2.Click += new System.EventHandler(this.menuItem2_Click);
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 1;
			this.menuItem3.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItem4,
																					  this.menuItem11});
			this.menuItem3.Text = "Option";
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 0;
			this.menuItem4.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItem5,
																					  this.menuItem6});
			this.menuItem4.Text = "Capture";
			// 
			// menuItem5
			// 
			this.menuItem5.Index = 0;
			this.menuItem5.Text = "Start";
			this.menuItem5.Click += new System.EventHandler(this.button1_Click);
			// 
			// menuItem6
			// 
			this.menuItem6.Index = 1;
			this.menuItem6.Text = "Stop";
			this.menuItem6.Click += new System.EventHandler(this.butStop_Click);
			// 
			// menuItem11
			// 
			this.menuItem11.Index = 1;
			this.menuItem11.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					   this.menuItem12});
			this.menuItem11.Text = "Show";
			// 
			// menuItem12
			// 
			this.menuItem12.Index = 0;
			this.menuItem12.Text = "Analyze Window";
			// 
			// menuItem7
			// 
			this.menuItem7.Index = 2;
			this.menuItem7.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItem8,
																					  this.menuItem9,
																					  this.menuItem10});
			this.menuItem7.Text = "About";
			// 
			// menuItem8
			// 
			this.menuItem8.Index = 0;
			this.menuItem8.Text = "WinPCap";
			// 
			// menuItem9
			// 
			this.menuItem9.Index = 1;
			this.menuItem9.Text = "WinPCapdotNet";
			// 
			// menuItem10
			// 
			this.menuItem10.Index = 2;
			this.menuItem10.Text = "Help";
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.rtb});
			this.groupBox1.Font = new System.Drawing.Font("Microsoft Sans Serif", 10F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.groupBox1.Location = new System.Drawing.Point(104, 48);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(368, 184);
			this.groupBox1.TabIndex = 15;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "PACKET CAPTURING";
			// 
			// BtnAn
			// 
			this.BtnAn.BackColor = System.Drawing.SystemColors.InactiveCaptionText;
			this.BtnAn.Location = new System.Drawing.Point(312, 248);
			this.BtnAn.Name = "BtnAn";
			this.BtnAn.Size = new System.Drawing.Size(160, 23);
			this.BtnAn.TabIndex = 15;
			this.BtnAn.Text = "Analyze Window";
			this.BtnAn.Click += new System.EventHandler(this.BtnAn_Click);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(496, 281);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.groupBox1,
																		  this.labDump,
																		  this.label1,
																		  this.labPacketCnt,
																		  this.labAdapters,
																		  this.cbAdapters,
																		  this.BtnAn});
			this.Menu = this.mainMenu1;
			this.Name = "Form1";
			this.Text = "Packet Capturing";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.Form1_Closing);
			this.Load += new System.EventHandler(this.Form1_Load);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			menuItem5.Checked=true;

			if (wpcap==null) 
			{
				wpcap=new dotnetWinpCap();
			}
			if (wpcap.IsOpen) 
			{
				wpcap.Close();
			}
			if (!wpcap.Open( ((Device)devlist[cbAdapters.SelectedIndex]).Name,65536,1,0)) 
			{
				System.Diagnostics.Debug.WriteLine(wpcap.LastError);
				rtb.AppendText(wpcap.LastError+"\n");
			}
			else
			{
				System.Diagnostics.Debug.WriteLine("opened successfully: "+((Device)devlist[0]).Name);
				rtb.AppendText("Opened successfully: "+((Device)devlist[cbAdapters.SelectedIndex]).Name+"\n");
			}
		
		
			wpcap.SetMinToCopy(100);

			if (rcvPack==null) 
			{
				rcvPack=new dotnetWinpCap.ReceivePacket(this.ReceivePacket);
				wpcap.OnReceivePacket+=rcvPack;
			}
			

			wpcap.StartListen();
			rtb.AppendText("Capturing. . .\n");			

			StartDump();
		}

		private void DumpEnded(object sender) 
		{
			System.Diagnostics.Debug.WriteLine("livedump ended");
			wpcap.Close();
		}


		private  void ReceivePacket(object sender, PacketHeader p, byte[] s) 
		
		{
			this.pack_count++;
			rtb.Focus();
			rtb.AppendText("Content of p : \n");
			rtb.AppendText("	Caplength: "+p.Caplength+"\n");
			rtb.AppendText("	Length   : "+p.Length+"\n");
			rtb.AppendText("	Timestamp: "+ (p.TimeStamp)+"\n");
			labPacketCnt.Text=Convert.ToString(this.pack_count);

		}

		private void Form1_Load(object sender, System.EventArgs e)
		{
			if (wpcap==null) 
			{

				devlist=dotnetWinpCap.FindAllDevs();
				for (int i=0; i<=devlist.Count-1; i++) 
				{
					cbAdapters.Items.Add( ((Device)devlist[i]).Name+":"+((Device)devlist[i]).Description);
				}
			}
			if (cbAdapters.Items.Count>0) 
			{
				cbAdapters.SelectedIndex=0;
			}

		}

		private void Form1_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if (this.wpcap!=null) 
			{
				wpcap.Close();				
			}

		}
		

		private void StartDump()
		{
			if (wpcap!=null) 
			{
				if (wpcap.StartDump(@"C:\DumpFile.txt")==true) 
				{
					labDump.Text="Dumping";
				} 

			}
		}

		private void butStop_Click(object sender, System.EventArgs e)
		{
			menuItem5.Checked=false;
			menuItem6.Checked=true;

			Stop_Dump();

			if (wpcap!=null) 
			{
				wpcap.StopListen();
				wpcap.Close();
			}
		}

		private void Stop_Dump()
		{
			if (wpcap!=null) 
			{
				wpcap.StopDump();
				labDump.Text="Dumping stopped";
			}
		}

		private void butSend_Click(object sender, System.EventArgs e)
		{
			if (wpcap==null) 
			{
				wpcap=new dotnetWinpCap();
			}
			if (!wpcap.IsOpen) 
			{
				if (!wpcap.Open(((Device)devlist[cbAdapters.SelectedIndex]).Name, 65536, 1,0)) 
				{
					MessageBox.Show(this, "Cannot open adapter "+cbAdapters.Text);
					return;
				}
			}

			byte[] b=new byte [10];
			for (int i=0; i<b.Length; i++) 
			{
				b[i]=(byte)i;
			}
			if (!wpcap.SendPacket(b))
			{
				rtb.AppendText("Send unsuccessful\n");
			} 
			else
			{
				rtb.AppendText("Sent garbage: "+b.ToString()+"\n");
			}
		}

		private void menuItem2_Click(object sender, System.EventArgs e)
		{				
			
		}

		private void BtnAn_Click(object sender, System.EventArgs e)
		{
			netpcap_distrib.Analysis a=new netpcap_distrib.Analysis();			
			a.ShowDialog();			
		}

		private void cbAdapters_SelectedIndexChanged(object sender, System.EventArgs e)
		{
		
		}		
	}
}

