using System;

namespace ScoreBoard
{
	/// <summary>
	/// CLOCK CLASS
	/// </summary>
	public class Clock
	{
		// DELAGATES ARE USED TO UPDATE THE COUNTER OF THE CLOCK
		public delegate void UpdateRequest(object sender, RequestEventArgs e);
		public event UpdateRequest OnUpdateRequest;

		public int Counter ;

		// THIS FUNCTION RESETS THE CLOCK TO ITS DEFAULT VALUE
		public void Reset()
		{
			Counter = 0;
			OnUpdateRequest(this, 
				new RequestEventArgs(RequestType.ChangeClockCycle));
		}

		// THIS FUCNTION INCREMENT THE CLOCK BY 1
		public void Increment()
		{
			++Counter;
			OnUpdateRequest(this, 
				new RequestEventArgs(RequestType.ChangeClockCycle));
		}

		//CONSTRUCTOR
		public Clock()
		{ 
			Counter = 0;			
		}
	
	}
}
