using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;


namespace ScoreBoard
{
	enum ButtonType
	{
		Start,
		Stop,
		OpenFile
	};
	
	
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private ScoreBoard refScoreBoard;
		private ArrayList RegControl = new ArrayList(32);
		private ButtonType buttonType
			= new ButtonType();
	
		private Timer timer = new Timer();
		private System.Windows.Forms.ColumnHeader OpCode;
		private System.Windows.Forms.ColumnHeader i;
		private System.Windows.Forms.ColumnHeader j;
		private System.Windows.Forms.ColumnHeader k;
		private System.Windows.Forms.ColumnHeader Issue;
		private System.Windows.Forms.ColumnHeader ReadOperands;
		private System.Windows.Forms.ColumnHeader Execution;
		private System.Windows.Forms.ColumnHeader WriteResult;
		private System.Windows.Forms.ListView lvInstStatus;
		private System.Windows.Forms.ListView lvFUStatus;
		private System.Windows.Forms.ColumnHeader FunctionalUnit;
		private System.Windows.Forms.ColumnHeader Busy;
		private System.Windows.Forms.ColumnHeader Op;
		private System.Windows.Forms.ColumnHeader Fi;
		private System.Windows.Forms.ColumnHeader Fj;
		private System.Windows.Forms.ColumnHeader Fk;
		private System.Windows.Forms.ColumnHeader Qj;
		private System.Windows.Forms.ColumnHeader Qk;
		private System.Windows.Forms.ColumnHeader Rj;
		private System.Windows.Forms.ColumnHeader Rk;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.Label label9;
		private System.Windows.Forms.Label label10;
		private System.Windows.Forms.Label label11;
		private System.Windows.Forms.Label label12;
		private System.Windows.Forms.Label label13;
		private System.Windows.Forms.Label label14;
		private System.Windows.Forms.Label label15;
		private System.Windows.Forms.Label label16;
		private System.Windows.Forms.Label label17;
		private System.Windows.Forms.Label label18;
		private System.Windows.Forms.Label label19;
		private System.Windows.Forms.Label label20;
		private System.Windows.Forms.Label label21;
		private System.Windows.Forms.Label label22;
		private System.Windows.Forms.Label label23;
		private System.Windows.Forms.Label label24;
		private System.Windows.Forms.Label label25;
		private System.Windows.Forms.Label label26;
		private System.Windows.Forms.Label label27;
		private System.Windows.Forms.Label label28;
		private System.Windows.Forms.Label label29;
		private System.Windows.Forms.Label label30;
		private System.Windows.Forms.Label label31;
		private System.Windows.Forms.Label label32;
		private System.Windows.Forms.Label label33;
		private System.Windows.Forms.Label label34;
		private System.Windows.Forms.Label label35;
		private System.Windows.Forms.Label label36;
		private System.Windows.Forms.Label label37;
		private System.Windows.Forms.Label label38;
		private System.Windows.Forms.Label label39;
		private System.Windows.Forms.Label label40;
		private System.Windows.Forms.Label label41;
		private System.Windows.Forms.Label label42;
		private System.Windows.Forms.Label label43;
		private System.Windows.Forms.Label label44;
		private System.Windows.Forms.Label label45;
		private System.Windows.Forms.Label label46;
		private System.Windows.Forms.Label label47;
		private System.Windows.Forms.Label label48;
		private System.Windows.Forms.Label label49;
		private System.Windows.Forms.Label label50;
		private System.Windows.Forms.Label label51;
		private System.Windows.Forms.Label label52;
		private System.Windows.Forms.Label label53;
		private System.Windows.Forms.Label label54;
		private System.Windows.Forms.Label label55;
		private System.Windows.Forms.Label label56;
		private System.Windows.Forms.Label label57;
		private System.Windows.Forms.Label label58;
		private System.Windows.Forms.Label label59;
		private System.Windows.Forms.Label label60;
		private System.Windows.Forms.Label label61;
		private System.Windows.Forms.Label label62;
		private System.Windows.Forms.Label label63;
		private System.Windows.Forms.Label label64;
		private System.Windows.Forms.Label label65;
		private System.Windows.Forms.Label label66;
		private System.Windows.Forms.Label label67;
		private System.Windows.Forms.Button btnConfig;
		private System.Windows.Forms.Button btnStart;
		private System.Windows.Forms.Button btnNext;
		private System.Windows.Forms.PictureBox ClockPulse;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.GroupBox F;
		private System.Windows.Forms.Label label1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1(ScoreBoard refSB)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			
			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			refScoreBoard = refSB;
			refScoreBoard.scheduler.OnUpdateRequest += 
				new Scheduler.UpdateRequest(UpdateRequestHandler);
			refScoreBoard.clock.OnUpdateRequest += 
				new Clock.UpdateRequest(UpdateRequestHandler);

			ClockPulse.Paint += new PaintEventHandler(Clock_Paint);

			btnNext.Hide();

			RegControl.Add(label44);
			RegControl.Add(label43);
			RegControl.Add(label42);
			RegControl.Add(label41);
			RegControl.Add(label40);
			RegControl.Add(label39);
			RegControl.Add(label38);
			RegControl.Add(label37);
			RegControl.Add(label36);
			RegControl.Add(label51);
			RegControl.Add(label50);
			RegControl.Add(label49);
			RegControl.Add(label48);
			RegControl.Add(label47);
			RegControl.Add(label46);
			RegControl.Add(label45);
			RegControl.Add(label60);
			RegControl.Add(label59);
			RegControl.Add(label58);
			RegControl.Add(label57);
			RegControl.Add(label56);
			RegControl.Add(label55);
			RegControl.Add(label54);
			RegControl.Add(label53);
			RegControl.Add(label52);
			RegControl.Add(label67);
			RegControl.Add(label65);
			RegControl.Add(label66);
			RegControl.Add(label64);
			RegControl.Add(label63);
			RegControl.Add(label62);
			RegControl.Add(label61);

			foreach( Control ctrl in RegControl )
			{
				ctrl.Text = "";
			}
		
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Windows.Forms.ListViewItem listViewItem1 = new System.Windows.Forms.ListViewItem(new string[] {
																													 "Integer",
																													 "",
																													 "",
																													 "",
																													 "",
																													 "",
																													 "",
																													 "",
																													 "",
																													 ""}, -1);
			System.Windows.Forms.ListViewItem listViewItem2 = new System.Windows.Forms.ListViewItem(new string[] {
																													 "Mult1",
																													 "",
																													 "",
																													 "",
																													 "",
																													 "",
																													 "",
																													 "",
																													 "",
																													 ""}, -1);
			System.Windows.Forms.ListViewItem listViewItem3 = new System.Windows.Forms.ListViewItem(new string[] {
																													 "Mult2",
																													 "",
																													 "",
																													 "",
																													 "",
																													 "",
																													 "",
																													 "",
																													 "",
																													 ""}, -1);
			System.Windows.Forms.ListViewItem listViewItem4 = new System.Windows.Forms.ListViewItem(new string[] {
																													 "Add",
																													 "",
																													 "",
																													 "",
																													 "",
																													 "",
																													 "",
																													 "",
																													 "",
																													 ""}, -1);
			System.Windows.Forms.ListViewItem listViewItem5 = new System.Windows.Forms.ListViewItem(new string[] {
																													 "Divide",
																													 "",
																													 "",
																													 "",
																													 "",
																													 "",
																													 "",
																													 "",
																													 "",
																													 ""}, -1);
			this.btnConfig = new System.Windows.Forms.Button();
			this.btnStart = new System.Windows.Forms.Button();
			this.lvInstStatus = new System.Windows.Forms.ListView();
			this.OpCode = new System.Windows.Forms.ColumnHeader();
			this.i = new System.Windows.Forms.ColumnHeader();
			this.j = new System.Windows.Forms.ColumnHeader();
			this.k = new System.Windows.Forms.ColumnHeader();
			this.Issue = new System.Windows.Forms.ColumnHeader();
			this.ReadOperands = new System.Windows.Forms.ColumnHeader();
			this.Execution = new System.Windows.Forms.ColumnHeader();
			this.WriteResult = new System.Windows.Forms.ColumnHeader();
			this.lvFUStatus = new System.Windows.Forms.ListView();
			this.FunctionalUnit = new System.Windows.Forms.ColumnHeader();
			this.Busy = new System.Windows.Forms.ColumnHeader();
			this.Op = new System.Windows.Forms.ColumnHeader();
			this.Fi = new System.Windows.Forms.ColumnHeader();
			this.Fj = new System.Windows.Forms.ColumnHeader();
			this.Fk = new System.Windows.Forms.ColumnHeader();
			this.Qj = new System.Windows.Forms.ColumnHeader();
			this.Qk = new System.Windows.Forms.ColumnHeader();
			this.Rj = new System.Windows.Forms.ColumnHeader();
			this.Rk = new System.Windows.Forms.ColumnHeader();
			this.label4 = new System.Windows.Forms.Label();
			this.label5 = new System.Windows.Forms.Label();
			this.label6 = new System.Windows.Forms.Label();
			this.label7 = new System.Windows.Forms.Label();
			this.label8 = new System.Windows.Forms.Label();
			this.label9 = new System.Windows.Forms.Label();
			this.label10 = new System.Windows.Forms.Label();
			this.label11 = new System.Windows.Forms.Label();
			this.label12 = new System.Windows.Forms.Label();
			this.label13 = new System.Windows.Forms.Label();
			this.label14 = new System.Windows.Forms.Label();
			this.label15 = new System.Windows.Forms.Label();
			this.label16 = new System.Windows.Forms.Label();
			this.label17 = new System.Windows.Forms.Label();
			this.label18 = new System.Windows.Forms.Label();
			this.label19 = new System.Windows.Forms.Label();
			this.label20 = new System.Windows.Forms.Label();
			this.label21 = new System.Windows.Forms.Label();
			this.label22 = new System.Windows.Forms.Label();
			this.label23 = new System.Windows.Forms.Label();
			this.label24 = new System.Windows.Forms.Label();
			this.label25 = new System.Windows.Forms.Label();
			this.label26 = new System.Windows.Forms.Label();
			this.label27 = new System.Windows.Forms.Label();
			this.label28 = new System.Windows.Forms.Label();
			this.label29 = new System.Windows.Forms.Label();
			this.label30 = new System.Windows.Forms.Label();
			this.label31 = new System.Windows.Forms.Label();
			this.label32 = new System.Windows.Forms.Label();
			this.label33 = new System.Windows.Forms.Label();
			this.label34 = new System.Windows.Forms.Label();
			this.label35 = new System.Windows.Forms.Label();
			this.label36 = new System.Windows.Forms.Label();
			this.label37 = new System.Windows.Forms.Label();
			this.label38 = new System.Windows.Forms.Label();
			this.label39 = new System.Windows.Forms.Label();
			this.label40 = new System.Windows.Forms.Label();
			this.label41 = new System.Windows.Forms.Label();
			this.label42 = new System.Windows.Forms.Label();
			this.label43 = new System.Windows.Forms.Label();
			this.label44 = new System.Windows.Forms.Label();
			this.label45 = new System.Windows.Forms.Label();
			this.label46 = new System.Windows.Forms.Label();
			this.label47 = new System.Windows.Forms.Label();
			this.label48 = new System.Windows.Forms.Label();
			this.label49 = new System.Windows.Forms.Label();
			this.label50 = new System.Windows.Forms.Label();
			this.label51 = new System.Windows.Forms.Label();
			this.label52 = new System.Windows.Forms.Label();
			this.label53 = new System.Windows.Forms.Label();
			this.label54 = new System.Windows.Forms.Label();
			this.label55 = new System.Windows.Forms.Label();
			this.label56 = new System.Windows.Forms.Label();
			this.label57 = new System.Windows.Forms.Label();
			this.label58 = new System.Windows.Forms.Label();
			this.label59 = new System.Windows.Forms.Label();
			this.label60 = new System.Windows.Forms.Label();
			this.label61 = new System.Windows.Forms.Label();
			this.label62 = new System.Windows.Forms.Label();
			this.label63 = new System.Windows.Forms.Label();
			this.label64 = new System.Windows.Forms.Label();
			this.label65 = new System.Windows.Forms.Label();
			this.label66 = new System.Windows.Forms.Label();
			this.label67 = new System.Windows.Forms.Label();
			this.btnNext = new System.Windows.Forms.Button();
			this.ClockPulse = new System.Windows.Forms.PictureBox();
			this.panel1 = new System.Windows.Forms.Panel();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.F = new System.Windows.Forms.GroupBox();
			this.label1 = new System.Windows.Forms.Label();
			this.groupBox1.SuspendLayout();
			this.F.SuspendLayout();
			this.SuspendLayout();
			// 
			// btnConfig
			// 
			this.btnConfig.Location = new System.Drawing.Point(200, 456);
			this.btnConfig.Name = "btnConfig";
			this.btnConfig.Size = new System.Drawing.Size(104, 24);
			this.btnConfig.TabIndex = 1;
			this.btnConfig.Text = "Configure";
			this.btnConfig.Click += new System.EventHandler(this.button1_Click);
			// 
			// btnStart
			// 
			this.btnStart.Location = new System.Drawing.Point(56, 456);
			this.btnStart.Name = "btnStart";
			this.btnStart.Size = new System.Drawing.Size(104, 23);
			this.btnStart.TabIndex = 72;
			this.btnStart.Text = "Open File";
			this.btnStart.Click += new System.EventHandler(this.btnStart_Click_1);
			// 
			// lvInstStatus
			// 
			this.lvInstStatus.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						   this.OpCode,
																						   this.i,
																						   this.j,
																						   this.k,
																						   this.Issue,
																						   this.ReadOperands,
																						   this.Execution,
																						   this.WriteResult});
			this.lvInstStatus.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lvInstStatus.GridLines = true;
			this.lvInstStatus.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
			this.lvInstStatus.Location = new System.Drawing.Point(6, 22);
			this.lvInstStatus.Name = "lvInstStatus";
			this.lvInstStatus.Size = new System.Drawing.Size(499, 160);
			this.lvInstStatus.TabIndex = 3;
			this.lvInstStatus.View = System.Windows.Forms.View.Details;
			// 
			// OpCode
			// 
			this.OpCode.Text = "OpCode";
			this.OpCode.Width = 51;
			// 
			// i
			// 
			this.i.Text = "i";
			this.i.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.i.Width = 35;
			// 
			// j
			// 
			this.j.Text = "j";
			this.j.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.j.Width = 31;
			// 
			// k
			// 
			this.k.Text = "k";
			this.k.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.k.Width = 33;
			// 
			// Issue
			// 
			this.Issue.Text = "Issue";
			this.Issue.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.Issue.Width = 45;
			// 
			// ReadOperands
			// 
			this.ReadOperands.Text = "Read Operands";
			this.ReadOperands.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.ReadOperands.Width = 92;
			// 
			// Execution
			// 
			this.Execution.Text = "Execution Complete";
			this.Execution.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.Execution.Width = 114;
			// 
			// WriteResult
			// 
			this.WriteResult.Text = "Write Result";
			this.WriteResult.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.WriteResult.Width = 89;
			// 
			// lvFUStatus
			// 
			this.lvFUStatus.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						 this.FunctionalUnit,
																						 this.Busy,
																						 this.Op,
																						 this.Fi,
																						 this.Fj,
																						 this.Fk,
																						 this.Qj,
																						 this.Qk,
																						 this.Rj,
																						 this.Rk});
			this.lvFUStatus.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lvFUStatus.GridLines = true;
			this.lvFUStatus.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
			listViewItem1.Tag = "Integer";
			listViewItem2.Tag = "Mult1";
			listViewItem3.Tag = "Mult2";
			listViewItem4.Tag = "Add";
			listViewItem5.Tag = "Divide";
			this.lvFUStatus.Items.AddRange(new System.Windows.Forms.ListViewItem[] {
																					   listViewItem1,
																					   listViewItem2,
																					   listViewItem3,
																					   listViewItem4,
																					   listViewItem5});
			this.lvFUStatus.Location = new System.Drawing.Point(8, 24);
			this.lvFUStatus.MultiSelect = false;
			this.lvFUStatus.Name = "lvFUStatus";
			this.lvFUStatus.Scrollable = false;
			this.lvFUStatus.Size = new System.Drawing.Size(496, 112);
			this.lvFUStatus.TabIndex = 6;
			this.lvFUStatus.View = System.Windows.Forms.View.Details;
			// 
			// FunctionalUnit
			// 
			this.FunctionalUnit.Text = "Functional Unit";
			this.FunctionalUnit.Width = 88;
			// 
			// Busy
			// 
			this.Busy.Text = "Busy";
			this.Busy.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.Busy.Width = 41;
			// 
			// Op
			// 
			this.Op.Text = "Op";
			this.Op.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.Op.Width = 47;
			// 
			// Fi
			// 
			this.Fi.Text = "Fi";
			this.Fi.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.Fi.Width = 33;
			// 
			// Fj
			// 
			this.Fj.Text = "Fj";
			this.Fj.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.Fj.Width = 37;
			// 
			// Fk
			// 
			this.Fk.Text = "Fk";
			this.Fk.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.Fk.Width = 41;
			// 
			// Qj
			// 
			this.Qj.Text = "Qj";
			this.Qj.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.Qj.Width = 54;
			// 
			// Qk
			// 
			this.Qk.Text = "Qk";
			this.Qk.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.Qk.Width = 58;
			// 
			// Rj
			// 
			this.Rj.Text = "Rj";
			this.Rj.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.Rj.Width = 48;
			// 
			// Rk
			// 
			this.Rk.Text = "Rk";
			this.Rk.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(560, 48);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(24, 16);
			this.label4.TabIndex = 8;
			this.label4.Text = "F0";
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(560, 72);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(24, 16);
			this.label5.TabIndex = 9;
			this.label5.Text = "F1";
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(560, 120);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(24, 16);
			this.label6.TabIndex = 11;
			this.label6.Text = "F3";
			// 
			// label7
			// 
			this.label7.Location = new System.Drawing.Point(560, 96);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(24, 16);
			this.label7.TabIndex = 10;
			this.label7.Text = "F2";
			// 
			// label8
			// 
			this.label8.Location = new System.Drawing.Point(560, 160);
			this.label8.Name = "label8";
			this.label8.Size = new System.Drawing.Size(24, 16);
			this.label8.TabIndex = 13;
			this.label8.Text = "F5";
			// 
			// label9
			// 
			this.label9.Location = new System.Drawing.Point(560, 140);
			this.label9.Name = "label9";
			this.label9.Size = new System.Drawing.Size(24, 16);
			this.label9.TabIndex = 12;
			this.label9.Text = "F4";
			// 
			// label10
			// 
			this.label10.Location = new System.Drawing.Point(560, 208);
			this.label10.Name = "label10";
			this.label10.Size = new System.Drawing.Size(24, 16);
			this.label10.TabIndex = 15;
			this.label10.Text = "F7";
			// 
			// label11
			// 
			this.label11.Location = new System.Drawing.Point(560, 184);
			this.label11.Name = "label11";
			this.label11.Size = new System.Drawing.Size(24, 16);
			this.label11.TabIndex = 14;
			this.label11.Text = "F6";
			// 
			// label12
			// 
			this.label12.Location = new System.Drawing.Point(560, 392);
			this.label12.Name = "label12";
			this.label12.Size = new System.Drawing.Size(24, 17);
			this.label12.TabIndex = 23;
			this.label12.Text = "F15";
			// 
			// label13
			// 
			this.label13.Location = new System.Drawing.Point(560, 368);
			this.label13.Name = "label13";
			this.label13.Size = new System.Drawing.Size(24, 17);
			this.label13.TabIndex = 22;
			this.label13.Text = "F14";
			// 
			// label14
			// 
			this.label14.Location = new System.Drawing.Point(560, 344);
			this.label14.Name = "label14";
			this.label14.Size = new System.Drawing.Size(24, 16);
			this.label14.TabIndex = 21;
			this.label14.Text = "F13";
			// 
			// label15
			// 
			this.label15.Location = new System.Drawing.Point(560, 326);
			this.label15.Name = "label15";
			this.label15.Size = new System.Drawing.Size(24, 16);
			this.label15.TabIndex = 20;
			this.label15.Text = "F12";
			// 
			// label16
			// 
			this.label16.Location = new System.Drawing.Point(560, 304);
			this.label16.Name = "label16";
			this.label16.Size = new System.Drawing.Size(24, 16);
			this.label16.TabIndex = 19;
			this.label16.Text = "F11";
			// 
			// label17
			// 
			this.label17.Location = new System.Drawing.Point(560, 280);
			this.label17.Name = "label17";
			this.label17.Size = new System.Drawing.Size(24, 16);
			this.label17.TabIndex = 18;
			this.label17.Text = "F10";
			// 
			// label18
			// 
			this.label18.Location = new System.Drawing.Point(560, 256);
			this.label18.Name = "label18";
			this.label18.Size = new System.Drawing.Size(24, 16);
			this.label18.TabIndex = 17;
			this.label18.Text = "F9";
			// 
			// label19
			// 
			this.label19.Location = new System.Drawing.Point(560, 232);
			this.label19.Name = "label19";
			this.label19.Size = new System.Drawing.Size(24, 16);
			this.label19.TabIndex = 16;
			this.label19.Text = "F8";
			// 
			// label20
			// 
			this.label20.Location = new System.Drawing.Point(672, 392);
			this.label20.Name = "label20";
			this.label20.Size = new System.Drawing.Size(24, 17);
			this.label20.TabIndex = 39;
			this.label20.Text = "F31";
			// 
			// label21
			// 
			this.label21.Location = new System.Drawing.Point(672, 368);
			this.label21.Name = "label21";
			this.label21.Size = new System.Drawing.Size(24, 17);
			this.label21.TabIndex = 38;
			this.label21.Text = "F30";
			// 
			// label22
			// 
			this.label22.Location = new System.Drawing.Point(672, 344);
			this.label22.Name = "label22";
			this.label22.Size = new System.Drawing.Size(24, 16);
			this.label22.TabIndex = 37;
			this.label22.Text = "F29";
			// 
			// label23
			// 
			this.label23.Location = new System.Drawing.Point(672, 326);
			this.label23.Name = "label23";
			this.label23.Size = new System.Drawing.Size(24, 16);
			this.label23.TabIndex = 36;
			this.label23.Text = "F28";
			// 
			// label24
			// 
			this.label24.Location = new System.Drawing.Point(672, 280);
			this.label24.Name = "label24";
			this.label24.Size = new System.Drawing.Size(24, 16);
			this.label24.TabIndex = 35;
			this.label24.Text = "F27";
			// 
			// label25
			// 
			this.label25.Location = new System.Drawing.Point(672, 304);
			this.label25.Name = "label25";
			this.label25.Size = new System.Drawing.Size(24, 16);
			this.label25.TabIndex = 34;
			this.label25.Text = "F26";
			// 
			// label26
			// 
			this.label26.Location = new System.Drawing.Point(672, 256);
			this.label26.Name = "label26";
			this.label26.Size = new System.Drawing.Size(24, 16);
			this.label26.TabIndex = 33;
			this.label26.Text = "F25";
			// 
			// label27
			// 
			this.label27.Location = new System.Drawing.Point(672, 232);
			this.label27.Name = "label27";
			this.label27.Size = new System.Drawing.Size(24, 16);
			this.label27.TabIndex = 32;
			this.label27.Text = "F24";
			// 
			// label28
			// 
			this.label28.Location = new System.Drawing.Point(672, 208);
			this.label28.Name = "label28";
			this.label28.Size = new System.Drawing.Size(24, 16);
			this.label28.TabIndex = 31;
			this.label28.Text = "F23";
			// 
			// label29
			// 
			this.label29.Location = new System.Drawing.Point(672, 184);
			this.label29.Name = "label29";
			this.label29.Size = new System.Drawing.Size(24, 16);
			this.label29.TabIndex = 30;
			this.label29.Text = "F22";
			// 
			// label30
			// 
			this.label30.Location = new System.Drawing.Point(672, 160);
			this.label30.Name = "label30";
			this.label30.Size = new System.Drawing.Size(24, 16);
			this.label30.TabIndex = 29;
			this.label30.Text = "F21";
			// 
			// label31
			// 
			this.label31.Location = new System.Drawing.Point(672, 140);
			this.label31.Name = "label31";
			this.label31.Size = new System.Drawing.Size(24, 16);
			this.label31.TabIndex = 28;
			this.label31.Text = "F20";
			// 
			// label32
			// 
			this.label32.Location = new System.Drawing.Point(672, 120);
			this.label32.Name = "label32";
			this.label32.Size = new System.Drawing.Size(24, 16);
			this.label32.TabIndex = 27;
			this.label32.Text = "F19";
			// 
			// label33
			// 
			this.label33.Location = new System.Drawing.Point(672, 96);
			this.label33.Name = "label33";
			this.label33.Size = new System.Drawing.Size(24, 16);
			this.label33.TabIndex = 26;
			this.label33.Text = "F18";
			// 
			// label34
			// 
			this.label34.Location = new System.Drawing.Point(672, 72);
			this.label34.Name = "label34";
			this.label34.Size = new System.Drawing.Size(24, 16);
			this.label34.TabIndex = 25;
			this.label34.Text = "F17";
			// 
			// label35
			// 
			this.label35.Location = new System.Drawing.Point(672, 48);
			this.label35.Name = "label35";
			this.label35.Size = new System.Drawing.Size(24, 16);
			this.label35.TabIndex = 24;
			this.label35.Text = "F16";
			// 
			// label36
			// 
			this.label36.Location = new System.Drawing.Point(600, 232);
			this.label36.Name = "label36";
			this.label36.Size = new System.Drawing.Size(48, 16);
			this.label36.TabIndex = 48;
			this.label36.Text = "F8";
			// 
			// label37
			// 
			this.label37.Location = new System.Drawing.Point(600, 208);
			this.label37.Name = "label37";
			this.label37.Size = new System.Drawing.Size(48, 16);
			this.label37.TabIndex = 47;
			this.label37.Text = "F7";
			// 
			// label38
			// 
			this.label38.Location = new System.Drawing.Point(600, 184);
			this.label38.Name = "label38";
			this.label38.Size = new System.Drawing.Size(48, 16);
			this.label38.TabIndex = 46;
			this.label38.Text = "F6";
			// 
			// label39
			// 
			this.label39.Location = new System.Drawing.Point(600, 160);
			this.label39.Name = "label39";
			this.label39.Size = new System.Drawing.Size(48, 16);
			this.label39.TabIndex = 45;
			this.label39.Text = "F5";
			// 
			// label40
			// 
			this.label40.Location = new System.Drawing.Point(600, 140);
			this.label40.Name = "label40";
			this.label40.Size = new System.Drawing.Size(48, 16);
			this.label40.TabIndex = 44;
			this.label40.Text = "F4";
			// 
			// label41
			// 
			this.label41.Location = new System.Drawing.Point(600, 120);
			this.label41.Name = "label41";
			this.label41.Size = new System.Drawing.Size(48, 16);
			this.label41.TabIndex = 43;
			this.label41.Text = "F3";
			// 
			// label42
			// 
			this.label42.Location = new System.Drawing.Point(600, 96);
			this.label42.Name = "label42";
			this.label42.Size = new System.Drawing.Size(48, 16);
			this.label42.TabIndex = 42;
			this.label42.Text = "F2";
			// 
			// label43
			// 
			this.label43.Location = new System.Drawing.Point(600, 72);
			this.label43.Name = "label43";
			this.label43.Size = new System.Drawing.Size(48, 16);
			this.label43.TabIndex = 41;
			this.label43.Text = "F1";
			// 
			// label44
			// 
			this.label44.Location = new System.Drawing.Point(600, 48);
			this.label44.Name = "label44";
			this.label44.Size = new System.Drawing.Size(48, 16);
			this.label44.TabIndex = 40;
			this.label44.Text = "F0";
			// 
			// label45
			// 
			this.label45.Location = new System.Drawing.Point(600, 392);
			this.label45.Name = "label45";
			this.label45.Size = new System.Drawing.Size(48, 17);
			this.label45.TabIndex = 55;
			this.label45.Text = "F15";
			// 
			// label46
			// 
			this.label46.Location = new System.Drawing.Point(600, 368);
			this.label46.Name = "label46";
			this.label46.Size = new System.Drawing.Size(48, 17);
			this.label46.TabIndex = 54;
			this.label46.Text = "F14";
			// 
			// label47
			// 
			this.label47.Location = new System.Drawing.Point(600, 344);
			this.label47.Name = "label47";
			this.label47.Size = new System.Drawing.Size(48, 16);
			this.label47.TabIndex = 53;
			this.label47.Text = "F13";
			// 
			// label48
			// 
			this.label48.Location = new System.Drawing.Point(600, 326);
			this.label48.Name = "label48";
			this.label48.Size = new System.Drawing.Size(48, 16);
			this.label48.TabIndex = 52;
			this.label48.Text = "F12";
			// 
			// label49
			// 
			this.label49.Location = new System.Drawing.Point(600, 304);
			this.label49.Name = "label49";
			this.label49.Size = new System.Drawing.Size(48, 16);
			this.label49.TabIndex = 51;
			this.label49.Text = "F11";
			// 
			// label50
			// 
			this.label50.Location = new System.Drawing.Point(600, 280);
			this.label50.Name = "label50";
			this.label50.Size = new System.Drawing.Size(48, 16);
			this.label50.TabIndex = 50;
			this.label50.Text = "F10";
			// 
			// label51
			// 
			this.label51.Location = new System.Drawing.Point(600, 256);
			this.label51.Name = "label51";
			this.label51.Size = new System.Drawing.Size(48, 16);
			this.label51.TabIndex = 49;
			this.label51.Text = "F9";
			// 
			// label52
			// 
			this.label52.Location = new System.Drawing.Point(712, 232);
			this.label52.Name = "label52";
			this.label52.Size = new System.Drawing.Size(48, 16);
			this.label52.TabIndex = 64;
			this.label52.Text = "F24";
			// 
			// label53
			// 
			this.label53.Location = new System.Drawing.Point(712, 208);
			this.label53.Name = "label53";
			this.label53.Size = new System.Drawing.Size(48, 16);
			this.label53.TabIndex = 63;
			this.label53.Text = "F23";
			// 
			// label54
			// 
			this.label54.Location = new System.Drawing.Point(712, 184);
			this.label54.Name = "label54";
			this.label54.Size = new System.Drawing.Size(48, 16);
			this.label54.TabIndex = 62;
			this.label54.Text = "F22";
			// 
			// label55
			// 
			this.label55.Location = new System.Drawing.Point(712, 160);
			this.label55.Name = "label55";
			this.label55.Size = new System.Drawing.Size(48, 16);
			this.label55.TabIndex = 61;
			this.label55.Text = "F21";
			// 
			// label56
			// 
			this.label56.Location = new System.Drawing.Point(712, 140);
			this.label56.Name = "label56";
			this.label56.Size = new System.Drawing.Size(48, 16);
			this.label56.TabIndex = 60;
			this.label56.Text = "F20";
			// 
			// label57
			// 
			this.label57.Location = new System.Drawing.Point(712, 120);
			this.label57.Name = "label57";
			this.label57.Size = new System.Drawing.Size(48, 16);
			this.label57.TabIndex = 59;
			this.label57.Text = "F19";
			// 
			// label58
			// 
			this.label58.Location = new System.Drawing.Point(712, 96);
			this.label58.Name = "label58";
			this.label58.Size = new System.Drawing.Size(48, 16);
			this.label58.TabIndex = 58;
			this.label58.Text = "F18";
			// 
			// label59
			// 
			this.label59.Location = new System.Drawing.Point(712, 72);
			this.label59.Name = "label59";
			this.label59.Size = new System.Drawing.Size(48, 16);
			this.label59.TabIndex = 57;
			this.label59.Text = "F17";
			// 
			// label60
			// 
			this.label60.Location = new System.Drawing.Point(712, 48);
			this.label60.Name = "label60";
			this.label60.Size = new System.Drawing.Size(48, 16);
			this.label60.TabIndex = 56;
			this.label60.Text = "F16";
			// 
			// label61
			// 
			this.label61.Location = new System.Drawing.Point(712, 392);
			this.label61.Name = "label61";
			this.label61.Size = new System.Drawing.Size(48, 17);
			this.label61.TabIndex = 71;
			this.label61.Text = "F31";
			// 
			// label62
			// 
			this.label62.Location = new System.Drawing.Point(712, 368);
			this.label62.Name = "label62";
			this.label62.Size = new System.Drawing.Size(48, 17);
			this.label62.TabIndex = 70;
			this.label62.Text = "F30";
			// 
			// label63
			// 
			this.label63.Location = new System.Drawing.Point(712, 344);
			this.label63.Name = "label63";
			this.label63.Size = new System.Drawing.Size(48, 16);
			this.label63.TabIndex = 69;
			this.label63.Text = "F29";
			// 
			// label64
			// 
			this.label64.Location = new System.Drawing.Point(712, 326);
			this.label64.Name = "label64";
			this.label64.Size = new System.Drawing.Size(48, 16);
			this.label64.TabIndex = 68;
			this.label64.Text = "F28";
			// 
			// label65
			// 
			this.label65.Location = new System.Drawing.Point(712, 280);
			this.label65.Name = "label65";
			this.label65.Size = new System.Drawing.Size(48, 16);
			this.label65.TabIndex = 67;
			this.label65.Text = "F27";
			// 
			// label66
			// 
			this.label66.Location = new System.Drawing.Point(712, 304);
			this.label66.Name = "label66";
			this.label66.Size = new System.Drawing.Size(48, 16);
			this.label66.TabIndex = 66;
			this.label66.Text = "F26";
			// 
			// label67
			// 
			this.label67.Location = new System.Drawing.Point(712, 256);
			this.label67.Name = "label67";
			this.label67.Size = new System.Drawing.Size(48, 16);
			this.label67.TabIndex = 65;
			this.label67.Text = "F25";
			// 
			// btnNext
			// 
			this.btnNext.Location = new System.Drawing.Point(272, 416);
			this.btnNext.Name = "btnNext";
			this.btnNext.Size = new System.Drawing.Size(88, 24);
			this.btnNext.TabIndex = 73;
			this.btnNext.Text = "Next Cycle";
			this.btnNext.Click += new System.EventHandler(this.btnNext_Click);
			// 
			// ClockPulse
			// 
			this.ClockPulse.BackColor = System.Drawing.Color.Black;
			this.ClockPulse.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.ClockPulse.Location = new System.Drawing.Point(408, 416);
			this.ClockPulse.Name = "ClockPulse";
			this.ClockPulse.Size = new System.Drawing.Size(104, 50);
			this.ClockPulse.TabIndex = 76;
			this.ClockPulse.TabStop = false;
			// 
			// panel1
			// 
			this.panel1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.panel1.Location = new System.Drawing.Point(552, 37);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(216, 376);
			this.panel1.TabIndex = 77;
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.lvInstStatus);
			this.groupBox1.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.groupBox1.Location = new System.Drawing.Point(8, 16);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(512, 192);
			this.groupBox1.TabIndex = 78;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "INSTRUCTION STATUS";
			// 
			// F
			// 
			this.F.Controls.Add(this.lvFUStatus);
			this.F.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.F.Location = new System.Drawing.Point(8, 232);
			this.F.Name = "F";
			this.F.Size = new System.Drawing.Size(512, 152);
			this.F.TabIndex = 79;
			this.F.TabStop = false;
			this.F.Text = "FUNCTIONAL UNIT STATUS";
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(592, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(128, 16);
			this.label1.TabIndex = 80;
			this.label1.Text = "REGISTERS STATUS";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(786, 499);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.F);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.ClockPulse);
			this.Controls.Add(this.btnNext);
			this.Controls.Add(this.label61);
			this.Controls.Add(this.label62);
			this.Controls.Add(this.label63);
			this.Controls.Add(this.label64);
			this.Controls.Add(this.label65);
			this.Controls.Add(this.label66);
			this.Controls.Add(this.label67);
			this.Controls.Add(this.label52);
			this.Controls.Add(this.label53);
			this.Controls.Add(this.label54);
			this.Controls.Add(this.label55);
			this.Controls.Add(this.label56);
			this.Controls.Add(this.label57);
			this.Controls.Add(this.label58);
			this.Controls.Add(this.label59);
			this.Controls.Add(this.label60);
			this.Controls.Add(this.label45);
			this.Controls.Add(this.label46);
			this.Controls.Add(this.label47);
			this.Controls.Add(this.label48);
			this.Controls.Add(this.label49);
			this.Controls.Add(this.label50);
			this.Controls.Add(this.label51);
			this.Controls.Add(this.label36);
			this.Controls.Add(this.label37);
			this.Controls.Add(this.label38);
			this.Controls.Add(this.label39);
			this.Controls.Add(this.label40);
			this.Controls.Add(this.label41);
			this.Controls.Add(this.label42);
			this.Controls.Add(this.label43);
			this.Controls.Add(this.label44);
			this.Controls.Add(this.label20);
			this.Controls.Add(this.label21);
			this.Controls.Add(this.label22);
			this.Controls.Add(this.label23);
			this.Controls.Add(this.label24);
			this.Controls.Add(this.label25);
			this.Controls.Add(this.label26);
			this.Controls.Add(this.label27);
			this.Controls.Add(this.label28);
			this.Controls.Add(this.label29);
			this.Controls.Add(this.label30);
			this.Controls.Add(this.label31);
			this.Controls.Add(this.label32);
			this.Controls.Add(this.label33);
			this.Controls.Add(this.label34);
			this.Controls.Add(this.label35);
			this.Controls.Add(this.label12);
			this.Controls.Add(this.label13);
			this.Controls.Add(this.label14);
			this.Controls.Add(this.label15);
			this.Controls.Add(this.label16);
			this.Controls.Add(this.label17);
			this.Controls.Add(this.label18);
			this.Controls.Add(this.label19);
			this.Controls.Add(this.label10);
			this.Controls.Add(this.label11);
			this.Controls.Add(this.label8);
			this.Controls.Add(this.label9);
			this.Controls.Add(this.label6);
			this.Controls.Add(this.label7);
			this.Controls.Add(this.label5);
			this.Controls.Add(this.label4);
			this.Controls.Add(this.btnStart);
			this.Controls.Add(this.btnConfig);
			this.Controls.Add(this.panel1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.Name = "Form1";
			this.Text = "ScoreBoard";
			this.Load += new System.EventHandler(this.Form1_Load);
			this.groupBox1.ResumeLayout(false);
			this.F.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		//[STAThread]
		static void Main() 
		{
			ScoreBoard MyScoreBoard = new ScoreBoard();
			Application.Run(new Form1(MyScoreBoard));
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			SetupForm ConfigForm = new SetupForm(refScoreBoard);
			ConfigForm.ShowDialog();
		}


		private void Form1_Load(object sender, System.EventArgs e)
		{
			buttonType = ButtonType.OpenFile;
		}

		private void btnStart_Click_1(object sender, System.EventArgs e)
		{
			if( buttonType == ButtonType.OpenFile )
			{
				OpenFileDialog openFile = new OpenFileDialog();
				openFile.DefaultExt = "bin";
				// The Filter property requires a search string after the pipe ( | )
				openFile.Filter = "Binary File (*.bin)|*.bin";
				openFile.ShowDialog();
				if( openFile.FileNames.Length == 0 )
					return;					
				
				Parser parser = new Parser();
				refScoreBoard.InstList = parser.Parse(openFile.FileName);
				refScoreBoard.InstList.RemoveAt(refScoreBoard.InstList.Count-1);
				if( refScoreBoard.InstList == null )
					MessageBox.Show("Invalid Image", "Error", 
						MessageBoxButtons.OK, MessageBoxIcon.Error);
				
				buttonType = ButtonType.Start;
				btnStart.Text = "Start";
				UpdateRequestHandler(this, new RequestEventArgs(RequestType.ChangeInstructionStatus));
				return;
			}
			else if( buttonType == ButtonType.Start )
			{
				btnConfig.Enabled = false;
				buttonType = ButtonType.Stop;
				btnStart.Text = "Stop";
				if(!(refScoreBoard.AutomaticExecutionMode))
				{
					btnNext.Show();
					refScoreBoard.scheduler.UpdateCycle();
				}
				else
				{
					timer.Interval = refScoreBoard.ExecutionDelay * 500; 	
					timer.Enabled = true;
					timer.Tick += new EventHandler(TimerOnTick);
					timer.Start();
				}
				return;
			}	
			else if( buttonType == ButtonType.Stop )
			{
				btnConfig.Enabled = true;
				btnNext.Hide();
				buttonType = ButtonType.Start;
				btnStart.Text = "ReStart";
				refScoreBoard.Flush();
				timer.Tick -= new EventHandler(TimerOnTick);
				timer.Stop();
				return;
			}

		}

		protected void UpdateRequestHandler(object sender, RequestEventArgs e)
		{
			if(e.Request == RequestType.ChangeInstructionStatus)
			{
				if( refScoreBoard.InstList.Count == 0 )
					return;
				ListView.ListViewItemCollection LVItems = lvInstStatus.Items;
				
				LVItems.Clear();
				foreach(Instruction inst in refScoreBoard.InstList)
				{
					ListViewItem item = new ListViewItem();
					LVItems.Add(item);
					ListViewItem.ListViewSubItemCollection LVSubItems = item.SubItems;
					for( int i=0; i<8; i++ )
					{
						ListViewItem.ListViewSubItem SubItem = new ListViewItem.ListViewSubItem(item, inst[i].ToString());
						if(i==0)
							LVSubItems[0] = SubItem;
						else
							LVSubItems.Add(SubItem);
					}
				} 
			}
			else if(e.Request == RequestType.ChangeFunctionalUnitStatus)
			{		
				ListView.ListViewItemCollection LVItems = lvFUStatus.Items;
				ListViewItem.ListViewSubItem SubItem;
				
				for(int i=0; i<5; i++)
				{
					for(int j=0; j<10; j++)
					{
						FU fu = ((FU)(refScoreBoard.FunctionalUnit[i]));
						String ItemString = fu[j].ToString();
						SubItem = new ListViewItem.ListViewSubItem(LVItems[i],ItemString);
						ListViewItem.ListViewSubItemCollection LVSubItems = LVItems[i].SubItems;
						LVSubItems[j] = SubItem;
					}
				}
			}
			else if(e.Request == RequestType.ChangeRegisterStatus)
				for(int i=0; i<32; i++)
				{
					FR fr = ((FR)(refScoreBoard.RegisterSet[i]));
					((Label)(RegControl[i])).Text = fr.Reg;
				}
	
			else if(e.Request == RequestType.ChangeClockCycle)
			{
				ClockPulse.Invalidate();				
			}
		}

		private void btnNext_Click(object sender, System.EventArgs e)
		{
			refScoreBoard.scheduler.UpdateCycle();
		}

		public void TimerOnTick(object ob, EventArgs ea)
		{
			if( !(refScoreBoard.scheduler.UpdateCycle()) )
			{
				timer.Stop();
				timer.Enabled = false;
				btnStart.Text = "Restart";
				buttonType = ButtonType.Start;
			}
		}

		private void Clock_Paint(object sender, PaintEventArgs e)
		{
			SevenSegmentDisplay ssd = new SevenSegmentDisplay(e.Graphics);

			string str = refScoreBoard.clock.Counter.ToString();

			SizeF sizef = ssd.MeasureString( str, ClockPulse.Font );
			float fScale = Math.Min( ClockPulse.ClientSize.Width / sizef.Width, 
									 ClockPulse.ClientSize.Height / sizef.Height );
			Font font  = new Font(Font.FontFamily, fScale * Font.SizeInPoints);

			sizef = ssd.MeasureString(str, font);

			ssd.DrawString(str, font, Brushes.Red, 
					(ClockPulse.ClientSize.Width - sizef.Width) - 12,
					(ClockPulse.ClientSize.Height - sizef.Height) / 2 );
		}		
	}
}
