using System;

namespace ScoreBoard
{
	// USER DEFINED TYPE FOR SHOWING THE STAGES OF THE INSTRUCTION
	public enum Stage 
	{
		Issue, ReadOperands,Execute, WriteResult 
	}
	
	/// <summary>
	/// INSTRUCTION CLASS : CONTAINS ALL THE INFORMATION ABOUT THE INSTRUCTION THAT IS EXECUTED
	/// </summary>
	public class Instruction
	{
		public string OPCode;					// FUNCTION TO BE PERFORMED
		public string Dest;						// DESINATION REGISTER
		public string Src1;						// FIRST SOURCE REGISTER
		public string Src2;						// SECOND SOURCE REGISTER

		// THESE ARE USED TO STORE THE TIME AT WHICH THE DIFFERENT INSTRUCTION 
		// COMPLETES THE PROCESSING OF THE SPECIFIED STAGE
		public int Issue;						
		public int ReadOP;
		public int ExeComp;
		public int WriteResult;
		
		// CURRENT CONTROL STAGES
		public Stage currentStage;			
		public bool hasCurrentStageCompleted;
		public int ExecutionCounter;
		public FU OccupiedFU;
		public int InstructionPosition;


		// CONSTRUCTOR
		public Instruction()
		{
			OPCode = "";
			Dest = "";
			Src1 = "";
			Src2 = "";
			currentStage = Stage.Issue;					// FIRST STAGE OF THE INSTRUCTION
			InstructionPosition = 0;
			hasCurrentStageCompleted = false;
		}

		// OVERLOADED []
		public object this [int i]
		{
			// GETTER FUNCTION
			get
			{
				switch(i)
				{
					case 0 :
						return (OPCode);
					case 1:
						return (Dest);
					case 2:
						return (Src1);
					case 3:
						return (Src2);
					case 4:
						return (Issue);
					case 5:
						return(ReadOP);
					case 6:
						return(ExeComp);
					case 7:
						return(WriteResult);
					default :
						throw new IndexOutOfRangeException("Attempt to retreive vector element " + i);
				}
			}
		
			// SETTER FUNCTION
			set
			{
				switch(i)
				{
					case 0 :
						OPCode = (string)value;
						break;
						
					case 1:
						Dest = (string)value ;
						break;
						
					case 2:
						Src1 = (string)value ;
						break;
						
					case 3:
						Src2 = (string)value ;
						break;
						
					case 4:
						Issue = (int)value;
						break;
						
					case 5:
						ReadOP = (int)value ;
						break;
						
					case 6:
						ExeComp = (int)value ;
						break;
						
					case 7:
						WriteResult = (int)value;
						break;
						
					default :
						throw new IndexOutOfRangeException("Attempt to Set vector element " + i);
				}
			}		
		}

		public void FlushStatus()
		{
			Issue = 0;
			ReadOP = 0;
			ExeComp = 0;
			WriteResult = 0;
		}


	}
}



