using System;
using System.IO;
using System.Collections;
using System.Windows.Forms;

namespace ScoreBoard
{
	/// <summary>
	/// PARSER CLASS : THIS CLASS IS USED TO READ THE BINARY FILE AND SAVE THE INSTRUCTIONS IN-ORDER
	/// </summary>
	public class Parser
	{
		public string[] Queue;					// THIS IS USED TO STORE ALL THE INTRUCTIONS
												// IN SEQUENCE
		ArrayList AL = new ArrayList();			// THIS ARRAY LIST IS USED TO STORE THE INSTRUCTIONS

		// CONSTRUCTOR
		public Parser()
		{
		}	
	
		// THIS FUNCTION RETURNS THE ARRAY LIST OF THE INSTRUCTIONS
		public ArrayList Parse(string MainFileName)
		{
		
			StreamReader sr = File.OpenText(MainFileName);		
			String input;
			int temp = 0;
			string Q = "";
			Instruction Obj1 = 	 new Instruction();
		
			// THIS LOOP WHILE STORE THE COMPLETE FILE IN A STRING(QUEUE)
			// THIS WILL READ THE COMPLETE LINE, NOT IDENTIFYING THE LINE WORD BY WORD
			// BUT THE READLINE WILL READ EACH AS BYTE BY BYTE
			while ((input=sr.ReadLine())!=null) 
			{			
				++ temp;				
				Q = Q + (input)+ " ";					// THIS STRING WILL CONTAIN THE COMPLETE FILE DATA
				int LineLength = Q.Length;				
			}
			sr.Close();									// CLOSES THE READER OBJECT
		
			string[] mytest = null;
			mytest = Q.Split();							// THIS FUCTION WILL IDENTIFY THE SUBSTRING IN Q
			int counter1 = 0;		
			
			foreach (string c in mytest)
			{   
				if( counter1%4==0)						// AS ALL THE INSTRUCTIONS ARE 4 WORD LONG
				{										// SO AFTER THE INTEVAL OF 4 , NEW INSTRUCTION IS CREATED AND
					Obj1 = new Instruction();			// ALL THE DES, SOURCE REGISTERS ARE ASSOCIATED WITH THE INSTRUCTION
					Obj1.InstructionPosition = counter1/4;
				}

				switch (counter1%4)
				{    
					case 0:								// IF THE RESULT IS 0, THEN IT MEANS THAT THE 
						Obj1.OPCode = c;				// STRING CONTAINS THE OPCODE OF THE INSTRUCTION
						Obj1.OPCode.ToUpper();			// CONVERTED TO UPPER CASE FOR THE STRING MATCHING BELOW

						// HERE, AFTER THE IDENTIFICATION OF THE INSTRCUTION
						// THE NUMBER OF EXECUTION STAGES ARE IDENTIFIED

						if( Obj1.OPCode == "LD" )
							Obj1.ExecutionCounter = 1;
						else if( Obj1.OPCode == "MUL" )
							Obj1.ExecutionCounter = 10;
						else if( Obj1.OPCode == "DIV" )
							Obj1.ExecutionCounter = 40;
						else if( Obj1.OPCode == "ADD" || 
							Obj1.OPCode == "SUB" )
							Obj1.ExecutionCounter = 2;
						break;

					case 1 :							// IN THIS CASE THE STRING IS THE DESTINATION 
					{									// REGISTER
						Obj1.Dest = c;
						Obj1.Dest.ToUpper();
						break;
					}
					case 2 :							// IN THIS CASE THE STRING IS THE FIRST SOURCE
					{									// REGISTER
						Obj1.Src1 = c;
						Obj1.Src1.ToUpper();
						break;
					}
					case 3:								// IN THIS CASE THE STRING IS THE SECOND SOURCE
					{									// REGISTER
						Obj1.Src2 = c;
						Obj1.Src2.ToUpper();
						break;
					}
					default :
					{						
						break;
					}
				}
				
				if( counter1%4==0)			// THE STARTING REFERENCE OF THE INSTRUCTION
					AL.Add(Obj1);			// IS STORED IN THE ARRAY LIST
               				
				counter1 ++;
			}

		return (AL)	;						// RETURNS THE ARRAY LIST
		}
	}
}
	

