using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace ScoreBoard
{
	/// <summary>
	/// Summary description for SetupForm.
	/// </summary>
	public class SetupForm : System.Windows.Forms.Form
	{
		private ScoreBoard refScoreBoard;
		
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.RadioButton btnExecAuto;
		private System.Windows.Forms.RadioButton btnExecUser;
		private System.Windows.Forms.ListBox lbDelay;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public SetupForm(ScoreBoard refSB)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			refScoreBoard = refSB;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.btnExecAuto = new System.Windows.Forms.RadioButton();
			this.btnExecUser = new System.Windows.Forms.RadioButton();
			this.lbDelay = new System.Windows.Forms.ListBox();
			this.button1 = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(32, 120);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(96, 24);
			this.label1.TabIndex = 0;
			this.label1.Text = "Delay (500 ms)";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 24);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(72, 16);
			this.label2.TabIndex = 1;
			this.label2.Text = "Execution";
			// 
			// btnExecAuto
			// 
			this.btnExecAuto.Location = new System.Drawing.Point(32, 48);
			this.btnExecAuto.Name = "btnExecAuto";
			this.btnExecAuto.Size = new System.Drawing.Size(112, 24);
			this.btnExecAuto.TabIndex = 2;
			this.btnExecAuto.Text = "Automatic Mode";
			this.btnExecAuto.CheckedChanged += new System.EventHandler(this.btnExecAuto_CheckedChanged);
			// 
			// btnExecUser
			// 
			this.btnExecUser.Location = new System.Drawing.Point(32, 80);
			this.btnExecUser.Name = "btnExecUser";
			this.btnExecUser.Size = new System.Drawing.Size(88, 24);
			this.btnExecUser.TabIndex = 3;
			this.btnExecUser.Text = "User Mode";
			this.btnExecUser.CheckedChanged += new System.EventHandler(this.btnExecUser_CheckedChanged);
			// 
			// lbDelay
			// 
			this.lbDelay.ItemHeight = 15;
			this.lbDelay.Items.AddRange(new object[] {
														 "1",
														 "2",
														 "3",
														 "4",
														 "5",
														 "6",
														 "7",
														 "8"});
			this.lbDelay.Location = new System.Drawing.Point(200, 120);
			this.lbDelay.Name = "lbDelay";
			this.lbDelay.Size = new System.Drawing.Size(48, 19);
			this.lbDelay.TabIndex = 4;
			this.lbDelay.SelectedIndexChanged += new System.EventHandler(this.lbDelay_SelectedIndexChanged);
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(104, 160);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(75, 32);
			this.button1.TabIndex = 5;
			this.button1.Text = "Done";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// SetupForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 14);
			this.ClientSize = new System.Drawing.Size(306, 208);
			this.ControlBox = false;
			this.Controls.Add(this.button1);
			this.Controls.Add(this.lbDelay);
			this.Controls.Add(this.btnExecUser);
			this.Controls.Add(this.btnExecAuto);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Font = new System.Drawing.Font("Microsoft Sans Serif", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "SetupForm";
			this.Text = "Configuration";
			this.Load += new System.EventHandler(this.SetupForm_Load);
			this.ResumeLayout(false);

		}
		#endregion

		private void button1_Click(object sender, System.EventArgs e)
		{
			refScoreBoard.AutomaticExecutionMode = btnExecAuto.Checked;
			refScoreBoard.ExecutionDelay = lbDelay.SelectedIndex+1;
			
			this.Close();
		}

		private void SetupForm_Load(object sender, System.EventArgs e)
		{
			if(refScoreBoard.AutomaticExecutionMode)
				btnExecAuto.Checked = true;
			else 
			{
				btnExecUser.Checked = true;
				lbDelay.Enabled = false;
			}
			lbDelay.SelectedIndex = refScoreBoard.ExecutionDelay-1;
		}

		private void btnExecAuto_CheckedChanged(object sender, System.EventArgs e)
		{
			lbDelay.Enabled = true;
			lbDelay.Focus();			
		}

		private void btnExecUser_CheckedChanged(object sender, System.EventArgs e)
		{
			lbDelay.Enabled = false;
		}

		private void lbDelay_SelectedIndexChanged(object sender, System.EventArgs e)
		{
		}

	}
}
