#define WIN32_LEAN_AND_MEAN

#include <windows.h>

void Write_Text(HWND hwnd, int x_position , int y_position)
{
	HDC hdc;
	
	hdc=GetDC(hwnd);

	TextOut(hdc,x_position,y_position,"ALI RAZA SHAIKH",15);

	ReleaseDC(hwnd,hdc);
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT message , WPARAM wParam , LPARAM lParam)
{	
	switch(message)
	{
		case WM_LBUTTONDOWN:
			MessageBox(hwnd,"Left Mouse Button is PRESSED","A MESSAGE",MB_OK);			
			DestroyWindow(hwnd);
			break;

		case WM_DESTROY:
			PostQuitMessage(0);			
			break;				
			
		default:
			return (DefWindowProc(hwnd,message,wParam,lParam));			
	}

	return 0;	
}

int WINAPI WinMain (HINSTANCE hInstance , HINSTANCE hPreviousInstance , LPSTR lpCmdLine , int nShowCmd)
{
	WNDCLASSEX windowClass;
	HWND hwnd;
	MSG msg;
	bool done;

	windowClass.cbSize=sizeof(WNDCLASSEX);
	windowClass.style=CS_HREDRAW | CS_VREDRAW;
	windowClass.lpfnWndProc=WndProc;
	windowClass.cbClsExtra=0;
	windowClass.cbWndExtra=0;
	windowClass.hInstance=hInstance;
	windowClass.hIcon=LoadIcon(NULL,IDI_APPLICATION);
	windowClass.hCursor=LoadCursor(NULL,IDC_UPARROW);
	windowClass.hbrBackground=(HBRUSH)GetStockObject(WHITE_BRUSH);
	windowClass.lpszMenuName=NULL;
	windowClass.lpszClassName="My Class";
	windowClass.hIconSm=LoadIcon(NULL,IDI_WINLOGO);

	if(!RegisterClassEx(&windowClass))
		return 0;

	hwnd = CreateWindowEx(NULL,
							"My Class",
							"A SIMPLE WINDOW",
							WS_OVERLAPPEDWINDOW |
							WS_VISIBLE |
							WS_SYSMENU, 
							200,100,
							400,400,
							NULL,
							NULL,
							hInstance,
							NULL);

	if (!hwnd)
		return 0;

	done=false;

	Write_Text(hwnd,5,15);

	while(!done)
	{
		PeekMessage(&msg,hwnd,NULL,NULL,PM_REMOVE);

		if (msg.message == WM_QUIT)
		{
			done=true;
		}
		else
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return msg.wParam;
}

