/* 

This header file mathop.h is meant to help out in simple mathematical operations that might help you out in your programs.
Functions:-

1) The funcion prime(n) will give an output of one if the number n is prime and zero if n is not.
2) The function GCD(x,y) will give the greatest common denominator of x and y.
3) The function swap(x,y) will switch the values stored in variables x and y.
4) The functions qroot1(a,b,c) and qroot2(a,b,c) will return the value of the roots of the quadratic equation ax + by + c provided the 
   inputs are the co-efficients a, b, c.

*/


#ifndef MATHOP_H
#define MATHOP_H
int isprime(int n)
{
	int c=0, j;
	for (j=1; j<=n; j++ )
	{
		if (n%j==0)
		{
			c+=1;
		}
	}
	if (c<=2)
		return 1;
	else
		return 0;
}

int gcd(int n1, int n2)
{
	int l,s,f;
	if (n1>=n2)
	{
		l=n1;
		s=n2;
	}
	else
	{
		l=n2;
		s=n1;
	}
	for (int j=1; j<=s; j++ )
	{
		if (l%j==0 && s%j==0)
		{
			if (j>f)
			{
				f=j;
			}
		}
	}
	return f;
}

void swap(int &a, int &b)
{
	int c;
	c=a;
	a=b;
	b=c;
}

float qroot1(int a, int b, int c)
{
		float r1,x;
		x= pow(b,2) - ( 4 * a * c);
		r1 = (-b + (sqrt(x)))/ (2*a);
		return r1;
}

float qroot2(int a, int b, int c)
{
	float  r2, x;
	x= pow(b,2) - ( 4 * a * c);
	r2 = (-b - (sqrt(x)))/ (2*a);
	return r2;
}

#endif