#include <windows.h>
#include "resource.h"

#define IDC_EDIT 1001
#define IDC_STATIC 1002
#define IDC_BUTTON 1003

HINSTANCE hInst;
HWND hWndMain, hEdit, hStatic, hCWnd, hButton;
POINT tp;
int tLen;
char txtPss[50];
const MY_TIMER = 1;
LPCSTR lpszAppName = "PssRet";
LPCSTR lpszTitle = "Password Retriever";

LRESULT CALLBACK WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, 
	LPSTR lpCmdLine, int nCmdShow)
	{
	MSG msg;
	HWND hWnd;
	WNDCLASS wc;

	wc.style = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc = (WNDPROC)WndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
	wc.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(SMALL_ICON));
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)(COLOR_BTNFACE+1);
	wc.lpszMenuName = lpszAppName;
	wc.lpszClassName = lpszAppName;

	if(RegisterClass(&wc)==0)
		return (FALSE);

	hInst = hInstance;

	hWndMain = CreateWindowEx(WS_EX_CLIENTEDGE, lpszAppName, lpszTitle, 
		WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_THICKFRAME | 
		WS_MINIMIZEBOX | WS_CLIPCHILDREN, 250, 175, 
		220, 130, NULL, NULL, hInstance, NULL);

	if(hWndMain==0)
		return (FALSE);
	
	ShowWindow(hWndMain, nCmdShow);

	while(GetMessage(&msg, NULL, 0, 0))
		{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
		}

	return(msg.wParam);
	}

LRESULT CALLBACK WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
	{
	switch (uMsg)
		{
		case WM_CREATE:
			hStatic = CreateWindowEx(WS_EX_TRANSPARENT, "STATIC", "Password is Shown Below", 
				WS_CHILD | WS_VISIBLE | ES_LEFT, 
				20, 10, 200, 20, hWnd, (HMENU)IDC_STATIC, hInst, NULL);

			hEdit = CreateWindowEx(WS_EX_CLIENTEDGE, "EDIT", "", WS_CHILD | WS_VISIBLE | ES_LEFT | WS_BORDER, 
				22, 35, 170, 25, hWnd, (HMENU)IDC_EDIT, hInst, NULL);

			hButton = CreateWindowEx(WS_EX_CLIENTEDGE, "BUTTON", "&About", WS_CHILD | WS_VISIBLE | ES_LEFT | WS_BORDER, 
				70, 67, 70, 25, hWnd, (HMENU)IDC_BUTTON, hInst, NULL);

			SetTimer(hWnd, MY_TIMER, 200, NULL);
			break;
		
		case WM_TIMER:
			GetCursorPos(&tp);
			hCWnd = WindowFromPoint(tp);
	        tLen = SendMessage(hCWnd, WM_GETTEXTLENGTH, 0, 0) + 1;
			SendMessage(hCWnd, WM_GETTEXT, tLen, (long)txtPss);
			SetWindowText(hEdit, txtPss);
			break;
		
		case WM_COMMAND:
			switch(LOWORD(wParam))
				{
				case IDC_BUTTON:
					MessageBox(hWnd, 
					"Password Retriever Developed by:\n            Dhruv Matani", 
					"About", MB_OK | MB_ICONINFORMATION);
					 break;
				}
				break;

		case WM_CLOSE:
			DestroyWindow(hWnd);
			KillTimer(hWnd, MY_TIMER);
			break;

		case WM_DESTROY:
			PostQuitMessage(0);
			break;

		default:
			return (DefWindowProc(hWnd, uMsg, wParam, lParam));
		}
		return (0);
	}
