#ifndef _THREAD_H
#define _THREAD_H

#include<windows.h>

void DummyProc() { }

//Main sThread Class
class sThread
{
	public:
		//Function pointers to void, parameterless functions
		void (*OnExecute)();
		void (*OnDestroy)();
		void (*OnTerminate)();
		void (*OnSuspend)();
		void (*OnResume)();


	protected:
		bool terminated;
		DWORD dwChildId;
		HANDLE hThread;

		friend DWORD __stdcall ChildThreadProc(void* p);


	public:

		//This thread's constructor
		sThread(bool CreateSuspended = TRUE)
			{
				DWORD dwCreateFlag = 0;
				if (CreateSuspended == TRUE)
					dwCreateFlag = CREATE_SUSPENDED;

				OnExecute = DummyProc;
				OnTerminate = DummyProc;
				OnDestroy = DummyProc;
				OnSuspend = DummyProc;
				OnResume = DummyProc;
				terminated = FALSE;
 				hThread = CreateThread(NULL, 0, ChildThreadProc, this, dwCreateFlag, &dwChildId);
			}

		//Get this thread's priority level
		int GetPriorityLevel()
			{
				int RetVal = 0;
				if (terminated == FALSE)
					RetVal = GetThreadPriority(hThread);
				
				return (RetVal);
			}

		//Sets the prioriy of this thread
		bool SetPriorityLevel(DWORD Thread_Priority_Level)
			{
			bool RetVal = FALSE;
			if (terminated == FALSE)
				RetVal = SetThreadPriority(hThread, Thread_Priority_Level);
			
			return (RetVal);
			}

		//Suspends execution of this thread
		DWORD Suspend()
			{
			DWORD RetVal = 1000;
			if (terminated == FALSE)
				{	
				RetVal = SuspendThread(hThread);
				OnSuspend();
				}
			return (RetVal);
			}

		//Resumes execution of a suspended thread
		DWORD Resume()
			{
			DWORD RetVal = 1000;
			if (terminated == FALSE)
				{
				RetVal = ResumeThread(hThread);
				OnResume();
				}
			return (RetVal);
			}	

		//Suspends the thread form which it is called until
		//this thread finishes execution
		void WaitFor()
			{
				WaitForSingleObject(hThread, INFINITE);
			}

		//Destructor calls OnDestroy
		virtual ~sThread()
			{
				OnDestroy();
			}

			
};


//Actual Thread Procedure which calls the user defined Procedure
DWORD __stdcall ChildThreadProc(void* p)
	{
		sThread* pt;
		pt = (sThread*)p;
		pt->OnExecute();
		pt->OnTerminate();
		pt->terminated = TRUE;
		ExitThread(TRUE);
		return (0);
	}

#endif