//Weather Temperature Recording Project
//Programmed by : Vivek Patel


//For bugs plz. contact me ---->
//Email : vivek_patel9@rediffmail.com
//Website : www.vivekpatel.cjb.net


//Some facts about project
//->It stores a data file in c:\ (user can change it's to form relative but for sake of simplicity i have taken absolute path).
//->This project is strickly for novice to get familiar with file concepts.
//->Still it find difficulty than feel free to contact me.


#include <iostream.h>
#include <fstream.h>
#include <iomanip.h>
#include <math.h>
#include <conio.h>
#include <string.h>


fstream file;
char year[5]="";

//Non-Member function to find month, to avoid user data-entry
char *returnMonth(int m){
	switch(m){
		case 1 : return("January");
		case 2 : return("February");
		case 3 : return("March");
		case 4 : return("April");
		case 5 : return("May");
		case 6 : return("June");
		case 7 : return("July");
		case 8 : return("August");
		case 9 : return("September");
		case 10 : return("October");
		case 11 : return("November");
		case 12 : return("December");
	}
	return("Invalid");
}

//Non-Member functions, checks for whether file is loaded or not
//it returns 1 if not loaded and 0 otherwise.
int checkFile(){
	if(file==NULL){
	   cout<<"\nThere is No Data to Display\n";
	   getch();
	   return(1);
	}
	return(0);
}

class weather
{
     public:
     double avgtemp[12];
     char month[12][20];
     weather();
     void getdata(int m){ //simple getdata...
	 strcpy(month[m],returnMonth(m)); //avoiding user to input
	 cout<<"\nEnter temperature for "<<month[m]<<" : ?\b";
	 cin>>avgtemp[m];
     }
     void displaydata(int m){ //simple displaydata
	 cout<<setw(20)<<setprecision(2)<<setiosflags(ios::left)
	     <<setiosflags(ios::showpoint)
	     <<month[m]<<setw(10)<<setiosflags(ios::right)<<avgtemp[m];
     }
     void displaytemp(int i){ //Display only Temperature data
	  cout<<setw(10)<<setprecision(2)<<setiosflags(ios::right)
	      <<setiosflags(ios::showpoint)<<avgtemp[i];
     }
     double returntemp(int i){
	  return(avgtemp[i]);
     }
     void loadfile();
     void displaytempscale(); //for displaying temperature scale
     void updatedata(int m,double t)
     {
	strcpy(month[m],returnMonth(m));
	avgtemp[m]=t;
     }
     int validate(double t){ //Validate entered temperature (change to suit ur requirement).
	if(t>55 || t < (-20))
	   return(1); //states that invalid entry
	else
	   return(0); //valid entry
     }
};

weather :: weather(){  //Constructor to intialize object
	for(int i=0;i<12;i++)
	{
		avgtemp[i]=0;
		month[i][0]=NULL;
	}
}

void weather :: loadfile(){  //for Selecting Year or creation of new year file.
	clrscr();
	file.close(); //It is required when trying to open different year files,
		     //while there is already loaded any year file.
	char filename[20]="";
	cout<<"\n*****Select a Year to Work With*****\n\n";
	cout<<"Enter Year (eg: 2001)  : ?\b";
	cin>>year;
	strcat(filename,"c:\\"); //Here i am assuming that path must be c:\
	strcat(filename,"data"); //if u wan't to skip that criteria just remove this lines.
	strcat(filename,year);
	strcat(filename,".dat");
	file.open(filename,ios::ate|ios::nocreate|ios::in|ios::out|ios::binary);
	if(file==NULL){
		char ans;
		cout<<"\nFile Dose Not Exist\n"
		    <<"Do you wan't to create it! (y or n) N : ?\b"; //By default No
		ans=getche();
		if(ans=='y'|| ans=='Y'){
		   file.open(filename,ios::ate|ios::in|ios::out|ios::binary);
		   cout<<"\n\nFile Created Successfully";
		}
		else{
		   file;
		   cout<<"\n\nFail to load data file";
		}
	}
       else if(file!=NULL){
		cout<<"\nData File is successfully loaded";
       }
       getch();
}

void weather :: displaytempscale(){
	int i,c=0;
	cout<<"\n\n";
	for(i=1;i<=70;i++)
	{
	   if(i<=10)
	      cout<<"0";
	   else if(i<=20)
	      cout<<"1";
	   else if(i<=30)
	      cout<<"2";
	   else if(i<=40)
	      cout<<"3";
	   else if(i<=50)
	      cout<<"4";
	   else if(i<=60)
	      cout<<"5";
	   else if(i<=70)
	      cout<<"7";
	}
	cout<<"\n";
	for(i=1;i<=7;i++)
	{
	  for(c=0;c<10;c++)
	    cout<<c;
	}
	cout<<"\n";
}

void intro()
{
	clrscr();
	cout<<"\n\n\n\n\n\n\n\n\t\t\t";
	cout<<"Programmed By : Vivek Patel\n"
	    <<"\t\t\tEmail : vivek_patel9@rediffmail.com\n"
	    <<"\t\t\tWebsite : www.vivekpatel.cjb.net";
	cout<<"\n\n\t\t\t";
	cout<<"Thanks for using this software.";
	getch();
}


void main(){
	char choice='1';
	int cnt,i,j,iNum,totstars=0,location,m;
	double decNum,dNum,high=0,low=99999,avg=0,t;
	char c;
	weather obj;
	file.close();
	do{
		clrscr();
		cout<<"\n*****Main Menu*****\n";
		cout<<"1>  Select a year to work with\n"
		    <<"2>  Display data as Table\n"
		    <<"3>  Display data as horizontal histogram\n"
		    <<"4>  Display Yearly Statistics to date\n"
		    <<"5>  Record Data\n"
		    <<"6>  Change Data\n"
		    <<"7>  Save Data\n"
		    <<"0>  Exit\n"
		    <<"Please enter a number (0...7) => ";
		choice=getche();
		//again for sake of simplicity i have directly return code
		//in case brace rather than going for member-function.
		switch(choice){
			case '0' :  intro();
				    goto out;
			case '1' :  obj.loadfile();
				    break;
			case '2' :  clrscr();
				    cout<<"\n*****Display Data as a Table*****\n\n";
				    if(checkFile()){
				       goto endtable;
				     }
				    cout<<"\nTable of Temperature data for "<<year;
				    cout<<"\n\n";
				    file.seekg(0,ios::end);
				    cnt=file.tellg();
				    cnt=cnt/sizeof(obj); //cnt contains how many records previously recorded
				    file.seekg(0,ios::beg);
				    for(i=1;i<=cnt;i++)
				    {
				       if(i==1)
					    cout<<"\nQuater 1 : ";
				       else if(i==4)
					    cout<<"\nQuater 2 : ";
				       else if(i==7)
					    cout<<"\nQuater 3 : ";
				       else if(i==10)
					    cout<<"\nQuater 4 : ";
				       file.read((char *)&obj, sizeof(obj));
				       if(!file.eof()){
					       obj.displaytemp(i);
					}
					file.clear();
				    }
				    getch();
				    endtable:
				    break;
			case '3' :  clrscr();
				    cout<<"\n*****Display Data as a Horizontal Histogram*****\n\n";
				    if(checkFile()){
				       goto endhistogram;
				    }
				    cout<<"Histogram of Temperature data for "<<year;
				    obj.displaytempscale();
				    file.seekg(0,ios::end);
				    cnt=file.tellg();
				    cnt=cnt/sizeof(obj); //cnt contains how many records previously recorded
				    file.seekg(0,ios::beg);
				    for(i=1;i<=cnt;i++)
				    {
				       cout<<"\n"<<setw(15)<<setiosflags(ios::left)<<returnMonth(i);
				       file.read((char *)&obj, sizeof(obj));
				       if(!file.eof()){
					     decNum=obj.returntemp(i);
					     iNum=floor(decNum);
					     dNum=decNum-iNum; //for finding decimal part.
					     totstars=iNum;
					     if(dNum >= 0.5)
						totstars++;
					     for(j=1;j<=totstars;j++)
						cout<<"*";
					     cout<<"  "<<totstars;
					}
					file.clear();
				    }
				    obj.displaytempscale();
				    getch();
				    endhistogram:
				    break;
			case '4' :  clrscr();
				    cout<<"\n*****Display Yearly Statistics to Date*****\n\n";
				    if(checkFile()){
				       goto endstatus;
				    }
				    cout<<"Temperature Statistics data for "<<year;
				    cnt=file.tellg();
				    cnt=cnt/sizeof(obj); //cnt contains how many records previously recorded
				    file.seekg(0,ios::beg);
				    high=avg=0;
				    low=99999;
				    for(i=1;i<=cnt;i++)
				    {
				       file.read((char *)&obj, sizeof(obj));
				       double tmp=obj.returntemp(i);
				       if(!file.eof()){
					     if(high < tmp)
						high=tmp;
					     if(low > tmp)
						low=tmp;
					     avg=avg+tmp;
					}
					file.clear();
				    }
				    avg=avg/double(cnt);
				    cout<<"\n\nHighest Monthly Average : "<<high;
				    cout<<"\nLowest Monthly Average : "<<low;
				    cout<<"\nAverage Yearly Temperature : "<<avg;
				    getch();
				    endstatus:
				    break;
			case '5' :      clrscr();
					cout<<"\n*****Record Data*****\n\n";
					if(checkFile()){
						goto endRecord;
					    }
					else{
					cnt=file.tellg();
					cnt=cnt/sizeof(obj); //cnt contains how many records previously recorded
					if(cnt==12)
					    cout<<"\n\nData-Entry of "<<year<<" is already been done\n";
					for(i=cnt+1;i<=12;i++)
					{
						enteragain:
						cout<<"\nDo u wan't to enter data for "<<returnMonth(i)<<" (Y or N) Y : ?\b";
						c=getche();
						if(c=='n' || c=='N')
						   goto endRecord;
						obj.getdata(i);
						if(obj.validate(obj.returntemp(i)))
						{
						    cout<<"\nInvalid Data Entry\n";
						    goto enteragain;
						}
						cin.get(c);
						file.write((char *) &obj, sizeof(obj));
					}
				     }
				     getch();
				     endRecord:
				      break;
			case '6' :  clrscr();
				    cout<<"\n*****Change Data*****\n\n";
				    if(checkFile()){
				       goto endchange;
				    }
				    else{
					cnt=file.tellg();
					cnt=cnt/sizeof(obj); //cnt contains how many records previously recorded
					tryagain:
					cout<<"\nEnter Month (in digit) whose temperature is to be changed : ?\b";
					cin>>m;
					if(m <= 0 || m > cnt){
					    cout<<"\n\nInvalid Month\n";
					    getch();
					    goto tryagain;
					}
					tempagain:
					cout<<"\nEnter Temperature : ?\b";
					cin>>t;
					if(obj.validate(t))
					 {
					     cout<<"\nInvalid Data Entry\n";
					     goto tempagain;
					 }
					file.seekg(0,ios::beg);
					location= (m-1) * sizeof(obj);
					file.seekp(location);
					obj.updatedata(m,t);
					 cin.get(c);
					file.write((char *) &obj, sizeof(obj))<<flush;
				     }
				     endchange:
				     break;
			case '7' : clrscr();
				   cout<<"\n*****Store the Current Data*****\n\n";
				   if(checkFile()){
					goto endsave;
				    }
				   flush(file);
				   cout<<"\nData in Memory is Saved successfully\n";
				   getch();
				   endsave:
				   break;
			default  : cout<<"\n\nInvalid Input\n";
				   getch();
		}
	}while(choice!='0');
flush(file);
file.close();
clrscr();
out:
}